/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock;

import com.nukkitx.math.vector.Vector2f;
import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.math.vector.Vector3i;
import com.nukkitx.nbt.NBTInputStream;
import com.nukkitx.nbt.NBTOutputStream;
import com.nukkitx.nbt.NbtType;
import com.nukkitx.nbt.NbtUtils;
import com.nukkitx.network.VarInts;
import com.nukkitx.network.util.Preconditions;
import com.nukkitx.protocol.bedrock.BedrockSession;
import com.nukkitx.protocol.bedrock.data.ExperimentData;
import com.nukkitx.protocol.bedrock.data.GameRuleData;
import com.nukkitx.protocol.bedrock.data.LevelEventType;
import com.nukkitx.protocol.bedrock.data.ResourcePackType;
import com.nukkitx.protocol.bedrock.data.SoundEvent;
import com.nukkitx.protocol.bedrock.data.command.CommandEnumConstraintData;
import com.nukkitx.protocol.bedrock.data.command.CommandEnumConstraintType;
import com.nukkitx.protocol.bedrock.data.command.CommandEnumData;
import com.nukkitx.protocol.bedrock.data.command.CommandOriginData;
import com.nukkitx.protocol.bedrock.data.command.CommandParam;
import com.nukkitx.protocol.bedrock.data.entity.EntityData;
import com.nukkitx.protocol.bedrock.data.entity.EntityDataMap;
import com.nukkitx.protocol.bedrock.data.entity.EntityEventType;
import com.nukkitx.protocol.bedrock.data.entity.EntityFlag;
import com.nukkitx.protocol.bedrock.data.entity.EntityLinkData;
import com.nukkitx.protocol.bedrock.data.inventory.ContainerMixData;
import com.nukkitx.protocol.bedrock.data.inventory.InventoryActionData;
import com.nukkitx.protocol.bedrock.data.inventory.InventorySource;
import com.nukkitx.protocol.bedrock.data.inventory.ItemData;
import com.nukkitx.protocol.bedrock.data.inventory.ItemStackRequest;
import com.nukkitx.protocol.bedrock.data.inventory.PotionMixData;
import com.nukkitx.protocol.bedrock.data.inventory.stackrequestactions.StackRequestActionType;
import com.nukkitx.protocol.bedrock.data.skin.AnimationData;
import com.nukkitx.protocol.bedrock.data.skin.ImageData;
import com.nukkitx.protocol.bedrock.data.skin.SerializedSkin;
import com.nukkitx.protocol.bedrock.data.structure.StructureSettings;
import com.nukkitx.protocol.bedrock.packet.InventoryTransactionPacket;
import com.nukkitx.protocol.bedrock.util.TriConsumer;
import com.nukkitx.protocol.util.Int2ObjectBiMap;
import com.nukkitx.protocol.util.QuadConsumer;
import com.nukkitx.protocol.util.TriFunction;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.util.AsciiString;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;
import java.util.function.ToLongFunction;

public abstract class BedrockPacketHelper {
    protected static final InternalLogger log = InternalLoggerFactory.getInstance(BedrockPacketHelper.class);
    protected final Int2ObjectBiMap<EntityData> entityData = new Int2ObjectBiMap();
    protected final Int2ObjectBiMap<EntityFlag> entityFlags = new Int2ObjectBiMap();
    protected final Int2ObjectBiMap<EntityData.Type> entityDataTypes = new Int2ObjectBiMap();
    protected final Int2ObjectBiMap<EntityEventType> entityEvents = new Int2ObjectBiMap();
    protected final Object2IntMap<Class<?>> gameRuleTypes = new Object2IntOpenHashMap(3, 0.5f);
    protected final Int2ObjectBiMap<SoundEvent> soundEvents = new Int2ObjectBiMap();
    protected final Int2ObjectBiMap<LevelEventType> levelEvents = new Int2ObjectBiMap();
    protected final Int2ObjectBiMap<CommandParam> commandParams = new Int2ObjectBiMap();
    protected final Int2ObjectBiMap<ResourcePackType> resourcePackTypes = new Int2ObjectBiMap();

    protected BedrockPacketHelper() {
        this.gameRuleTypes.defaultReturnValue(-1);
        this.registerEntityDataTypes();
        this.registerEntityData();
        this.registerEntityFlags();
        this.registerEntityEvents();
        this.registerGameRuleTypes();
        this.registerSoundEvents();
        this.registerLevelEvents();
        this.registerCommandParams();
        this.registerResourcePackTypes();
    }

    protected final void addGameRuleType(int index, Class<?> clazz) {
        this.gameRuleTypes.put(clazz, index);
    }

    protected final void addEntityData(int index, EntityData entityData) {
        this.entityData.put(index, entityData);
    }

    protected final void addEntityFlag(int index, EntityFlag flag) {
        this.entityFlags.put(index, flag);
    }

    protected final void addEntityDataType(int index, EntityData.Type type) {
        this.entityDataTypes.put(index, type);
    }

    protected final void addEntityEvent(int index, EntityEventType type) {
        this.entityEvents.put(index, type);
    }

    protected final void addSoundEvent(int index, SoundEvent soundEvent) {
        this.soundEvents.put(index, soundEvent);
    }

    protected final void addLevelEvent(int index, LevelEventType levelEventType) {
        this.levelEvents.put(index, levelEventType);
    }

    public final int getEntityEventId(EntityEventType type) {
        if (!this.entityEvents.containsValue(type)) {
            log.debug("Unknown EntityEventType: {}", (Object)type);
            return this.entityEvents.get(EntityEventType.NONE);
        }
        return this.entityEvents.get(type);
    }

    public final EntityEventType getEntityEvent(int id) {
        if (!this.entityEvents.containsKey(id)) {
            log.debug("Unknown EntityEvent: {}", (Object)id);
            return EntityEventType.NONE;
        }
        return this.entityEvents.get(id);
    }

    public final int getSoundEventId(SoundEvent event) {
        if (!this.soundEvents.containsValue(event)) {
            log.debug("Unknown SoundEvent {} received", (Object)event);
            return this.soundEvents.get(SoundEvent.UNDEFINED);
        }
        return this.soundEvents.get(event);
    }

    public final SoundEvent getSoundEvent(int id) {
        SoundEvent soundEvent = this.soundEvents.get(id);
        if (soundEvent == null) {
            log.debug("Unknown SoundEvent {} received", (Object)Integer.toUnsignedLong(id));
            return SoundEvent.UNDEFINED;
        }
        return soundEvent;
    }

    public final int getLevelEventId(LevelEventType event) {
        if (!this.levelEvents.containsValue(event)) {
            log.debug("Unknown LevelEventType: {}", (Object)event);
            return this.levelEvents.get(LevelEventType.UNDEFINED);
        }
        return this.levelEvents.get(event);
    }

    public final LevelEventType getLevelEvent(int id) {
        LevelEventType levelEvent = this.levelEvents.get(id);
        if (levelEvent == null) {
            log.debug("Unknown LevelEventType {} received", (Object)id);
            return LevelEventType.UNDEFINED;
        }
        return levelEvent;
    }

    public final void addCommandParam(int index, CommandParam commandParam) {
        this.commandParams.put(index, commandParam);
    }

    public final CommandParam getCommandParam(int index) {
        CommandParam commandParam = this.commandParams.get(index);
        if (commandParam == null) {
            log.debug("Requested undefined CommandParam {}", (Object)index);
            return new CommandParam(index);
        }
        return commandParam;
    }

    public final int getCommandParamId(CommandParam commandParam) {
        return this.commandParams.get(commandParam);
    }

    public final void removeCommandParam(int index) {
        this.commandParams.remove(index);
    }

    public final void removeCommandParam(CommandParam type) {
        this.commandParams.remove(type);
    }

    public final void addResourcePackType(int index, ResourcePackType resourcePackType) {
        this.resourcePackTypes.put(index, resourcePackType);
    }

    public final ResourcePackType getResourcePackType(int index) {
        return this.resourcePackTypes.get(index);
    }

    public final int getResourcePackTypeId(ResourcePackType resourcePackType) {
        return this.resourcePackTypes.get(resourcePackType);
    }

    protected abstract void registerEntityData();

    protected abstract void registerEntityFlags();

    protected abstract void registerEntityDataTypes();

    protected abstract void registerEntityEvents();

    protected abstract void registerGameRuleTypes();

    protected abstract void registerSoundEvents();

    protected abstract void registerCommandParams();

    protected abstract void registerResourcePackTypes();

    protected abstract void registerLevelEvents();

    public abstract EntityLinkData readEntityLink(ByteBuf var1);

    public abstract void writeEntityLink(ByteBuf var1, EntityLinkData var2);

    public abstract ItemData readNetItem(ByteBuf var1, BedrockSession var2);

    public abstract void writeNetItem(ByteBuf var1, ItemData var2, BedrockSession var3);

    public abstract ItemData readItem(ByteBuf var1, BedrockSession var2);

    public abstract void writeItem(ByteBuf var1, ItemData var2, BedrockSession var3);

    public abstract ItemData readItemInstance(ByteBuf var1, BedrockSession var2);

    public abstract void writeItemInstance(ByteBuf var1, ItemData var2, BedrockSession var3);

    public abstract CommandOriginData readCommandOrigin(ByteBuf var1);

    public abstract void writeCommandOrigin(ByteBuf var1, CommandOriginData var2);

    public abstract GameRuleData<?> readGameRule(ByteBuf var1);

    public abstract void writeGameRule(ByteBuf var1, GameRuleData<?> var2);

    public abstract void readEntityData(ByteBuf var1, EntityDataMap var2);

    public abstract void writeEntityData(ByteBuf var1, EntityDataMap var2);

    public abstract CommandEnumData readCommandEnum(ByteBuf var1, boolean var2);

    public abstract void writeCommandEnum(ByteBuf var1, CommandEnumData var2);

    public abstract StructureSettings readStructureSettings(ByteBuf var1);

    public abstract void writeStructureSettings(ByteBuf var1, StructureSettings var2);

    public abstract SerializedSkin readSkin(ByteBuf var1);

    public abstract void writeSkin(ByteBuf var1, SerializedSkin var2);

    public abstract AnimationData readAnimationData(ByteBuf var1);

    public abstract void writeAnimationData(ByteBuf var1, AnimationData var2);

    public abstract ImageData readImage(ByteBuf var1);

    public abstract void writeImage(ByteBuf var1, ImageData var2);

    public byte[] readByteArray(ByteBuf buffer) {
        Preconditions.checkNotNull(buffer, "buffer");
        int length = VarInts.readUnsignedInt(buffer);
        Preconditions.checkArgument(buffer.isReadable(length), "Tried to read %s bytes but only has %s readable", length, buffer.readableBytes());
        byte[] bytes = new byte[length];
        buffer.readBytes(bytes);
        return bytes;
    }

    public void writeByteArray(ByteBuf buffer, byte[] bytes) {
        Preconditions.checkNotNull(buffer, "buffer");
        Preconditions.checkNotNull(bytes, "bytes");
        VarInts.writeUnsignedInt(buffer, bytes.length);
        buffer.writeBytes(bytes);
    }

    public ByteBuf readBuffer(ByteBuf buffer) {
        int length = VarInts.readUnsignedInt(buffer);
        return buffer.readRetainedSlice(length);
    }

    public void writeBuffer(ByteBuf buffer, ByteBuf toWrite) {
        Preconditions.checkNotNull(toWrite, "toWrite");
        VarInts.writeUnsignedInt(buffer, toWrite.readableBytes());
        buffer.writeBytes(toWrite, toWrite.readerIndex(), toWrite.writerIndex());
    }

    public String readString(ByteBuf buffer) {
        Preconditions.checkNotNull(buffer, "buffer");
        return new String(this.readByteArray(buffer), StandardCharsets.UTF_8);
    }

    public void writeString(ByteBuf buffer, String string) {
        Preconditions.checkNotNull(buffer, "buffer");
        Preconditions.checkNotNull(string, "string");
        this.writeByteArray(buffer, string.getBytes(StandardCharsets.UTF_8));
    }

    public AsciiString readLEAsciiString(ByteBuf buffer) {
        Preconditions.checkNotNull(buffer, "buffer");
        CharSequence string = buffer.readCharSequence(buffer.readIntLE(), StandardCharsets.US_ASCII);
        if (string instanceof AsciiString) {
            return (AsciiString)string;
        }
        return new AsciiString(string);
    }

    public void writeLEAsciiString(ByteBuf buffer, AsciiString string) {
        Preconditions.checkNotNull(buffer, "buffer");
        Preconditions.checkNotNull(string, "string");
        buffer.writeIntLE(string.length());
        buffer.writeCharSequence(string, StandardCharsets.US_ASCII);
    }

    public UUID readUuid(ByteBuf buffer) {
        Preconditions.checkNotNull(buffer, "buffer");
        return new UUID(buffer.readLongLE(), buffer.readLongLE());
    }

    public void writeUuid(ByteBuf buffer, UUID uuid) {
        Preconditions.checkNotNull(buffer, "buffer");
        Preconditions.checkNotNull(uuid, "uuid");
        buffer.writeLongLE(uuid.getMostSignificantBits());
        buffer.writeLongLE(uuid.getLeastSignificantBits());
    }

    public Vector3f readVector3f(ByteBuf buffer) {
        Preconditions.checkNotNull(buffer, "buffer");
        float x = buffer.readFloatLE();
        float y = buffer.readFloatLE();
        float z = buffer.readFloatLE();
        return Vector3f.from(x, y, z);
    }

    public void writeVector3f(ByteBuf buffer, Vector3f vector3f) {
        Preconditions.checkNotNull(buffer, "buffer");
        Preconditions.checkNotNull(vector3f, "vector3f");
        buffer.writeFloatLE(vector3f.getX());
        buffer.writeFloatLE(vector3f.getY());
        buffer.writeFloatLE(vector3f.getZ());
    }

    public Vector2f readVector2f(ByteBuf buffer) {
        Preconditions.checkNotNull(buffer, "buffer");
        float x = buffer.readFloatLE();
        float y = buffer.readFloatLE();
        return Vector2f.from(x, y);
    }

    public void writeVector2f(ByteBuf buffer, Vector2f vector2f) {
        Preconditions.checkNotNull(buffer, "buffer");
        Preconditions.checkNotNull(vector2f, "vector2f");
        buffer.writeFloatLE(vector2f.getX());
        buffer.writeFloatLE(vector2f.getY());
    }

    public Vector3i readVector3i(ByteBuf buffer) {
        Preconditions.checkNotNull(buffer, "buffer");
        int x = VarInts.readInt(buffer);
        int y = VarInts.readInt(buffer);
        int z = VarInts.readInt(buffer);
        return Vector3i.from(x, y, z);
    }

    public void writeVector3i(ByteBuf buffer, Vector3i vector3i) {
        Preconditions.checkNotNull(buffer, "buffer");
        Preconditions.checkNotNull(vector3i, "vector3i");
        VarInts.writeInt(buffer, vector3i.getX());
        VarInts.writeInt(buffer, vector3i.getY());
        VarInts.writeInt(buffer, vector3i.getZ());
    }

    public Vector3i readBlockPosition(ByteBuf buffer) {
        Preconditions.checkNotNull(buffer, "buffer");
        int x = VarInts.readInt(buffer);
        int y = VarInts.readUnsignedInt(buffer);
        int z = VarInts.readInt(buffer);
        return Vector3i.from(x, y, z);
    }

    public void writeBlockPosition(ByteBuf buffer, Vector3i blockPosition) {
        Preconditions.checkNotNull(buffer, "buffer");
        Preconditions.checkNotNull(blockPosition, "blockPosition");
        VarInts.writeInt(buffer, blockPosition.getX());
        VarInts.writeUnsignedInt(buffer, blockPosition.getY());
        VarInts.writeInt(buffer, blockPosition.getZ());
    }

    public Vector3f readByteRotation(ByteBuf buffer) {
        Preconditions.checkNotNull(buffer, "buffer");
        float pitch = this.readByteAngle(buffer);
        float yaw = this.readByteAngle(buffer);
        float roll = this.readByteAngle(buffer);
        return Vector3f.from(pitch, yaw, roll);
    }

    public void writeByteRotation(ByteBuf buffer, Vector3f rotation) {
        Preconditions.checkNotNull(buffer, "buffer");
        Preconditions.checkNotNull(rotation, "rotation");
        this.writeByteAngle(buffer, rotation.getX());
        this.writeByteAngle(buffer, rotation.getY());
        this.writeByteAngle(buffer, rotation.getZ());
    }

    public float readByteAngle(ByteBuf buffer) {
        Preconditions.checkNotNull(buffer, "buffer");
        return (float)buffer.readByte() * 1.40625f;
    }

    public void writeByteAngle(ByteBuf buffer, float angle) {
        Preconditions.checkNotNull(buffer, "buffer");
        buffer.writeByte((byte)(angle / 1.40625f));
    }

    public <T> void readArray(ByteBuf buffer, Collection<T> array, BiFunction<ByteBuf, BedrockPacketHelper, T> function) {
        this.readArray(buffer, array, VarInts::readUnsignedInt, function);
    }

    public <T> void readArray(ByteBuf buffer, Collection<T> array, ToLongFunction<ByteBuf> lengthReader, BiFunction<ByteBuf, BedrockPacketHelper, T> function) {
        long length = lengthReader.applyAsLong(buffer);
        int i = 0;
        while ((long)i < length) {
            array.add(function.apply(buffer, this));
            ++i;
        }
    }

    public <T> void writeArray(ByteBuf buffer, Collection<T> array, TriConsumer<ByteBuf, BedrockPacketHelper, T> consumer) {
        this.writeArray(buffer, array, VarInts::writeUnsignedInt, consumer);
    }

    public <T> void writeArray(ByteBuf buffer, Collection<T> array, ObjIntConsumer<ByteBuf> lengthWriter, TriConsumer<ByteBuf, BedrockPacketHelper, T> consumer) {
        lengthWriter.accept(buffer, array.size());
        for (T val : array) {
            consumer.accept(buffer, this, (ByteBuf)val);
        }
    }

    public <T> void readArray(ByteBuf buffer, Collection<T> array, BedrockSession session, TriFunction<ByteBuf, BedrockPacketHelper, BedrockSession, T> function) {
        int length = VarInts.readUnsignedInt(buffer);
        for (int i = 0; i < length; ++i) {
            array.add(function.apply(buffer, this, session));
        }
    }

    public <T> void writeArray(ByteBuf buffer, Collection<T> array, BedrockSession session, QuadConsumer<ByteBuf, BedrockPacketHelper, BedrockSession, T> consumer) {
        VarInts.writeUnsignedInt(buffer, array.size());
        for (T val : array) {
            consumer.accept(buffer, this, session, (ByteBuf)val);
        }
    }

    public <T> T[] readArray(ByteBuf buffer, T[] array, BiFunction<ByteBuf, BedrockPacketHelper, T> function) {
        ObjectArrayList list = new ObjectArrayList();
        this.readArray(buffer, (Collection<T>)list, function);
        return list.toArray((Object[])array);
    }

    public <T> void writeArray(ByteBuf buffer, T[] array, TriConsumer<ByteBuf, BedrockPacketHelper, T> consumer) {
        VarInts.writeUnsignedInt(buffer, array.length);
        for (T val : array) {
            consumer.accept(buffer, this, (ByteBuf)val);
        }
    }

    public <T> T[] readArray(ByteBuf buffer, T[] array, BedrockSession session, TriFunction<ByteBuf, BedrockPacketHelper, BedrockSession, T> function) {
        ObjectArrayList list = new ObjectArrayList();
        this.readArray(buffer, (Collection<T>)list, session, function);
        return list.toArray((Object[])array);
    }

    public <T> void writeArray(ByteBuf buffer, T[] array, BedrockSession session, QuadConsumer<ByteBuf, BedrockPacketHelper, BedrockSession, T> consumer) {
        VarInts.writeUnsignedInt(buffer, array.length);
        for (T val : array) {
            consumer.accept(buffer, this, session, (ByteBuf)val);
        }
    }

    public <T> void readArray(ByteBuf buffer, Collection<T> array, Function<ByteBuf, T> function) {
        int length = VarInts.readUnsignedInt(buffer);
        for (int i = 0; i < length; ++i) {
            array.add(function.apply(buffer));
        }
    }

    public <T> void writeArray(ByteBuf buffer, Collection<T> array, BiConsumer<ByteBuf, T> biConsumer) {
        VarInts.writeUnsignedInt(buffer, array.size());
        for (T val : array) {
            biConsumer.accept(buffer, (ByteBuf)val);
        }
    }

    public <T> T[] readArray(ByteBuf buffer, T[] array, Function<ByteBuf, T> function) {
        ObjectArrayList list = new ObjectArrayList();
        this.readArray(buffer, (Collection<T>)list, function);
        return list.toArray((Object[])array);
    }

    public <T> void writeArray(ByteBuf buffer, T[] array, BiConsumer<ByteBuf, T> biConsumer) {
        VarInts.writeUnsignedInt(buffer, array.length);
        for (T val : array) {
            biConsumer.accept(buffer, (ByteBuf)val);
        }
    }

    public <T> void readArrayShortLE(ByteBuf buffer, Collection<T> array, Function<ByteBuf, T> function) {
        int length = buffer.readUnsignedShortLE();
        for (int i = 0; i < length; ++i) {
            array.add(function.apply(buffer));
        }
    }

    public <T> void writeArrayShortLE(ByteBuf buffer, Collection<T> array, BiConsumer<ByteBuf, T> biConsumer) {
        buffer.writeShortLE(array.size());
        for (T val : array) {
            biConsumer.accept(buffer, (ByteBuf)val);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T readTag(ByteBuf buffer) {
        try (NBTInputStream reader = NbtUtils.createNetworkReader(new ByteBufInputStream(buffer));){
            Object object = reader.readTag();
            return (T)object;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> void writeTag(ByteBuf buffer, T tag) {
        try (NBTOutputStream writer = NbtUtils.createNetworkWriter(new ByteBufOutputStream(buffer));){
            writer.writeTag(tag);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T readTagValue(ByteBuf buffer, NbtType<T> type) {
        try (NBTInputStream reader = NbtUtils.createNetworkReader(new ByteBufInputStream(buffer));){
            T t2 = reader.readValue(type);
            return t2;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> void writeTagValue(ByteBuf buffer, T tag) {
        try (NBTOutputStream writer = NbtUtils.createNetworkWriter(new ByteBufOutputStream(buffer));){
            writer.writeValue(tag);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void readItemUse(ByteBuf buffer, InventoryTransactionPacket packet, BedrockSession session) {
        packet.setActionType(VarInts.readUnsignedInt(buffer));
        packet.setBlockPosition(this.readBlockPosition(buffer));
        packet.setBlockFace(VarInts.readInt(buffer));
        packet.setHotbarSlot(VarInts.readInt(buffer));
        packet.setItemInHand(this.readItem(buffer, session));
        packet.setPlayerPosition(this.readVector3f(buffer));
        packet.setClickPosition(this.readVector3f(buffer));
    }

    public void writeItemUse(ByteBuf buffer, InventoryTransactionPacket packet, BedrockSession session) {
        VarInts.writeUnsignedInt(buffer, packet.getActionType());
        this.writeBlockPosition(buffer, packet.getBlockPosition());
        VarInts.writeInt(buffer, packet.getBlockFace());
        VarInts.writeInt(buffer, packet.getHotbarSlot());
        this.writeItem(buffer, packet.getItemInHand(), session);
        this.writeVector3f(buffer, packet.getPlayerPosition());
        this.writeVector3f(buffer, packet.getClickPosition());
    }

    public boolean readInventoryActions(ByteBuf buffer, BedrockSession session, List<InventoryActionData> actions) {
        this.readArray(buffer, actions, session, (ByteBuf buf, BedrockPacketHelper helper, BedrockSession aSession) -> {
            InventorySource source = helper.readSource((ByteBuf)buf);
            int slot = VarInts.readUnsignedInt(buf);
            ItemData fromItem = helper.readItem((ByteBuf)buf, (BedrockSession)aSession);
            ItemData toItem = helper.readItem((ByteBuf)buf, (BedrockSession)aSession);
            return new InventoryActionData(source, slot, fromItem, toItem);
        });
        return false;
    }

    public void writeInventoryActions(ByteBuf buffer, BedrockSession session, List<InventoryActionData> actions, boolean hasNetworkIds) {
        this.writeArray(buffer, actions, session, (ByteBuf buf, BedrockPacketHelper helper, BedrockSession aSession, T action) -> {
            helper.writeSource((ByteBuf)buf, action.getSource());
            VarInts.writeUnsignedInt(buf, action.getSlot());
            helper.writeItem((ByteBuf)buf, action.getFromItem(), (BedrockSession)aSession);
            helper.writeItem((ByteBuf)buf, action.getToItem(), (BedrockSession)aSession);
        });
    }

    public InventorySource readSource(ByteBuf buffer) {
        InventorySource.Type type = InventorySource.Type.byId(VarInts.readUnsignedInt(buffer));
        switch (type) {
            case CONTAINER: {
                int containerId = VarInts.readInt(buffer);
                return InventorySource.fromContainerWindowId(containerId);
            }
            case GLOBAL: {
                return InventorySource.fromGlobalInventory();
            }
            case WORLD_INTERACTION: {
                InventorySource.Flag flag = InventorySource.Flag.values()[VarInts.readUnsignedInt(buffer)];
                return InventorySource.fromWorldInteraction(flag);
            }
            case CREATIVE: {
                return InventorySource.fromCreativeInventory();
            }
            case NON_IMPLEMENTED_TODO: {
                int containerId = VarInts.readInt(buffer);
                return InventorySource.fromNonImplementedTodo(containerId);
            }
        }
        return InventorySource.fromInvalid();
    }

    public void writeSource(ByteBuf buffer, InventorySource inventorySource) {
        Objects.requireNonNull(inventorySource, "InventorySource was null");
        VarInts.writeUnsignedInt(buffer, inventorySource.getType().id());
        switch (inventorySource.getType()) {
            case CONTAINER: 
            case NON_IMPLEMENTED_TODO: 
            case UNTRACKED_INTERACTION_UI: {
                VarInts.writeInt(buffer, inventorySource.getContainerId());
                break;
            }
            case WORLD_INTERACTION: {
                VarInts.writeUnsignedInt(buffer, inventorySource.getFlag().ordinal());
            }
        }
    }

    public ItemData readRecipeIngredient(ByteBuf buffer) {
        Objects.requireNonNull(buffer, "buffer is null");
        int id = VarInts.readInt(buffer);
        if (id == 0) {
            return ItemData.AIR;
        }
        int meta = VarInts.readInt(buffer);
        int count = VarInts.readInt(buffer);
        return ItemData.builder().id(id).damage(meta).count(count).build();
    }

    public void writeRecipeIngredient(ByteBuf buffer, ItemData item) {
        Objects.requireNonNull(buffer, "buffer is null");
        Objects.requireNonNull(item, "item is null");
        VarInts.writeInt(buffer, item.getId());
        if (item.getId() == 0) {
            return;
        }
        VarInts.writeInt(buffer, item.getDamage());
        VarInts.writeInt(buffer, item.getCount());
    }

    public PotionMixData readPotionRecipe(ByteBuf buffer) {
        Objects.requireNonNull(buffer, "buffer is null");
        return new PotionMixData(VarInts.readInt(buffer), VarInts.readInt(buffer), VarInts.readInt(buffer), VarInts.readInt(buffer), VarInts.readInt(buffer), VarInts.readInt(buffer));
    }

    public void writePotionRecipe(ByteBuf buffer, PotionMixData data) {
        Objects.requireNonNull(buffer, "buffer is null");
        Objects.requireNonNull(data, "data is null");
        VarInts.writeInt(buffer, data.getInputId());
        VarInts.writeInt(buffer, data.getInputMeta());
        VarInts.writeInt(buffer, data.getReagentId());
        VarInts.writeInt(buffer, data.getReagentMeta());
        VarInts.writeInt(buffer, data.getOutputId());
        VarInts.writeInt(buffer, data.getOutputMeta());
    }

    public ContainerMixData readContainerChangeRecipe(ByteBuf buffer) {
        Objects.requireNonNull(buffer, "buffer is null");
        return new ContainerMixData(VarInts.readInt(buffer), VarInts.readInt(buffer), VarInts.readInt(buffer));
    }

    public void writeContainerChangeRecipe(ByteBuf buffer, ContainerMixData data) {
        Objects.requireNonNull(buffer, "buffer is null");
        Objects.requireNonNull(data, "data is null");
        VarInts.writeInt(buffer, data.getInputId());
        VarInts.writeInt(buffer, data.getReagentId());
        VarInts.writeInt(buffer, data.getOutputId());
    }

    public CommandEnumConstraintData readCommandEnumConstraints(ByteBuf buffer, List<CommandEnumData> enums, List<String> enumValues) {
        int valueIndex = buffer.readIntLE();
        int enumIndex = buffer.readIntLE();
        CommandEnumConstraintType[] constraints = this.readArray(buffer, new CommandEnumConstraintType[0], (ByteBuf buf) -> CommandEnumConstraintType.byId(buffer.readByte()));
        return new CommandEnumConstraintData(enumValues.get(valueIndex), enums.get(enumIndex), constraints);
    }

    public void writeCommandEnumConstraints(ByteBuf buffer, CommandEnumConstraintData data, List<CommandEnumData> enums, List<String> enumValues) {
        buffer.writeIntLE(enumValues.indexOf(data.getOption()));
        buffer.writeIntLE(enums.indexOf(data.getEnumData()));
        this.writeArray(buffer, data.getConstraints(), (ByteBuf buf, T constraint) -> buf.writeByte(constraint.ordinal()));
    }

    public boolean isBlockingItem(int id, BedrockSession session) {
        int blockingId = session.getHardcodedBlockingId().get();
        return id == blockingId;
    }

    public String getBlockingItemIdentifier() {
        return "minecraft:shield";
    }

    public void readExperiments(ByteBuf buffer, List<ExperimentData> experiments) {
        throw new UnsupportedOperationException();
    }

    public void writeExperiments(ByteBuf buffer, List<ExperimentData> experiments) {
        throw new UnsupportedOperationException();
    }

    protected void registerStackActionRequestTypes() {
        throw new UnsupportedOperationException();
    }

    public StackRequestActionType getStackRequestActionTypeFromId(int id) {
        throw new UnsupportedOperationException();
    }

    public int getIdFromStackRequestActionType(StackRequestActionType type) {
        throw new UnsupportedOperationException();
    }

    public ItemStackRequest readItemStackRequest(ByteBuf buffer, BedrockSession session) {
        throw new UnsupportedOperationException();
    }

    public void writeItemStackRequest(ByteBuf buffer, BedrockSession session, ItemStackRequest request) {
        throw new UnsupportedOperationException();
    }

    public <O> O readOptional(ByteBuf buffer, O emptyValue, Function<ByteBuf, O> function) {
        if (buffer.readBoolean()) {
            return function.apply(buffer);
        }
        return emptyValue;
    }

    public <T> void writeOptional(ByteBuf buffer, Predicate<T> isPresent, T object, BiConsumer<ByteBuf, T> consumer) {
        Preconditions.checkNotNull(object, "object");
        Preconditions.checkNotNull(consumer, "read consumer");
        boolean exists = isPresent.test(object);
        buffer.writeBoolean(exists);
        if (exists) {
            consumer.accept(buffer, (ByteBuf)object);
        }
    }
}

