/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.network.raknet.pipeline;

import com.nukkitx.network.raknet.RakNetServer;
import com.nukkitx.network.raknet.RakNetServerSession;
import com.nukkitx.network.raknet.proxy.HAProxyMessage;
import com.nukkitx.network.raknet.proxy.HAProxyProtocolException;
import com.nukkitx.network.raknet.proxy.ProxyProtocolDecoder;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.DatagramPacket;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;

@ChannelHandler.Sharable
public class ProxyServerHandler
extends SimpleChannelInboundHandler<DatagramPacket> {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(ProxyServerHandler.class);
    public static final String NAME = "rak-proxy-server-handler";
    private final RakNetServer server;

    public ProxyServerHandler(RakNetServer server) {
        this.server = server;
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, DatagramPacket packet) throws Exception {
        ByteBuf content = (ByteBuf)packet.content();
        RakNetServerSession session = this.server.getSession((InetSocketAddress)packet.sender());
        int detectedVersion = session != null ? -1 : ProxyProtocolDecoder.findVersion(content);
        InetSocketAddress presentAddress = this.server.getProxiedAddress((InetSocketAddress)packet.sender());
        if (presentAddress == null && detectedVersion == -1) {
            return;
        }
        if (presentAddress == null) {
            HAProxyMessage decoded;
            try {
                decoded = ProxyProtocolDecoder.decode(content, detectedVersion);
                if (decoded == null) {
                    return;
                }
            }
            catch (HAProxyProtocolException e) {
                log.debug("{} sent malformed PROXY header", packet.sender(), (Object)e);
                return;
            }
            presentAddress = decoded.sourceInetSocketAddress();
            log.debug("Got PROXY header: (from {}) {}", packet.sender(), (Object)presentAddress);
            if (log.isDebugEnabled()) {
                log.debug("PROXY Headers map size: {}", (Object)this.server.getProxiedAddressSize());
            }
            this.server.addProxiedAddress((InetSocketAddress)packet.sender(), presentAddress);
            return;
        }
        log.trace("Reusing PROXY header: (from {}) {}", packet.sender(), (Object)presentAddress);
        InetAddress address = presentAddress.getAddress();
        if (address == null || !this.server.isBlocked(address)) {
            ctx.fireChannelRead(packet.retain());
        }
    }
}

