/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.network.raknet;

import com.nukkitx.network.SessionConnection;
import com.nukkitx.network.raknet.EncapsulatedPacket;
import com.nukkitx.network.raknet.RakMetrics;
import com.nukkitx.network.raknet.RakNet;
import com.nukkitx.network.raknet.RakNetConstants;
import com.nukkitx.network.raknet.RakNetDatagram;
import com.nukkitx.network.raknet.RakNetPriority;
import com.nukkitx.network.raknet.RakNetReliability;
import com.nukkitx.network.raknet.RakNetSessionListener;
import com.nukkitx.network.raknet.RakNetSlidingWindow;
import com.nukkitx.network.raknet.RakNetState;
import com.nukkitx.network.raknet.RakNetUtils;
import com.nukkitx.network.raknet.util.BitQueue;
import com.nukkitx.network.raknet.util.FastBinaryMinHeap;
import com.nukkitx.network.raknet.util.IntRange;
import com.nukkitx.network.raknet.util.RoundRobinArray;
import com.nukkitx.network.raknet.util.SplitPacketHelper;
import com.nukkitx.network.util.DisconnectReason;
import com.nukkitx.network.util.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.EventLoop;
import io.netty.channel.socket.DatagramPacket;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.Inet6Address;
import java.net.InetSocketAddress;
import java.util.Queue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public abstract class RakNetSession
implements SessionConnection<ByteBuf> {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(RakNetSession.class);
    final InetSocketAddress address;
    InetSocketAddress proxiedAddress = null;
    final Channel channel;
    final EventLoop eventLoop;
    final int protocolVersion;
    private int mtu;
    private int adjustedMtu;
    long guid;
    private volatile RakNetState state = RakNetState.UNCONNECTED;
    private volatile long lastTouched = System.currentTimeMillis();
    private volatile boolean closed = false;
    private RakNetSlidingWindow slidingWindow;
    private int splitIndex;
    private int datagramReadIndex;
    private int datagramWriteIndex;
    private int reliabilityReadIndex;
    private int reliabilityWriteIndex;
    private int[] orderReadIndex;
    private int[] orderWriteIndex;
    private RoundRobinArray<SplitPacketHelper> splitPackets;
    private BitQueue reliableDatagramQueue;
    private FastBinaryMinHeap<EncapsulatedPacket> outgoingPackets;
    private long[] outgoingPacketNextWeights;
    private FastBinaryMinHeap<EncapsulatedPacket>[] orderingHeaps;
    private volatile RakNetSessionListener listener = null;
    private volatile long currentPingTime = -1L;
    private volatile long lastPingTime = -1L;
    private volatile long lastPongTime = -1L;
    private ConcurrentMap<Integer, RakNetDatagram> sentDatagrams;
    private Queue<IntRange> incomingAcks;
    private Queue<IntRange> incomingNaks;
    private Queue<IntRange> outgoingAcks;
    private Queue<IntRange> outgoingNaks;
    private int unackedBytes;
    private long lastMinWeight;
    private int sessionTimeout = 30000;

    RakNetSession(InetSocketAddress address, Channel channel, EventLoop eventLoop, int mtu, int protocolVersion) {
        this.address = address;
        this.channel = channel;
        this.eventLoop = eventLoop;
        this.setMtu(mtu);
        this.protocolVersion = protocolVersion;
    }

    final void initialize() {
        Preconditions.checkState(this.state == RakNetState.INITIALIZING);
        this.slidingWindow = new RakNetSlidingWindow(this.mtu);
        this.reliableDatagramQueue = new BitQueue(512);
        this.orderReadIndex = new int[16];
        this.orderWriteIndex = new int[16];
        this.orderingHeaps = new FastBinaryMinHeap[16];
        this.splitPackets = new RoundRobinArray(256);
        this.sentDatagrams = new ConcurrentSkipListMap<Integer, RakNetDatagram>();
        for (int i = 0; i < 16; ++i) {
            this.orderingHeaps[i] = new FastBinaryMinHeap(64);
        }
        this.outgoingPackets = new FastBinaryMinHeap(8);
        this.incomingAcks = PlatformDependent.newMpscQueue();
        this.incomingNaks = PlatformDependent.newMpscQueue();
        this.outgoingAcks = PlatformDependent.newMpscQueue();
        this.outgoingNaks = PlatformDependent.newMpscQueue();
        this.outgoingPacketNextWeights = new long[4];
        this.initHeapWeights();
    }

    private void deinitialize() {
        if (this.splitPackets != null) {
            this.splitPackets.forEach(ReferenceCountUtil::release);
        }
        if (this.sentDatagrams != null) {
            this.sentDatagrams.values().forEach(ReferenceCountUtil::release);
        }
        FastBinaryMinHeap<EncapsulatedPacket>[] orderingHeaps = this.orderingHeaps;
        this.orderingHeaps = null;
        if (orderingHeaps != null) {
            for (FastBinaryMinHeap<EncapsulatedPacket> orderingHeap : orderingHeaps) {
                EncapsulatedPacket packet;
                while ((packet = orderingHeap.poll()) != null) {
                    packet.release();
                }
            }
        }
        FastBinaryMinHeap<EncapsulatedPacket> outgoingPackets = this.outgoingPackets;
        this.outgoingPackets = null;
        if (outgoingPackets != null) {
            EncapsulatedPacket packet;
            while ((packet = outgoingPackets.poll()) != null) {
                packet.release();
            }
        }
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.address;
    }

    @Override
    public InetSocketAddress getRealAddress() {
        InetSocketAddress proxied = this.proxiedAddress;
        return proxied == null ? this.address : proxied;
    }

    public int getMtu() {
        return this.mtu;
    }

    void setMtu(int mtu) {
        this.mtu = RakNetUtils.clamp(mtu, 576, RakNetConstants.MAXIMUM_MTU_SIZE);
        this.adjustedMtu = this.mtu - 8 - (this.address.getAddress() instanceof Inet6Address ? 40 : 20);
        this.slidingWindow = new RakNetSlidingWindow(this.mtu);
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    @Override
    public long getPing() {
        return this.lastPongTime - this.lastPingTime;
    }

    public double getRTT() {
        return this.slidingWindow.getRTT();
    }

    public ByteBuf allocateBuffer(int capacity) {
        return this.channel.alloc().ioBuffer(capacity);
    }

    private void initHeapWeights() {
        for (int priorityLevel = 0; priorityLevel < 4; ++priorityLevel) {
            this.outgoingPacketNextWeights[priorityLevel] = (1L << priorityLevel) * (long)priorityLevel + (long)priorityLevel;
        }
    }

    private long getNextWeight(RakNetPriority priority) {
        int priorityLevel = priority.ordinal();
        long next = this.outgoingPacketNextWeights[priorityLevel];
        if (!this.outgoingPackets.isEmpty()) {
            if (next >= this.lastMinWeight) {
                next = this.lastMinWeight + (1L << priorityLevel) * (long)priorityLevel + (long)priorityLevel;
                this.outgoingPacketNextWeights[priorityLevel] = next + (1L << priorityLevel) * (long)(priorityLevel + 1) + (long)priorityLevel;
            }
        } else {
            this.initHeapWeights();
        }
        this.lastMinWeight = next - (1L << priorityLevel) * (long)priorityLevel + (long)priorityLevel;
        return next;
    }

    private EncapsulatedPacket getReassembledPacket(EncapsulatedPacket splitPacket) {
        EncapsulatedPacket result;
        this.checkForClosed();
        SplitPacketHelper helper = this.splitPackets.get(splitPacket.getPartId());
        if (helper == null) {
            helper = new SplitPacketHelper(splitPacket.getPartCount());
            this.splitPackets.set(splitPacket.getPartId(), helper);
        }
        if ((result = helper.add(splitPacket, this)) != null && this.splitPackets.remove(splitPacket.getPartId(), helper)) {
            helper.release();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDatagram(ByteBuf buffer) {
        try {
            boolean rakNetDatagram;
            if (this.isClosed()) {
                return;
            }
            this.touch();
            byte potentialFlags = buffer.readByte();
            boolean bl = rakNetDatagram = (potentialFlags & 0xFFFFFF80) != 0;
            if (!rakNetDatagram) {
                buffer.readerIndex(0);
                this.onPacketInternal(buffer);
                return;
            }
            if (this.state == null || this.state.ordinal() < RakNetState.INITIALIZED.ordinal()) {
                return;
            }
            if ((potentialFlags & 0x40) != 0) {
                this.onAcknowledge(buffer, this.incomingAcks, false);
            } else if ((potentialFlags & 0x20) != 0) {
                this.onAcknowledge(buffer, this.incomingNaks, true);
            } else {
                buffer.readerIndex(0);
                this.onRakNetDatagram(buffer);
            }
        }
        finally {
            buffer.release();
        }
    }

    private void onEncapsulatedInternal(EncapsulatedPacket packet) {
        ByteBuf buffer = packet.buffer;
        short packetId = buffer.readUnsignedByte();
        switch (packetId) {
            case 0: {
                this.onConnectedPing(buffer);
                break;
            }
            case 3: {
                this.onConnectedPong(buffer);
                break;
            }
            case 21: {
                this.onDisconnectionNotification();
                break;
            }
            default: {
                buffer.readerIndex(0);
                if (packetId >= 128) {
                    if (this.listener == null) break;
                    this.listener.onEncapsulated(packet);
                    break;
                }
                this.onPacket(buffer);
            }
        }
    }

    private void onPacketInternal(ByteBuf buffer) {
        short packetId = buffer.getUnsignedByte(buffer.readerIndex());
        buffer.readerIndex(0);
        if (packetId >= 128) {
            if (this.listener != null) {
                this.listener.onDirect(buffer);
            }
        } else {
            this.onPacket(buffer);
        }
    }

    protected abstract void onPacket(ByteBuf var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRakNetDatagram(ByteBuf buffer) {
        int missedDatagrams;
        if (this.state == null || RakNetState.INITIALIZED.compareTo(this.state) > 0) {
            return;
        }
        if (this.getRakNet().getMetrics() != null) {
            this.getRakNet().getMetrics().rakDatagramsIn(1);
        }
        RakNetDatagram datagram = new RakNetDatagram(System.currentTimeMillis());
        datagram.decode(buffer);
        this.slidingWindow.onPacketReceived(datagram.sendTime);
        int prevSequenceIndex = this.datagramReadIndex;
        if (prevSequenceIndex <= datagram.sequenceIndex) {
            this.datagramReadIndex = datagram.sequenceIndex + 1;
        }
        if ((missedDatagrams = datagram.sequenceIndex - prevSequenceIndex) > 0) {
            this.outgoingNaks.offer(new IntRange(datagram.sequenceIndex - missedDatagrams, datagram.sequenceIndex - 1));
        }
        this.outgoingAcks.offer(new IntRange(datagram.sequenceIndex, datagram.sequenceIndex));
        for (EncapsulatedPacket encapsulated : datagram.packets) {
            if (encapsulated.reliability.isReliable()) {
                int missed = encapsulated.reliabilityIndex - this.reliabilityReadIndex;
                if (missed > 0) {
                    if (missed < this.reliableDatagramQueue.size()) {
                        if (!this.reliableDatagramQueue.get(missed)) continue;
                        this.reliableDatagramQueue.set(missed, false);
                    } else {
                        int count = missed - this.reliableDatagramQueue.size();
                        for (int i = 0; i < count; ++i) {
                            this.reliableDatagramQueue.add(true);
                        }
                        this.reliableDatagramQueue.add(false);
                    }
                } else {
                    if (missed != 0) continue;
                    ++this.reliabilityReadIndex;
                    if (!this.reliableDatagramQueue.isEmpty()) {
                        this.reliableDatagramQueue.poll();
                    }
                }
                while (!this.reliableDatagramQueue.isEmpty() && !this.reliableDatagramQueue.peek()) {
                    this.reliableDatagramQueue.poll();
                    ++this.reliabilityReadIndex;
                }
            }
            if (encapsulated.split) {
                EncapsulatedPacket reassembled = this.getReassembledPacket(encapsulated);
                if (reassembled == null) continue;
                try {
                    this.checkForOrdered(reassembled);
                    continue;
                }
                finally {
                    reassembled.release();
                    continue;
                }
            }
            this.checkForOrdered(encapsulated);
        }
    }

    private void checkForOrdered(EncapsulatedPacket packet) {
        if (packet.getReliability().isOrdered()) {
            this.onOrderedReceived(packet);
        } else {
            this.onEncapsulatedInternal(packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onOrderedReceived(EncapsulatedPacket packet) {
        EncapsulatedPacket queuedPacket;
        FastBinaryMinHeap<EncapsulatedPacket> binaryHeap = this.orderingHeaps[packet.orderingChannel];
        if (this.orderReadIndex[packet.orderingChannel] < packet.orderingIndex) {
            binaryHeap.insert(packet.orderingIndex, packet.retain());
            return;
        }
        if (this.orderReadIndex[packet.orderingChannel] > packet.orderingIndex) {
            return;
        }
        short s2 = packet.orderingChannel;
        this.orderReadIndex[s2] = this.orderReadIndex[s2] + 1;
        this.onEncapsulatedInternal(packet);
        while ((queuedPacket = binaryHeap.peek()) != null && queuedPacket.orderingIndex == this.orderReadIndex[packet.orderingChannel]) {
            try {
                binaryHeap.remove();
                short s3 = packet.orderingChannel;
                this.orderReadIndex[s3] = this.orderReadIndex[s3] + 1;
                this.onEncapsulatedInternal(queuedPacket);
            }
            finally {
                queuedPacket.release();
            }
        }
    }

    final void onTick(long curTime) {
        if (this.isClosed()) {
            return;
        }
        this.tick(curTime);
    }

    protected void tick(long curTime) {
        ByteBuf buffer;
        if (this.isTimedOut(curTime)) {
            this.close(DisconnectReason.TIMED_OUT);
            return;
        }
        if (this.state == null || this.state.ordinal() < RakNetState.INITIALIZED.ordinal()) {
            return;
        }
        if (this.currentPingTime + 2000L < curTime) {
            this.sendConnectedPing(curTime);
        }
        this.handleIncomingAcknowledge(curTime, this.incomingAcks, false);
        this.handleIncomingAcknowledge(curTime, this.incomingNaks, true);
        RakMetrics metrics = this.getRakNet().getMetrics();
        int mtu = this.adjustedMtu - 4;
        int writtenAcks = 0;
        int writtenNacks = 0;
        while (!this.outgoingAcks.isEmpty()) {
            buffer = this.allocateBuffer(mtu);
            buffer.writeByte(-64);
            writtenAcks += RakNetUtils.writeIntRanges(buffer, this.outgoingAcks, mtu - 1);
            this.sendDirect(buffer);
            this.slidingWindow.onSendAck();
        }
        while (!this.outgoingNaks.isEmpty()) {
            buffer = this.allocateBuffer(mtu);
            buffer.writeByte(-96);
            writtenNacks += RakNetUtils.writeIntRanges(buffer, this.outgoingNaks, mtu - 1);
            this.sendDirect(buffer);
        }
        if (metrics != null) {
            metrics.nackOut(writtenNacks);
            metrics.ackOut(writtenAcks);
        }
        if (!this.sendStaleDatagrams(curTime)) {
            return;
        }
        this.sendDatagrams(curTime);
        this.channel.flush();
    }

    private void handleIncomingAcknowledge(long curTime, Queue<IntRange> queue, boolean nack) {
        IntRange range;
        if (queue.isEmpty()) {
            return;
        }
        if (nack) {
            this.slidingWindow.onNak();
        }
        while ((range = queue.poll()) != null) {
            for (int i = range.start; i <= range.end; ++i) {
                RakNetDatagram datagram = (RakNetDatagram)this.sentDatagrams.remove(i);
                if (datagram == null) continue;
                if (nack) {
                    this.onIncomingNack(datagram, curTime);
                    continue;
                }
                this.onIncomingAck(datagram, curTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onIncomingAck(RakNetDatagram datagram, long curTime) {
        try {
            this.unackedBytes -= datagram.getSize();
            this.slidingWindow.onAck(curTime - datagram.sendTime, datagram.sequenceIndex, this.datagramReadIndex);
        }
        finally {
            datagram.release();
        }
    }

    private void onIncomingNack(RakNetDatagram datagram, long curTime) {
        if (log.isTraceEnabled()) {
            log.trace("NAK'ed datagram {} from {}", (Object)datagram.sequenceIndex, (Object)this.address);
        }
        this.sendDatagram(datagram, curTime);
    }

    private boolean sendStaleDatagrams(long curTime) {
        RakMetrics metrics;
        if (this.sentDatagrams.isEmpty()) {
            return true;
        }
        boolean hasResent = false;
        int resendCount = 0;
        int transmissionBandwidth = this.slidingWindow.getRetransmissionBandwidth(this.unackedBytes);
        for (RakNetDatagram datagram : this.sentDatagrams.values()) {
            if (datagram.getNextSend() > curTime) continue;
            int size = datagram.getSize();
            if (transmissionBandwidth < size) break;
            transmissionBandwidth -= size;
            if (!hasResent) {
                hasResent = true;
            }
            ++resendCount;
            this.sendDatagram(datagram, curTime);
        }
        if (resendCount > 256) {
            this.close(DisconnectReason.TIMED_OUT);
            if (log.isDebugEnabled()) {
                log.debug("Too many Stale datagrams for {}. Disconnected", (Object)this.address);
            }
            return false;
        }
        if (hasResent) {
            this.slidingWindow.onResend(curTime);
        }
        if ((metrics = this.getRakNet().getMetrics()) != null) {
            metrics.rakStaleDatagrams(resendCount);
        }
        return true;
    }

    private void sendDatagrams(long curTime) {
        EncapsulatedPacket packet;
        int size;
        if (this.outgoingPackets.isEmpty()) {
            return;
        }
        RakNetDatagram datagram = new RakNetDatagram(curTime);
        for (int transmissionBandwidth = this.slidingWindow.getTransmissionBandwidth(this.unackedBytes); (packet = this.outgoingPackets.peek()) != null && transmissionBandwidth >= (size = packet.getSize()); transmissionBandwidth -= size) {
            this.outgoingPackets.remove();
            if (datagram.tryAddPacket(packet, this.adjustedMtu)) continue;
            this.sendDatagram(datagram, curTime);
            datagram = new RakNetDatagram(curTime);
            if (datagram.tryAddPacket(packet, this.adjustedMtu)) continue;
            throw new IllegalArgumentException("Packet too large to fit in MTU (size: " + packet.getSize() + ", MTU: " + this.adjustedMtu + ")");
        }
        if (!datagram.getPackets().isEmpty()) {
            this.sendDatagram(datagram, curTime);
        }
    }

    @Override
    public void disconnect() {
        this.disconnect(DisconnectReason.DISCONNECTED);
    }

    @Override
    public void disconnect(DisconnectReason reason) {
        if (!this.isClosed()) {
            this.eventLoop.execute(() -> this.disconnect0(reason));
        }
    }

    private void disconnect0(DisconnectReason reason) {
        if (!this.isClosed()) {
            this.sendDisconnectionNotification();
            this.close0(reason);
        }
    }

    @Override
    public void close() {
        this.close(DisconnectReason.DISCONNECTED);
    }

    @Override
    public void close(DisconnectReason reason) {
        if (!this.isClosed()) {
            this.eventLoop.execute(() -> this.close0(reason));
        }
    }

    private void close0(DisconnectReason reason) {
        if (this.isClosed()) {
            return;
        }
        this.closed = true;
        this.state = RakNetState.UNCONNECTED;
        this.onClose();
        if (log.isTraceEnabled()) {
            log.trace("RakNet Session ({} => {}) closed: {}", new Object[]{this.getRakNet().getBindAddress(), this.address, reason});
        }
        this.deinitialize();
        if (this.listener != null) {
            this.listener.onDisconnect(reason);
        }
    }

    protected void onClose() {
    }

    @Override
    public void sendImmediate(ByteBuf buf) {
        this.send(buf, RakNetPriority.IMMEDIATE);
    }

    @Override
    public void send(ByteBuf buf) {
        this.send(buf, RakNetPriority.MEDIUM);
    }

    public void send(ByteBuf buf, RakNetPriority priority) {
        this.send(buf, priority, RakNetReliability.RELIABLE_ORDERED);
    }

    public void send(ByteBuf buf, RakNetReliability reliability) {
        this.send(buf, RakNetPriority.MEDIUM, reliability);
    }

    public void send(ByteBuf buf, RakNetPriority priority, RakNetReliability reliability) {
        this.send(buf, priority, reliability, 0);
    }

    public void send(ByteBuf buf, RakNetPriority priority, RakNetReliability reliability, @Nonnegative int orderingChannel) {
        if (this.eventLoop.inEventLoop()) {
            this.send0(buf, priority, reliability, orderingChannel);
        } else {
            this.eventLoop.execute(() -> this.send0(buf, priority, reliability, orderingChannel));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send0(ByteBuf buf, RakNetPriority priority, RakNetReliability reliability, @Nonnegative int orderingChannel) {
        try {
            if (this.isClosed() || this.state == null || this.state.ordinal() < RakNetState.INITIALIZED.ordinal()) {
                return;
            }
            EncapsulatedPacket[] packets = this.createEncapsulated(buf, priority, reliability, orderingChannel);
            if (priority == RakNetPriority.IMMEDIATE) {
                this.sendImmediate(packets);
                return;
            }
            long weight = this.getNextWeight(priority);
            if (packets.length == 1) {
                this.outgoingPackets.insert(weight, packets[0]);
            } else {
                this.outgoingPackets.insertSeries(weight, (EncapsulatedPacket[])packets);
            }
        }
        finally {
            buf.release();
        }
    }

    @Override
    private void sendImmediate(EncapsulatedPacket[] packets) {
        long curTime = System.currentTimeMillis();
        EncapsulatedPacket[] encapsulatedPacketArray = packets;
        int n = encapsulatedPacketArray.length;
        for (int i = 0; i < n; ++i) {
            RakNetDatagram datagram = new RakNetDatagram(curTime);
            EncapsulatedPacket packet = encapsulatedPacketArray[i];
            if (!datagram.tryAddPacket(packet, this.adjustedMtu)) {
                throw new IllegalArgumentException("Packet too large to fit in MTU (size: " + packet.getSize() + ", MTU: " + this.adjustedMtu + ")");
            }
            this.sendDatagram(datagram, curTime);
        }
        this.channel.flush();
    }

    private EncapsulatedPacket[] createEncapsulated(ByteBuf buffer, RakNetPriority priority, RakNetReliability reliability, int orderingChannel) {
        ByteBuf[] buffers;
        int maxLength = this.adjustedMtu - 28 - 4;
        int splitId = 0;
        if (buffer.readableBytes() > maxLength) {
            switch (reliability) {
                case UNRELIABLE: {
                    reliability = RakNetReliability.RELIABLE;
                    break;
                }
                case UNRELIABLE_SEQUENCED: {
                    reliability = RakNetReliability.RELIABLE_SEQUENCED;
                    break;
                }
                case UNRELIABLE_WITH_ACK_RECEIPT: {
                    reliability = RakNetReliability.RELIABLE_WITH_ACK_RECEIPT;
                }
            }
            int split = (buffer.readableBytes() - 1) / maxLength + 1;
            buffer.retain(split);
            buffers = new ByteBuf[split];
            for (int i = 0; i < split; ++i) {
                buffers[i] = buffer.readSlice(Math.min(maxLength, buffer.readableBytes()));
            }
            if (buffer.isReadable()) {
                throw new IllegalStateException("Buffer still has bytes to read!");
            }
            splitId = this.splitIndex++;
        } else {
            buffers = new ByteBuf[]{buffer.readRetainedSlice(buffer.readableBytes())};
        }
        int orderingIndex = 0;
        if (reliability.isOrdered()) {
            int n = orderingChannel;
            int n2 = this.orderWriteIndex[n];
            this.orderWriteIndex[n] = n2 + 1;
            orderingIndex = n2;
        }
        EncapsulatedPacket[] packets = new EncapsulatedPacket[buffers.length];
        int parts = buffers.length;
        for (int i = 0; i < parts; ++i) {
            EncapsulatedPacket packet = new EncapsulatedPacket();
            packet.needsBAS = true;
            packet.buffer = buffers[i];
            packet.orderingChannel = (short)orderingChannel;
            packet.orderingIndex = orderingIndex;
            packet.reliability = reliability;
            packet.priority = priority;
            if (reliability.isReliable()) {
                ++this.reliabilityWriteIndex;
                packet.reliabilityIndex = packet.reliabilityIndex;
            }
            if (parts > 1) {
                packet.split = true;
                packet.partIndex = i;
                packet.partCount = parts;
                packet.partId = splitId;
            }
            packets[i] = packet;
        }
        return packets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendDatagram(RakNetDatagram datagram, long time) {
        Preconditions.checkArgument(!datagram.packets.isEmpty(), "RakNetDatagram with no packets");
        if (this.getRakNet().getMetrics() != null) {
            this.getRakNet().getMetrics().rakDatagramsOut(1);
        }
        try {
            ByteBuf buf;
            int oldIndex = datagram.sequenceIndex;
            datagram.sequenceIndex = this.datagramWriteIndex++;
            for (EncapsulatedPacket packet : datagram.packets) {
                if (!packet.reliability.isReliable()) continue;
                datagram.nextSend = time + this.slidingWindow.getRtoForRetransmission();
                if (oldIndex == -1) {
                    this.unackedBytes += datagram.getSize();
                } else {
                    this.sentDatagrams.remove(oldIndex, datagram);
                }
                this.sentDatagrams.put(datagram.sequenceIndex, datagram.retain());
                break;
            }
            Preconditions.checkArgument((buf = this.allocateBuffer(datagram.getSize())).writerIndex() < this.adjustedMtu, "Packet length was %s but expected %s", buf.writerIndex(), this.adjustedMtu);
            datagram.encode(buf);
            this.channel.write(new DatagramPacket(buf, this.address));
        }
        finally {
            datagram.release();
        }
    }

    void sendDirect(ByteBuf buffer) {
        this.channel.writeAndFlush(new DatagramPacket(buffer, this.address));
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(int timeout) {
        this.sessionTimeout = timeout;
    }

    private void onAcknowledge(ByteBuf buffer, Queue<IntRange> queue, boolean nack) {
        this.checkForClosed();
        int size = buffer.readUnsignedShort();
        for (int i = 0; i < size; ++i) {
            int end;
            boolean singleton = buffer.readBoolean();
            int start = buffer.readUnsignedMediumLE();
            int n = end = singleton ? start : buffer.readUnsignedMediumLE();
            if (start > end) {
                if (log.isTraceEnabled()) {
                    log.trace("{} sent an IntRange with a start value {} greater than an end value of {}", this.address, start, end);
                }
                this.disconnect(DisconnectReason.BAD_PACKET);
                return;
            }
            queue.offer(new IntRange(start, end));
        }
        RakMetrics metrics = this.getRakNet().getMetrics();
        if (metrics != null) {
            if (nack) {
                metrics.nackIn(size);
            } else {
                metrics.ackIn(size);
            }
        }
    }

    private void onConnectedPing(ByteBuf buffer) {
        long pingTime = buffer.readLong();
        this.sendConnectedPong(pingTime);
    }

    private void onConnectedPong(ByteBuf buffer) {
        long pingTime = buffer.readLong();
        if (this.currentPingTime == pingTime) {
            this.lastPingTime = this.currentPingTime;
            this.lastPongTime = System.currentTimeMillis();
        }
    }

    private void onDisconnectionNotification() {
        this.close(DisconnectReason.CLOSED_BY_REMOTE_PEER);
    }

    private void sendConnectedPing(long pingTime) {
        ByteBuf buffer = this.allocateBuffer(9);
        buffer.writeByte(0);
        buffer.writeLong(pingTime);
        this.send(buffer, RakNetPriority.IMMEDIATE, RakNetReliability.UNRELIABLE);
        this.currentPingTime = pingTime;
    }

    private void sendConnectedPong(long pingTime) {
        ByteBuf buffer = this.allocateBuffer(17);
        buffer.writeByte(3);
        buffer.writeLong(pingTime);
        buffer.writeLong(System.currentTimeMillis());
        this.send(buffer, RakNetPriority.IMMEDIATE, RakNetReliability.UNRELIABLE);
    }

    private void sendDisconnectionNotification() {
        ByteBuf buffer = this.allocateBuffer(1);
        buffer.writeByte(21);
        this.send(buffer, RakNetPriority.IMMEDIATE, RakNetReliability.RELIABLE_ORDERED);
    }

    private void sendDetectLostConnection() {
        ByteBuf buffer = this.allocateBuffer(1);
        buffer.writeByte(4);
        this.send(buffer, RakNetPriority.IMMEDIATE);
    }

    private void touch() {
        this.checkForClosed();
        this.lastTouched = System.currentTimeMillis();
    }

    public boolean isStale(long curTime) {
        return curTime - this.lastTouched >= 5000L;
    }

    public boolean isStale() {
        return this.isStale(System.currentTimeMillis());
    }

    public boolean isTimedOut(long curTime) {
        return curTime - this.lastTouched >= (long)this.sessionTimeout;
    }

    public boolean isTimedOut() {
        return this.isTimedOut(System.currentTimeMillis());
    }

    private void checkForClosed() {
        Preconditions.checkState(!this.isClosed(), "Session already closed");
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public abstract RakNet getRakNet();

    boolean isIpv6Session() {
        return this.address.getAddress() instanceof Inet6Address;
    }

    public RakNetState getState() {
        return this.state;
    }

    void setState(@Nullable RakNetState state) {
        if (this.state != state) {
            this.state = state;
            if (this.listener != null) {
                this.listener.onSessionChangeState(this.state);
            }
        }
    }

    public Channel getChannel() {
        return this.channel;
    }

    public EventLoop getEventLoop() {
        return this.eventLoop;
    }

    public RakNetSessionListener getListener() {
        return this.listener;
    }

    public void setListener(RakNetSessionListener listener) {
        this.listener = listener;
    }
}

