/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.nbt;

import com.nukkitx.nbt.NbtList;
import com.nukkitx.nbt.NbtMap;
import java.util.HashMap;
import java.util.Map;

public final class NbtType<T> {
    public static final NbtType<Void> END = new NbtType<Void>(Void.class, Enum.END);
    public static final NbtType<Byte> BYTE = new NbtType<Byte>(Byte.class, Enum.BYTE);
    public static final NbtType<Short> SHORT = new NbtType<Short>(Short.class, Enum.SHORT);
    public static final NbtType<Integer> INT = new NbtType<Integer>(Integer.class, Enum.INT);
    public static final NbtType<Long> LONG = new NbtType<Long>(Long.class, Enum.LONG);
    public static final NbtType<Float> FLOAT = new NbtType<Float>(Float.class, Enum.FLOAT);
    public static final NbtType<Double> DOUBLE = new NbtType<Double>(Double.class, Enum.DOUBLE);
    public static final NbtType<byte[]> BYTE_ARRAY = new NbtType<byte[]>(byte[].class, Enum.BYTE_ARRAY);
    public static final NbtType<String> STRING = new NbtType<String>(String.class, Enum.STRING);
    public static final NbtType<NbtList> LIST = new NbtType<NbtList>(NbtList.class, Enum.LIST);
    public static final NbtType<NbtMap> COMPOUND = new NbtType<NbtMap>(NbtMap.class, Enum.COMPOUND);
    public static final NbtType<int[]> INT_ARRAY = new NbtType<int[]>(int[].class, Enum.INT_ARRAY);
    public static final NbtType<long[]> LONG_ARRAY = new NbtType<long[]>(long[].class, Enum.LONG_ARRAY);
    private static final NbtType<?>[] BY_ID = new NbtType[]{END, BYTE, SHORT, INT, LONG, FLOAT, DOUBLE, BYTE_ARRAY, STRING, LIST, COMPOUND, INT_ARRAY, LONG_ARRAY};
    private static final Map<Class<?>, NbtType<?>> BY_CLASS = new HashMap();
    private final Class<T> tagClass;
    private final Enum enumeration;

    private NbtType(Class<T> tagClass, Enum enumeration) {
        this.tagClass = tagClass;
        this.enumeration = enumeration;
    }

    public static NbtType<?> byId(int id) {
        if (id >= 0 && id < BY_ID.length) {
            return BY_ID[id];
        }
        throw new IndexOutOfBoundsException("Tag type id must be greater than 0 and less than " + (BY_ID.length - 1));
    }

    public static <T> NbtType<T> byClass(Class<T> tagClass) {
        NbtType<?> type = BY_CLASS.get(tagClass);
        if (type == null) {
            throw new IllegalArgumentException("Tag of class " + tagClass + " does not exist");
        }
        return type;
    }

    public Class<T> getTagClass() {
        return this.tagClass;
    }

    public int getId() {
        return this.enumeration.ordinal();
    }

    public String getTypeName() {
        return this.enumeration.getName();
    }

    public Enum getEnum() {
        return this.enumeration;
    }

    static {
        for (NbtType<?> type : BY_ID) {
            BY_CLASS.put(type.getTagClass(), type);
        }
    }

    public static enum Enum {
        END,
        BYTE,
        SHORT,
        INT,
        LONG,
        FLOAT,
        DOUBLE,
        BYTE_ARRAY,
        STRING,
        LIST,
        COMPOUND,
        INT_ARRAY,
        LONG_ARRAY;

        private final String name = "TAG_" + this.name();

        public String getName() {
            return this.name;
        }
    }
}

