/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.nbt;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;

public final class FloatInternPool {
    private static final Map<Object, WeakFloat> CACHE = new ConcurrentSkipListMap<Object, WeakFloat>((a, b) -> {
        if (a instanceof Float) {
            return Float.compare(((Float)a).floatValue(), ((WeakFloat)b).value);
        }
        return Float.compare(((WeakFloat)a).value, ((WeakFloat)b).value);
    });
    private static final ReferenceQueue<?>[] REFERENCE_QUEUES = (ReferenceQueue[])IntStream.range(0, Runtime.getRuntime().availableProcessors()).mapToObj(i -> new ReferenceQueue()).toArray(ReferenceQueue[]::new);

    private static void expungeStaleEntries(@Nonnull ReferenceQueue<?> referenceQueue) {
        WeakFloat entry;
        while ((entry = (WeakFloat)referenceQueue.poll()) != null) {
            CACHE.remove(entry, entry);
        }
    }

    public static Float intern(float value) {
        Float interned;
        Float boxed = Float.valueOf(value);
        WeakFloat entry = CACHE.get(boxed);
        if (entry != null) {
            FloatInternPool.expungeStaleEntries(entry.referenceQueue);
            interned = (Float)entry.get();
            if (interned != null) {
                return interned;
            }
        }
        WeakFloat newEntry = new WeakFloat(boxed, REFERENCE_QUEUES[ThreadLocalRandom.current().nextInt(REFERENCE_QUEUES.length)]);
        do {
            if ((entry = CACHE.putIfAbsent(newEntry, newEntry)) != null) {
                FloatInternPool.expungeStaleEntries(entry.referenceQueue);
                interned = (Float)entry.get();
                continue;
            }
            interned = boxed;
        } while (interned == null);
        return interned;
    }

    private static final class WeakFloat
    extends WeakReference<Float> {
        private final float value;
        private final ReferenceQueue<?> referenceQueue;

        public WeakFloat(@Nonnull Float value, @Nonnull ReferenceQueue referenceQueue) {
            super(value, referenceQueue);
            this.value = value.floatValue();
            this.referenceQueue = referenceQueue;
        }
    }
}

