/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.natives.util;

import com.nukkitx.natives.NativeCode;
import com.nukkitx.natives.util.PlatformUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BooleanSupplier;

public class LibraryLoader
implements BooleanSupplier {
    private static final Set<Path> toDelete = new HashSet<Path>();
    private final String name;

    public LibraryLoader(String name) {
        this.name = name;
    }

    private static String getExtension(String name) {
        int p;
        String extension = "";
        int i = name.lastIndexOf(46);
        if (i > (p = Math.max(name.lastIndexOf(47), name.lastIndexOf(92)))) {
            extension = name.substring(i + 1);
        }
        return extension;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean getAsBoolean() {
        String fullName = this.name + '-' + PlatformUtils.OPERATING_SYSTEM + '-' + PlatformUtils.ARCHITECTURE;
        String tmpName = "native-" + fullName;
        String libraryName = System.mapLibraryName(fullName);
        String libraryExtension = LibraryLoader.getExtension(libraryName);
        try {
            System.loadLibrary(tmpName);
            return true;
        }
        catch (Throwable throwable) {
            try (InputStream resourceStream = NativeCode.class.getClassLoader().getResourceAsStream(libraryName);){
                if (resourceStream == null) {
                    boolean bl2 = false;
                    return bl2;
                }
                Path tempPath = Files.createTempFile(tmpName, libraryExtension, new FileAttribute[0]);
                Files.copy(resourceStream, tempPath, new CopyOption[0]);
                toDelete.add(tempPath);
                System.loadLibrary(this.name);
                boolean bl = true;
                return bl;
            }
            catch (Throwable e) {
                System.out.println("Could not load native library: " + e.getMessage());
                return false;
            }
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            for (Path path : toDelete) {
                try {
                    Files.deleteIfExists(path);
                }
                catch (IOException iOException) {}
            }
        }));
    }
}

