/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.math.imaginary;

import com.nukkitx.math.GenericMath;
import com.nukkitx.math.TrigMath;
import com.nukkitx.math.imaginary.Complexd;
import com.nukkitx.math.imaginary.Imaginaryd;
import com.nukkitx.math.imaginary.Quaternionf;
import com.nukkitx.math.matrix.Matrix3d;
import com.nukkitx.math.vector.Vector3d;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class Quaterniond
implements Imaginaryd,
Comparable<Quaterniond>,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final Quaterniond ZERO = new Quaterniond(0.0, 0.0, 0.0, 0.0);
    public static final Quaterniond IDENTITY = new Quaterniond(0.0, 0.0, 0.0, 1.0);
    private final double x;
    private final double y;
    private final double z;
    private final double w;
    private volatile transient boolean hashed = false;
    private volatile transient int hashCode = 0;

    private Quaterniond(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getW() {
        return this.w;
    }

    @Nonnull
    public Quaterniond add(Quaterniond q) {
        return this.add(q.x, q.y, q.z, q.w);
    }

    @Nonnull
    public Quaterniond add(float x, float y, float z, float w) {
        return this.add((double)x, (double)y, (double)z, (double)w);
    }

    @Nonnull
    public Quaterniond add(double x, double y, double z, double w) {
        return Quaterniond.from(this.x + x, this.y + y, this.z + z, this.w + w);
    }

    @Nonnull
    public Quaterniond sub(Quaterniond q) {
        return this.sub(q.x, q.y, q.z, q.w);
    }

    @Nonnull
    public Quaterniond sub(float x, float y, float z, float w) {
        return this.sub((double)x, (double)y, (double)z, (double)w);
    }

    @Nonnull
    public Quaterniond sub(double x, double y, double z, double w) {
        return Quaterniond.from(this.x - x, this.y - y, this.z - z, this.w - w);
    }

    @Nonnull
    public Quaterniond mul(float a) {
        return this.mul((double)a);
    }

    @Override
    @Nonnull
    public Quaterniond mul(double a) {
        return Quaterniond.from(this.x * a, this.y * a, this.z * a, this.w * a);
    }

    @Nonnull
    public Quaterniond mul(Quaterniond q) {
        return this.mul(q.x, q.y, q.z, q.w);
    }

    @Nonnull
    public Quaterniond mul(float x, float y, float z, float w) {
        return this.mul((double)x, (double)y, (double)z, (double)w);
    }

    @Nonnull
    public Quaterniond mul(double x, double y, double z, double w) {
        return Quaterniond.from(this.w * x + this.x * w + this.y * z - this.z * y, this.w * y + this.y * w + this.z * x - this.x * z, this.w * z + this.z * w + this.x * y - this.y * x, this.w * w - this.x * x - this.y * y - this.z * z);
    }

    @Nonnull
    public Quaterniond div(float a) {
        return this.div((double)a);
    }

    @Override
    @Nonnull
    public Quaterniond div(double a) {
        return Quaterniond.from(this.x / a, this.y / a, this.z / a, this.w / a);
    }

    @Nonnull
    public Quaterniond div(Quaterniond q) {
        return this.div(q.x, q.y, q.z, q.w);
    }

    @Nonnull
    public Quaterniond div(float x, float y, float z, float w) {
        return this.div((double)x, (double)y, (double)z, (double)w);
    }

    @Nonnull
    public Quaterniond div(double x, double y, double z, double w) {
        double d = x * x + y * y + z * z + w * w;
        return Quaterniond.from((this.x * w - this.w * x - this.z * y + this.y * z) / d, (this.y * w + this.z * x - this.w * y - this.x * z) / d, (this.z * w - this.y * x + this.x * y - this.w * z) / d, (this.w * w + this.x * x + this.y * y + this.z * z) / d);
    }

    public double dot(Quaterniond q) {
        return this.dot(q.x, q.y, q.z, q.w);
    }

    public double dot(float x, float y, float z, float w) {
        return this.dot((double)x, (double)y, (double)z, (double)w);
    }

    public double dot(double x, double y, double z, double w) {
        return this.x * x + this.y * y + this.z * z + this.w * w;
    }

    @Nonnull
    public Vector3d rotate(Vector3d v) {
        return this.rotate(v.getX(), v.getY(), v.getZ());
    }

    @Nonnull
    public Vector3d rotate(float x, float y, float z) {
        return this.rotate((double)x, (double)y, (double)z);
    }

    @Nonnull
    public Vector3d rotate(double x, double y, double z) {
        double length = this.length();
        if (Math.abs(length) < GenericMath.DBL_EPSILON) {
            throw new ArithmeticException("Cannot rotate by the zero quaternion");
        }
        double nx = this.x / length;
        double ny = this.y / length;
        double nz = this.z / length;
        double nw = this.w / length;
        double px = nw * x + ny * z - nz * y;
        double py = nw * y + nz * x - nx * z;
        double pz = nw * z + nx * y - ny * x;
        double pw = -nx * x - ny * y - nz * z;
        return Vector3d.from(pw * -nx + px * nw - py * nz + pz * ny, pw * -ny + py * nw - pz * nx + px * nz, pw * -nz + pz * nw - px * ny + py * nx);
    }

    @Nonnull
    public Vector3d getDirection() {
        return this.rotate(Vector3d.FORWARD);
    }

    @Nonnull
    public Vector3d getAxis() {
        double q = Math.sqrt(1.0 - this.w * this.w);
        return Vector3d.from(this.x / q, this.y / q, this.z / q);
    }

    @Nonnull
    public Vector3d getAxesAnglesDeg() {
        return this.getAxesAnglesRad().mul(57.29577951308232);
    }

    @Nonnull
    public Vector3d getAxesAnglesRad() {
        double yaw;
        double pitch;
        double roll;
        double test = this.w * this.x - this.y * this.z;
        if (Math.abs(test) < 0.4999) {
            roll = TrigMath.atan2(2.0 * (this.w * this.z + this.x * this.y), 1.0 - 2.0 * (this.x * this.x + this.z * this.z));
            pitch = TrigMath.asin(2.0 * test);
            yaw = TrigMath.atan2(2.0 * (this.w * this.y + this.z * this.x), 1.0 - 2.0 * (this.x * this.x + this.y * this.y));
        } else {
            int sign = test < 0.0 ? -1 : 1;
            roll = 0.0;
            pitch = (double)sign * Math.PI / 2.0;
            yaw = (double)(-sign * 2) * TrigMath.atan2(this.z, this.w);
        }
        return Vector3d.from(pitch, yaw, roll);
    }

    @Override
    @Nonnull
    public Quaterniond conjugate() {
        return Quaterniond.from(-this.x, -this.y, -this.z, this.w);
    }

    @Override
    @Nonnull
    public Quaterniond invert() {
        double lengthSquared = this.lengthSquared();
        if (Math.abs(lengthSquared) < GenericMath.DBL_EPSILON) {
            throw new ArithmeticException("Cannot invert a quaternion of length zero");
        }
        return this.conjugate().div(lengthSquared);
    }

    @Override
    public double lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    @Override
    public double length() {
        return Math.sqrt(this.lengthSquared());
    }

    @Override
    @Nonnull
    public Quaterniond normalize() {
        double length = this.length();
        if (Math.abs(length) < GenericMath.DBL_EPSILON) {
            throw new ArithmeticException("Cannot normalize the zero quaternion");
        }
        return Quaterniond.from(this.x / length, this.y / length, this.z / length, this.w / length);
    }

    @Nonnull
    public Complexd toComplex() {
        double w2 = this.w * this.w;
        return Complexd.from(2.0 * w2 - 1.0, 2.0 * this.w * Math.sqrt(1.0 - w2));
    }

    @Override
    @Nonnull
    public Quaternionf toFloat() {
        return Quaternionf.from(this.x, this.y, this.z, this.w);
    }

    @Override
    @Nonnull
    public Quaterniond toDouble() {
        return Quaterniond.from(this.x, this.y, this.z, this.w);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Quaterniond)) {
            return false;
        }
        Quaterniond quaternion = (Quaterniond)o;
        if (Double.compare(quaternion.w, this.w) != 0) {
            return false;
        }
        if (Double.compare(quaternion.x, this.x) != 0) {
            return false;
        }
        if (Double.compare(quaternion.y, this.y) != 0) {
            return false;
        }
        return Double.compare(quaternion.z, this.z) == 0;
    }

    public int hashCode() {
        if (!this.hashed) {
            int result = this.x != 0.0 ? Double.hashCode(this.x) : 0;
            result = 31 * result + (this.y != 0.0 ? Double.hashCode(this.y) : 0);
            result = 31 * result + (this.z != 0.0 ? Double.hashCode(this.z) : 0);
            this.hashCode = 31 * result + (this.w != 0.0 ? Double.hashCode(this.w) : 0);
            this.hashed = true;
        }
        return this.hashCode;
    }

    @Override
    public int compareTo(Quaterniond q) {
        return (int)Math.signum(this.lengthSquared() - q.lengthSquared());
    }

    @Nonnull
    public Quaterniond clone() {
        return Quaterniond.from(this);
    }

    @Nonnull
    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ", " + this.w + ")";
    }

    @Nonnull
    public static Quaterniond fromReal(double w) {
        return w == 0.0 ? ZERO : Quaterniond.from(0.0, 0.0, 0.0, w);
    }

    @Nonnull
    public static Quaterniond fromImaginary(double x, double y, double z) {
        return x == 0.0 && y == 0.0 && z == 0.0 ? ZERO : new Quaterniond(x, y, z, 0.0);
    }

    public static Quaterniond from(Quaterniond q) {
        return Quaterniond.from(q.x, q.y, q.z, q.w);
    }

    @Nonnull
    public static Quaterniond from(float x, float y, float z, float w) {
        return Quaterniond.from((double)x, (double)y, (double)z, (double)w);
    }

    @Nonnull
    public static Quaterniond from(double x, double y, double z, double w) {
        return x == 0.0 && y == 0.0 && z == 0.0 && w == 0.0 ? ZERO : new Quaterniond(x, y, z, w);
    }

    @Nonnull
    public static Quaterniond fromAxesAnglesDeg(float pitch, float yaw, float roll) {
        return Quaterniond.fromAxesAnglesDeg((double)pitch, (double)yaw, (double)roll);
    }

    @Nonnull
    public static Quaterniond fromAxesAnglesRad(float pitch, float yaw, float roll) {
        return Quaterniond.fromAxesAnglesRad((double)pitch, (double)yaw, (double)roll);
    }

    @Nonnull
    public static Quaterniond fromAxesAnglesDeg(double pitch, double yaw, double roll) {
        return Quaterniond.fromAngleDegAxis(yaw, Vector3d.UNIT_Y).mul(Quaterniond.fromAngleDegAxis(pitch, Vector3d.UNIT_X)).mul(Quaterniond.fromAngleDegAxis(roll, Vector3d.UNIT_Z));
    }

    @Nonnull
    public static Quaterniond fromAxesAnglesRad(double pitch, double yaw, double roll) {
        return Quaterniond.fromAngleRadAxis(yaw, Vector3d.UNIT_Y).mul(Quaterniond.fromAngleRadAxis(pitch, Vector3d.UNIT_X)).mul(Quaterniond.fromAngleRadAxis(roll, Vector3d.UNIT_Z));
    }

    @Nonnull
    public static Quaterniond fromRotationTo(Vector3d from, Vector3d to) {
        return Quaterniond.fromAngleRadAxis(TrigMath.acos(from.dot(to) / (from.length() * to.length())), from.cross(to));
    }

    @Nonnull
    public static Quaterniond fromAngleDegAxis(float angle, Vector3d axis) {
        return Quaterniond.fromAngleRadAxis(Math.toRadians(angle), axis);
    }

    @Nonnull
    public static Quaterniond fromAngleRadAxis(float angle, Vector3d axis) {
        return Quaterniond.fromAngleRadAxis((double)angle, axis);
    }

    @Nonnull
    public static Quaterniond fromAngleDegAxis(double angle, Vector3d axis) {
        return Quaterniond.fromAngleRadAxis(Math.toRadians(angle), axis);
    }

    @Nonnull
    public static Quaterniond fromAngleRadAxis(double angle, Vector3d axis) {
        return Quaterniond.fromAngleRadAxis(angle, axis.getX(), axis.getY(), axis.getZ());
    }

    @Nonnull
    public static Quaterniond fromAngleDegAxis(float angle, float x, float y, float z) {
        return Quaterniond.fromAngleRadAxis(Math.toRadians(angle), (double)x, (double)y, (double)z);
    }

    @Nonnull
    public static Quaterniond fromAngleRadAxis(float angle, float x, float y, float z) {
        return Quaterniond.fromAngleRadAxis((double)angle, (double)x, (double)y, (double)z);
    }

    @Nonnull
    public static Quaterniond fromAngleDegAxis(double angle, double x, double y, double z) {
        return Quaterniond.fromAngleRadAxis(Math.toRadians(angle), x, y, z);
    }

    @Nonnull
    public static Quaterniond fromAngleRadAxis(double angle, double x, double y, double z) {
        double halfAngle = angle / 2.0;
        double q = (double)TrigMath.sin(halfAngle) / Math.sqrt(x * x + y * y + z * z);
        return Quaterniond.from(x * q, y * q, z * q, (double)TrigMath.cos(halfAngle));
    }

    @Nonnull
    public static Quaterniond fromRotationMatrix(Matrix3d matrix) {
        double trace = matrix.trace();
        if (trace < 0.0) {
            if (matrix.get(1, 1) > matrix.get(0, 0)) {
                if (matrix.get(2, 2) > matrix.get(1, 1)) {
                    double r = Math.sqrt(matrix.get(2, 2) - matrix.get(0, 0) - matrix.get(1, 1) + 1.0);
                    double s2 = 0.5 / r;
                    return Quaterniond.from((matrix.get(2, 0) + matrix.get(0, 2)) * s2, (matrix.get(1, 2) + matrix.get(2, 1)) * s2, 0.5 * r, (matrix.get(1, 0) - matrix.get(0, 1)) * s2);
                }
                double r = Math.sqrt(matrix.get(1, 1) - matrix.get(2, 2) - matrix.get(0, 0) + 1.0);
                double s3 = 0.5 / r;
                return Quaterniond.from((matrix.get(0, 1) + matrix.get(1, 0)) * s3, 0.5 * r, (matrix.get(1, 2) + matrix.get(2, 1)) * s3, (matrix.get(0, 2) - matrix.get(2, 0)) * s3);
            }
            if (matrix.get(2, 2) > matrix.get(0, 0)) {
                double r = Math.sqrt(matrix.get(2, 2) - matrix.get(0, 0) - matrix.get(1, 1) + 1.0);
                double s4 = 0.5 / r;
                return Quaterniond.from((matrix.get(2, 0) + matrix.get(0, 2)) * s4, (matrix.get(1, 2) + matrix.get(2, 1)) * s4, 0.5 * r, (matrix.get(1, 0) - matrix.get(0, 1)) * s4);
            }
            double r = Math.sqrt(matrix.get(0, 0) - matrix.get(1, 1) - matrix.get(2, 2) + 1.0);
            double s5 = 0.5 / r;
            return Quaterniond.from(0.5 * r, (matrix.get(0, 1) + matrix.get(1, 0)) * s5, (matrix.get(2, 0) - matrix.get(0, 2)) * s5, (matrix.get(2, 1) - matrix.get(1, 2)) * s5);
        }
        double r = Math.sqrt(trace + 1.0);
        double s6 = 0.5 / r;
        return Quaterniond.from((matrix.get(2, 1) - matrix.get(1, 2)) * s6, (matrix.get(0, 2) - matrix.get(2, 0)) * s6, (matrix.get(1, 0) - matrix.get(0, 1)) * s6, 0.5 * r);
    }
}

