/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.opennbt.tag.builtin.custom;

import com.github.steveice10.opennbt.SNBTIO;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class DoubleArrayTag
extends Tag {
    private double[] value;

    public DoubleArrayTag(String name) {
        this(name, new double[0]);
    }

    public DoubleArrayTag(String name, double[] value) {
        super(name);
        this.value = value;
    }

    public double[] getValue() {
        return (double[])this.value.clone();
    }

    public void setValue(double[] value) {
        if (value == null) {
            return;
        }
        this.value = (double[])value.clone();
    }

    public double getValue(int index) {
        return this.value[index];
    }

    public void setValue(int index, double value) {
        this.value[index] = value;
    }

    public int length() {
        return this.value.length;
    }

    @Override
    public void read(DataInput in) throws IOException {
        this.value = new double[in.readInt()];
        for (int index = 0; index < this.value.length; ++index) {
            this.value[index] = in.readDouble();
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.value.length);
        for (int index = 0; index < this.value.length; ++index) {
            out.writeDouble(this.value[index]);
        }
    }

    @Override
    public void destringify(SNBTIO.StringifiedNBTReader in) throws IOException {
        String s2 = in.readUntil(true, ']');
        String[] valueStrings = s2.substring(s2.indexOf(59) + 1, s2.length() - 1).replaceAll(" ", "").split(",");
        this.value = new double[valueStrings.length];
        for (int i = 0; i < this.value.length; ++i) {
            this.value[i] = Double.parseDouble(valueStrings[i]);
        }
    }

    @Override
    public void stringify(SNBTIO.StringifiedNBTWriter out, boolean linebreak, int depth) throws IOException {
        StringBuilder sb = new StringBuilder("[D; ");
        for (double b : this.value) {
            sb.append(b);
            sb.append(',');
            sb.append(' ');
        }
        sb.setLength(sb.length() - 2);
        sb.append(']');
        out.append(sb.toString());
    }

    @Override
    public DoubleArrayTag clone() {
        return new DoubleArrayTag(this.getName(), this.getValue());
    }
}

