/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.opennbt.tag.builtin;

import com.github.steveice10.opennbt.SNBTIO;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class LongArrayTag
extends Tag {
    private long[] value;

    public LongArrayTag(String name) {
        this(name, new long[0]);
    }

    public LongArrayTag(String name, long[] value) {
        super(name);
        this.value = value;
    }

    public long[] getValue() {
        return (long[])this.value.clone();
    }

    public void setValue(long[] value) {
        if (value == null) {
            return;
        }
        this.value = (long[])value.clone();
    }

    public long getValue(int index) {
        return this.value[index];
    }

    public void setValue(int index, long value) {
        this.value[index] = value;
    }

    public int length() {
        return this.value.length;
    }

    @Override
    public void read(DataInput in) throws IOException {
        this.value = new long[in.readInt()];
        for (int index = 0; index < this.value.length; ++index) {
            this.value[index] = in.readLong();
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.value.length);
        for (int index = 0; index < this.value.length; ++index) {
            out.writeLong(this.value[index]);
        }
    }

    @Override
    public void destringify(SNBTIO.StringifiedNBTReader in) throws IOException {
        String s2 = in.readUntil(true, ']');
        String[] valueStrings = s2.substring(s2.indexOf(59) + 1, s2.length() - 1).replaceAll(" ", "").split(",");
        this.value = new long[valueStrings.length];
        for (int i = 0; i < this.value.length; ++i) {
            this.value[i] = Long.parseLong(valueStrings[i]);
        }
    }

    @Override
    public void stringify(SNBTIO.StringifiedNBTWriter out, boolean linebreak, int depth) throws IOException {
        StringBuilder sb = new StringBuilder("[L; ");
        for (long b : this.value) {
            sb.append(b);
            sb.append(',');
            sb.append(' ');
        }
        sb.setLength(sb.length() - 2);
        sb.append(']');
        out.append(sb.toString());
    }

    @Override
    public LongArrayTag clone() {
        return new LongArrayTag(this.getName(), this.getValue());
    }
}

