/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.login.serverbound;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class ServerboundKeyPacket
implements MinecraftPacket {
    @NonNull
    private final byte[] sharedKey;
    @Nullable
    private final byte[] verifyToken;
    @Nullable
    private final Long salt;
    @Nullable
    private final byte[] signature;

    public ServerboundKeyPacket(PublicKey publicKey, SecretKey secretKey, byte[] verifyToken) {
        this.sharedKey = ServerboundKeyPacket.runEncryption(1, publicKey, secretKey.getEncoded());
        this.verifyToken = ServerboundKeyPacket.runEncryption(1, publicKey, verifyToken);
        this.salt = null;
        this.signature = null;
    }

    public ServerboundKeyPacket(PublicKey publicKey, SecretKey secretKey, long salt, byte[] signature) {
        this.sharedKey = ServerboundKeyPacket.runEncryption(1, publicKey, secretKey.getEncoded());
        this.salt = salt;
        this.signature = signature;
        this.verifyToken = null;
    }

    public SecretKey getSecretKey(PrivateKey privateKey) {
        return new SecretKeySpec(ServerboundKeyPacket.runEncryption(2, privateKey, this.sharedKey), "AES");
    }

    public byte[] getVerifyToken(PrivateKey privateKey) {
        return ServerboundKeyPacket.runEncryption(2, privateKey, this.verifyToken);
    }

    public ServerboundKeyPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.sharedKey = helper.readByteArray(in);
        if (in.readBoolean()) {
            this.verifyToken = helper.readByteArray(in);
            this.salt = null;
            this.signature = null;
        } else {
            this.salt = in.readLong();
            this.signature = helper.readByteArray(in);
            this.verifyToken = null;
        }
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeByteArray(out, this.sharedKey);
        out.writeBoolean(this.verifyToken != null);
        if (this.verifyToken != null) {
            helper.writeByteArray(out, this.verifyToken);
        } else {
            out.writeLong(this.salt);
            helper.writeByteArray(out, this.signature);
        }
    }

    @Override
    public boolean isPriority() {
        return true;
    }

    private static byte[] runEncryption(int mode, Key key, byte[] data) {
        try {
            Cipher cipher = Cipher.getInstance(key.getAlgorithm().equals("RSA") ? "RSA/ECB/PKCS1Padding" : "AES/CFB8/NoPadding");
            cipher.init(mode, key);
            return cipher.doFinal(data);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("Failed to " + (mode == 2 ? "decrypt" : "encrypt") + " data.", e);
        }
    }

    public String toString() {
        return "ServerboundKeyPacket(sharedKey=" + Arrays.toString(this.sharedKey) + ", verifyToken=" + Arrays.toString(this.verifyToken) + ", salt=" + this.salt + ", signature=" + Arrays.toString(this.signature) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundKeyPacket)) {
            return false;
        }
        ServerboundKeyPacket other = (ServerboundKeyPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$salt = this.salt;
        Long other$salt = other.salt;
        if (this$salt == null ? other$salt != null : !((Object)this$salt).equals(other$salt)) {
            return false;
        }
        if (!Arrays.equals(this.sharedKey, other.sharedKey)) {
            return false;
        }
        if (!Arrays.equals(this.verifyToken, other.verifyToken)) {
            return false;
        }
        return Arrays.equals(this.signature, other.signature);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerboundKeyPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $salt = this.salt;
        result = result * 59 + ($salt == null ? 43 : ((Object)$salt).hashCode());
        result = result * 59 + Arrays.hashCode(this.sharedKey);
        result = result * 59 + Arrays.hashCode(this.verifyToken);
        result = result * 59 + Arrays.hashCode(this.signature);
        return result;
    }
}

