/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.login.clientbound;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import lombok.NonNull;

public class ClientboundHelloPacket
implements MinecraftPacket {
    @NonNull
    private final String serverId;
    @NonNull
    private final PublicKey publicKey;
    @NonNull
    private final byte[] verifyToken;

    public ClientboundHelloPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.serverId = helper.readString(in);
        byte[] publicKey = helper.readByteArray(in);
        this.verifyToken = helper.readByteArray(in);
        try {
            this.publicKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(publicKey));
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Could not decode public key.", e);
        }
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeString(out, this.serverId);
        byte[] encoded = this.publicKey.getEncoded();
        helper.writeByteArray(out, encoded);
        helper.writeByteArray(out, this.verifyToken);
    }

    @Override
    public boolean isPriority() {
        return true;
    }

    @NonNull
    public String getServerId() {
        return this.serverId;
    }

    @NonNull
    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @NonNull
    public byte[] getVerifyToken() {
        return this.verifyToken;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundHelloPacket)) {
            return false;
        }
        ClientboundHelloPacket other = (ClientboundHelloPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$serverId = this.getServerId();
        String other$serverId = other.getServerId();
        if (this$serverId == null ? other$serverId != null : !this$serverId.equals(other$serverId)) {
            return false;
        }
        PublicKey this$publicKey = this.getPublicKey();
        PublicKey other$publicKey = other.getPublicKey();
        if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
            return false;
        }
        return Arrays.equals(this.getVerifyToken(), other.getVerifyToken());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundHelloPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $serverId = this.getServerId();
        result = result * 59 + ($serverId == null ? 43 : $serverId.hashCode());
        PublicKey $publicKey = this.getPublicKey();
        result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
        result = result * 59 + Arrays.hashCode(this.getVerifyToken());
        return result;
    }

    public String toString() {
        return "ClientboundHelloPacket(serverId=" + this.getServerId() + ", publicKey=" + this.getPublicKey() + ", verifyToken=" + Arrays.toString(this.getVerifyToken()) + ")";
    }

    public ClientboundHelloPacket withServerId(@NonNull String serverId) {
        if (serverId == null) {
            throw new NullPointerException("serverId is marked non-null but is null");
        }
        return this.serverId == serverId ? this : new ClientboundHelloPacket(serverId, this.publicKey, this.verifyToken);
    }

    public ClientboundHelloPacket withPublicKey(@NonNull PublicKey publicKey) {
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        return this.publicKey == publicKey ? this : new ClientboundHelloPacket(this.serverId, publicKey, this.verifyToken);
    }

    public ClientboundHelloPacket withVerifyToken(@NonNull byte[] verifyToken) {
        if (verifyToken == null) {
            throw new NullPointerException("verifyToken is marked non-null but is null");
        }
        return this.verifyToken == verifyToken ? this : new ClientboundHelloPacket(this.serverId, this.publicKey, verifyToken);
    }

    public ClientboundHelloPacket(@NonNull String serverId, @NonNull PublicKey publicKey, @NonNull byte[] verifyToken) {
        if (serverId == null) {
            throw new NullPointerException("serverId is marked non-null but is null");
        }
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        if (verifyToken == null) {
            throw new NullPointerException("verifyToken is marked non-null but is null");
        }
        this.serverId = serverId;
        this.publicKey = publicKey;
        this.verifyToken = verifyToken;
    }
}

