/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.serverbound.player;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import io.netty.buffer.ByteBuf;
import java.io.IOException;

public class ServerboundMovePlayerPosRotPacket
implements MinecraftPacket {
    private final boolean onGround;
    private final double x;
    private final double y;
    private final double z;
    private final float yaw;
    private final float pitch;

    public ServerboundMovePlayerPosRotPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.x = in.readDouble();
        this.y = in.readDouble();
        this.z = in.readDouble();
        this.yaw = in.readFloat();
        this.pitch = in.readFloat();
        this.onGround = in.readBoolean();
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        out.writeDouble(this.x);
        out.writeDouble(this.y);
        out.writeDouble(this.z);
        out.writeFloat(this.yaw);
        out.writeFloat(this.pitch);
        out.writeBoolean(this.onGround);
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundMovePlayerPosRotPacket)) {
            return false;
        }
        ServerboundMovePlayerPosRotPacket other = (ServerboundMovePlayerPosRotPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isOnGround() != other.isOnGround()) {
            return false;
        }
        if (Double.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Double.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        if (Double.compare(this.getZ(), other.getZ()) != 0) {
            return false;
        }
        if (Float.compare(this.getYaw(), other.getYaw()) != 0) {
            return false;
        }
        return Float.compare(this.getPitch(), other.getPitch()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerboundMovePlayerPosRotPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isOnGround() ? 79 : 97);
        long $x = Double.doubleToLongBits(this.getX());
        result = result * 59 + (int)($x >>> 32 ^ $x);
        long $y = Double.doubleToLongBits(this.getY());
        result = result * 59 + (int)($y >>> 32 ^ $y);
        long $z = Double.doubleToLongBits(this.getZ());
        result = result * 59 + (int)($z >>> 32 ^ $z);
        result = result * 59 + Float.floatToIntBits(this.getYaw());
        result = result * 59 + Float.floatToIntBits(this.getPitch());
        return result;
    }

    public String toString() {
        return "ServerboundMovePlayerPosRotPacket(onGround=" + this.isOnGround() + ", x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", yaw=" + this.getYaw() + ", pitch=" + this.getPitch() + ")";
    }

    public ServerboundMovePlayerPosRotPacket withOnGround(boolean onGround) {
        return this.onGround == onGround ? this : new ServerboundMovePlayerPosRotPacket(onGround, this.x, this.y, this.z, this.yaw, this.pitch);
    }

    public ServerboundMovePlayerPosRotPacket withX(double x) {
        return this.x == x ? this : new ServerboundMovePlayerPosRotPacket(this.onGround, x, this.y, this.z, this.yaw, this.pitch);
    }

    public ServerboundMovePlayerPosRotPacket withY(double y) {
        return this.y == y ? this : new ServerboundMovePlayerPosRotPacket(this.onGround, this.x, y, this.z, this.yaw, this.pitch);
    }

    public ServerboundMovePlayerPosRotPacket withZ(double z) {
        return this.z == z ? this : new ServerboundMovePlayerPosRotPacket(this.onGround, this.x, this.y, z, this.yaw, this.pitch);
    }

    public ServerboundMovePlayerPosRotPacket withYaw(float yaw) {
        return this.yaw == yaw ? this : new ServerboundMovePlayerPosRotPacket(this.onGround, this.x, this.y, this.z, yaw, this.pitch);
    }

    public ServerboundMovePlayerPosRotPacket withPitch(float pitch) {
        return this.pitch == pitch ? this : new ServerboundMovePlayerPosRotPacket(this.onGround, this.x, this.y, this.z, this.yaw, pitch);
    }

    public ServerboundMovePlayerPosRotPacket(boolean onGround, double x, double y, double z, float yaw, float pitch) {
        this.onGround = onGround;
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
    }
}

