/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.serverbound.inventory;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ServerboundEditBookPacket
implements MinecraftPacket {
    private final int slot;
    private final List<String> pages;
    @Nullable
    private final String title;

    public ServerboundEditBookPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.slot = helper.readVarInt(in);
        this.pages = new ArrayList<String>();
        int pagesSize = helper.readVarInt(in);
        for (int i = 0; i < pagesSize; ++i) {
            this.pages.add(helper.readString(in));
        }
        this.title = in.readBoolean() ? helper.readString(in) : null;
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeVarInt(out, this.slot);
        helper.writeVarInt(out, this.pages.size());
        for (String page : this.pages) {
            helper.writeString(out, page);
        }
        out.writeBoolean(this.title != null);
        if (this.title != null) {
            helper.writeString(out, this.title);
        }
    }

    public int getSlot() {
        return this.slot;
    }

    public List<String> getPages() {
        return this.pages;
    }

    @Nullable
    public String getTitle() {
        return this.title;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundEditBookPacket)) {
            return false;
        }
        ServerboundEditBookPacket other = (ServerboundEditBookPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSlot() != other.getSlot()) {
            return false;
        }
        List<String> this$pages = this.getPages();
        List<String> other$pages = other.getPages();
        if (this$pages == null ? other$pages != null : !((Object)this$pages).equals(other$pages)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        return !(this$title == null ? other$title != null : !this$title.equals(other$title));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerboundEditBookPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSlot();
        List<String> $pages = this.getPages();
        result = result * 59 + ($pages == null ? 43 : ((Object)$pages).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        return result;
    }

    public String toString() {
        return "ServerboundEditBookPacket(slot=" + this.getSlot() + ", pages=" + this.getPages() + ", title=" + this.getTitle() + ")";
    }

    public ServerboundEditBookPacket withSlot(int slot) {
        return this.slot == slot ? this : new ServerboundEditBookPacket(slot, this.pages, this.title);
    }

    public ServerboundEditBookPacket withPages(List<String> pages) {
        return this.pages == pages ? this : new ServerboundEditBookPacket(this.slot, pages, this.title);
    }

    public ServerboundEditBookPacket withTitle(@Nullable String title) {
        return this.title == title ? this : new ServerboundEditBookPacket(this.slot, this.pages, title);
    }

    public ServerboundEditBookPacket(int slot, List<String> pages, @Nullable String title) {
        this.slot = slot;
        this.pages = pages;
        this.title = title;
    }
}

