/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.serverbound;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import io.netty.buffer.ByteBuf;
import java.io.IOException;

public class ServerboundChatPreviewPacket
implements MinecraftPacket {
    private final int queryId;
    private final String query;

    public ServerboundChatPreviewPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.queryId = in.readInt();
        this.query = helper.readString(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        out.writeInt(this.queryId);
        helper.writeString(out, this.query);
    }

    public int getQueryId() {
        return this.queryId;
    }

    public String getQuery() {
        return this.query;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundChatPreviewPacket)) {
            return false;
        }
        ServerboundChatPreviewPacket other = (ServerboundChatPreviewPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getQueryId() != other.getQueryId()) {
            return false;
        }
        String this$query = this.getQuery();
        String other$query = other.getQuery();
        return !(this$query == null ? other$query != null : !this$query.equals(other$query));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerboundChatPreviewPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getQueryId();
        String $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        return result;
    }

    public String toString() {
        return "ServerboundChatPreviewPacket(queryId=" + this.getQueryId() + ", query=" + this.getQuery() + ")";
    }

    public ServerboundChatPreviewPacket withQueryId(int queryId) {
        return this.queryId == queryId ? this : new ServerboundChatPreviewPacket(queryId, this.query);
    }

    public ServerboundChatPreviewPacket withQuery(String query) {
        return this.query == query ? this : new ServerboundChatPreviewPacket(this.queryId, query);
    }

    public ServerboundChatPreviewPacket(int queryId, String query) {
        this.queryId = queryId;
        this.query = query;
    }
}

