/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.serverbound;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.game.ArgumentSignature;
import com.github.steveice10.mc.protocol.data.game.LastSeenMessage;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ServerboundChatCommandPacket
implements MinecraftPacket {
    private final String command;
    private final long timeStamp;
    private final long salt;
    private final List<ArgumentSignature> signatures;
    private final boolean signedPreview;
    private final List<LastSeenMessage> lastSeenMessages;
    @Nullable
    private final LastSeenMessage lastReceivedMessage;

    public ServerboundChatCommandPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.command = helper.readString(in);
        this.timeStamp = in.readLong();
        this.salt = in.readLong();
        this.signatures = new ArrayList<ArgumentSignature>();
        int signatureCount = Math.min(helper.readVarInt(in), 8);
        for (int i = 0; i < signatureCount; ++i) {
            this.signatures.add(new ArgumentSignature(helper.readString(in), helper.readByteArray(in)));
        }
        this.signedPreview = in.readBoolean();
        this.lastSeenMessages = new ArrayList<LastSeenMessage>();
        int seenMessageCount = Math.min(helper.readVarInt(in), 5);
        for (int i = 0; i < seenMessageCount; ++i) {
            this.lastSeenMessages.add(new LastSeenMessage(helper.readUUID(in), helper.readByteArray(in)));
        }
        this.lastReceivedMessage = in.readBoolean() ? new LastSeenMessage(helper.readUUID(in), helper.readByteArray(in)) : null;
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeString(out, this.command);
        out.writeLong(this.timeStamp);
        out.writeLong(this.salt);
        helper.writeVarInt(out, this.signatures.size());
        for (ArgumentSignature signature : this.signatures) {
            helper.writeString(out, signature.getName());
            helper.writeVarInt(out, signature.getSignature().length);
            out.writeBytes(signature.getSignature());
        }
        out.writeBoolean(this.signedPreview);
        helper.writeVarInt(out, this.lastSeenMessages.size());
        for (LastSeenMessage entry : this.lastSeenMessages) {
            helper.writeUUID(out, entry.getProfileId());
            helper.writeVarInt(out, entry.getLastSignature().length);
            out.writeBytes(entry.getLastSignature());
        }
        if (this.lastReceivedMessage != null) {
            out.writeBoolean(true);
            helper.writeUUID(out, this.lastReceivedMessage.getProfileId());
            helper.writeVarInt(out, this.lastReceivedMessage.getLastSignature().length);
            out.writeBytes(this.lastReceivedMessage.getLastSignature());
        } else {
            out.writeBoolean(false);
        }
    }

    public String getCommand() {
        return this.command;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public long getSalt() {
        return this.salt;
    }

    public List<ArgumentSignature> getSignatures() {
        return this.signatures;
    }

    public boolean isSignedPreview() {
        return this.signedPreview;
    }

    public List<LastSeenMessage> getLastSeenMessages() {
        return this.lastSeenMessages;
    }

    @Nullable
    public LastSeenMessage getLastReceivedMessage() {
        return this.lastReceivedMessage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundChatCommandPacket)) {
            return false;
        }
        ServerboundChatCommandPacket other = (ServerboundChatCommandPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimeStamp() != other.getTimeStamp()) {
            return false;
        }
        if (this.getSalt() != other.getSalt()) {
            return false;
        }
        if (this.isSignedPreview() != other.isSignedPreview()) {
            return false;
        }
        String this$command = this.getCommand();
        String other$command = other.getCommand();
        if (this$command == null ? other$command != null : !this$command.equals(other$command)) {
            return false;
        }
        List<ArgumentSignature> this$signatures = this.getSignatures();
        List<ArgumentSignature> other$signatures = other.getSignatures();
        if (this$signatures == null ? other$signatures != null : !((Object)this$signatures).equals(other$signatures)) {
            return false;
        }
        List<LastSeenMessage> this$lastSeenMessages = this.getLastSeenMessages();
        List<LastSeenMessage> other$lastSeenMessages = other.getLastSeenMessages();
        if (this$lastSeenMessages == null ? other$lastSeenMessages != null : !((Object)this$lastSeenMessages).equals(other$lastSeenMessages)) {
            return false;
        }
        LastSeenMessage this$lastReceivedMessage = this.getLastReceivedMessage();
        LastSeenMessage other$lastReceivedMessage = other.getLastReceivedMessage();
        return !(this$lastReceivedMessage == null ? other$lastReceivedMessage != null : !((Object)this$lastReceivedMessage).equals(other$lastReceivedMessage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerboundChatCommandPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timeStamp = this.getTimeStamp();
        result = result * 59 + (int)($timeStamp >>> 32 ^ $timeStamp);
        long $salt = this.getSalt();
        result = result * 59 + (int)($salt >>> 32 ^ $salt);
        result = result * 59 + (this.isSignedPreview() ? 79 : 97);
        String $command = this.getCommand();
        result = result * 59 + ($command == null ? 43 : $command.hashCode());
        List<ArgumentSignature> $signatures = this.getSignatures();
        result = result * 59 + ($signatures == null ? 43 : ((Object)$signatures).hashCode());
        List<LastSeenMessage> $lastSeenMessages = this.getLastSeenMessages();
        result = result * 59 + ($lastSeenMessages == null ? 43 : ((Object)$lastSeenMessages).hashCode());
        LastSeenMessage $lastReceivedMessage = this.getLastReceivedMessage();
        result = result * 59 + ($lastReceivedMessage == null ? 43 : ((Object)$lastReceivedMessage).hashCode());
        return result;
    }

    public String toString() {
        return "ServerboundChatCommandPacket(command=" + this.getCommand() + ", timeStamp=" + this.getTimeStamp() + ", salt=" + this.getSalt() + ", signatures=" + this.getSignatures() + ", signedPreview=" + this.isSignedPreview() + ", lastSeenMessages=" + this.getLastSeenMessages() + ", lastReceivedMessage=" + this.getLastReceivedMessage() + ")";
    }

    public ServerboundChatCommandPacket withCommand(String command) {
        return this.command == command ? this : new ServerboundChatCommandPacket(command, this.timeStamp, this.salt, this.signatures, this.signedPreview, this.lastSeenMessages, this.lastReceivedMessage);
    }

    public ServerboundChatCommandPacket withTimeStamp(long timeStamp) {
        return this.timeStamp == timeStamp ? this : new ServerboundChatCommandPacket(this.command, timeStamp, this.salt, this.signatures, this.signedPreview, this.lastSeenMessages, this.lastReceivedMessage);
    }

    public ServerboundChatCommandPacket withSalt(long salt) {
        return this.salt == salt ? this : new ServerboundChatCommandPacket(this.command, this.timeStamp, salt, this.signatures, this.signedPreview, this.lastSeenMessages, this.lastReceivedMessage);
    }

    public ServerboundChatCommandPacket withSignatures(List<ArgumentSignature> signatures) {
        return this.signatures == signatures ? this : new ServerboundChatCommandPacket(this.command, this.timeStamp, this.salt, signatures, this.signedPreview, this.lastSeenMessages, this.lastReceivedMessage);
    }

    public ServerboundChatCommandPacket withSignedPreview(boolean signedPreview) {
        return this.signedPreview == signedPreview ? this : new ServerboundChatCommandPacket(this.command, this.timeStamp, this.salt, this.signatures, signedPreview, this.lastSeenMessages, this.lastReceivedMessage);
    }

    public ServerboundChatCommandPacket withLastSeenMessages(List<LastSeenMessage> lastSeenMessages) {
        return this.lastSeenMessages == lastSeenMessages ? this : new ServerboundChatCommandPacket(this.command, this.timeStamp, this.salt, this.signatures, this.signedPreview, lastSeenMessages, this.lastReceivedMessage);
    }

    public ServerboundChatCommandPacket withLastReceivedMessage(@Nullable LastSeenMessage lastReceivedMessage) {
        return this.lastReceivedMessage == lastReceivedMessage ? this : new ServerboundChatCommandPacket(this.command, this.timeStamp, this.salt, this.signatures, this.signedPreview, this.lastSeenMessages, lastReceivedMessage);
    }

    public ServerboundChatCommandPacket(String command, long timeStamp, long salt, List<ArgumentSignature> signatures, boolean signedPreview, List<LastSeenMessage> lastSeenMessages, @Nullable LastSeenMessage lastReceivedMessage) {
        this.command = command;
        this.timeStamp = timeStamp;
        this.salt = salt;
        this.signatures = signatures;
        this.signedPreview = signedPreview;
        this.lastSeenMessages = lastSeenMessages;
        this.lastReceivedMessage = lastReceivedMessage;
    }
}

