/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.level;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.level.block.value.BlockValue;
import com.github.steveice10.mc.protocol.data.game.level.block.value.BlockValueType;
import com.github.steveice10.mc.protocol.data.game.level.block.value.ChestValue;
import com.github.steveice10.mc.protocol.data.game.level.block.value.ChestValueType;
import com.github.steveice10.mc.protocol.data.game.level.block.value.EndGatewayValue;
import com.github.steveice10.mc.protocol.data.game.level.block.value.EndGatewayValueType;
import com.github.steveice10.mc.protocol.data.game.level.block.value.GenericBlockValue;
import com.github.steveice10.mc.protocol.data.game.level.block.value.GenericBlockValueType;
import com.github.steveice10.mc.protocol.data.game.level.block.value.MobSpawnerValue;
import com.github.steveice10.mc.protocol.data.game.level.block.value.MobSpawnerValueType;
import com.github.steveice10.mc.protocol.data.game.level.block.value.NoteBlockValue;
import com.github.steveice10.mc.protocol.data.game.level.block.value.NoteBlockValueType;
import com.github.steveice10.mc.protocol.data.game.level.block.value.PistonValue;
import com.github.steveice10.mc.protocol.data.game.level.block.value.PistonValueType;
import com.nukkitx.math.vector.Vector3i;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import lombok.NonNull;

public class ClientboundBlockEventPacket
implements MinecraftPacket {
    private static final int NOTE_BLOCK = 89;
    private static final int STICKY_PISTON = 108;
    private static final int PISTON = 115;
    private static final int MOB_SPAWNER = 160;
    private static final int CHEST = 162;
    private static final int ENDER_CHEST = 299;
    private static final int TRAPPED_CHEST = 360;
    private static final int END_GATEWAY = 537;
    private static final int SHULKER_BOX_LOWER = 547;
    private static final int SHULKER_BOX_HIGHER = 563;
    @NonNull
    private final Vector3i position;
    @NonNull
    private final BlockValueType type;
    @NonNull
    private final BlockValue value;
    private final int blockId;

    public ClientboundBlockEventPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.position = helper.readPosition(in);
        short type = in.readUnsignedByte();
        short value = in.readUnsignedByte();
        this.blockId = helper.readVarInt(in) & 0xFFF;
        if (this.blockId == 89) {
            this.type = MagicValues.key(NoteBlockValueType.class, type);
            this.value = new NoteBlockValue(value);
        } else if (this.blockId == 108 || this.blockId == 115) {
            this.type = MagicValues.key(PistonValueType.class, type);
            this.value = MagicValues.key(PistonValue.class, value);
        } else if (this.blockId == 160) {
            this.type = MagicValues.key(MobSpawnerValueType.class, type);
            this.value = new MobSpawnerValue();
        } else if (this.blockId == 162 || this.blockId == 299 || this.blockId == 360 || this.blockId >= 547 && this.blockId <= 563) {
            this.type = MagicValues.key(ChestValueType.class, type);
            this.value = new ChestValue(value);
        } else if (this.blockId == 537) {
            this.type = MagicValues.key(EndGatewayValueType.class, type);
            this.value = new EndGatewayValue();
        } else {
            this.type = MagicValues.key(GenericBlockValueType.class, type);
            this.value = new GenericBlockValue(value);
        }
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        int val = 0;
        if (this.type instanceof NoteBlockValueType) {
            val = ((NoteBlockValue)this.value).getPitch();
        } else if (this.type instanceof PistonValueType) {
            val = MagicValues.value(Integer.class, this.value);
        } else if (this.type instanceof ChestValueType) {
            val = ((ChestValue)this.value).getViewers();
        } else if (this.type instanceof GenericBlockValueType) {
            val = ((GenericBlockValue)this.value).getValue();
        }
        helper.writePosition(out, this.position);
        out.writeByte(MagicValues.value(Integer.class, this.type));
        out.writeByte(val);
        helper.writeVarInt(out, this.blockId & 0xFFF);
    }

    @NonNull
    public Vector3i getPosition() {
        return this.position;
    }

    @NonNull
    public BlockValueType getType() {
        return this.type;
    }

    @NonNull
    public BlockValue getValue() {
        return this.value;
    }

    public int getBlockId() {
        return this.blockId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundBlockEventPacket)) {
            return false;
        }
        ClientboundBlockEventPacket other = (ClientboundBlockEventPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getBlockId() != other.getBlockId()) {
            return false;
        }
        Vector3i this$position = this.getPosition();
        Vector3i other$position = other.getPosition();
        if (this$position == null ? other$position != null : !((Object)this$position).equals(other$position)) {
            return false;
        }
        BlockValueType this$type = this.getType();
        BlockValueType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        BlockValue this$value = this.getValue();
        BlockValue other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundBlockEventPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getBlockId();
        Vector3i $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : ((Object)$position).hashCode());
        BlockValueType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        BlockValue $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundBlockEventPacket(position=" + this.getPosition() + ", type=" + this.getType() + ", value=" + this.getValue() + ", blockId=" + this.getBlockId() + ")";
    }

    public ClientboundBlockEventPacket withPosition(@NonNull Vector3i position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        return this.position == position ? this : new ClientboundBlockEventPacket(position, this.type, this.value, this.blockId);
    }

    public ClientboundBlockEventPacket withType(@NonNull BlockValueType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.type == type ? this : new ClientboundBlockEventPacket(this.position, type, this.value, this.blockId);
    }

    public ClientboundBlockEventPacket withValue(@NonNull BlockValue value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return this.value == value ? this : new ClientboundBlockEventPacket(this.position, this.type, value, this.blockId);
    }

    public ClientboundBlockEventPacket withBlockId(int blockId) {
        return this.blockId == blockId ? this : new ClientboundBlockEventPacket(this.position, this.type, this.value, blockId);
    }

    public ClientboundBlockEventPacket(@NonNull Vector3i position, @NonNull BlockValueType type, @NonNull BlockValue value, int blockId) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.position = position;
        this.type = type;
        this.value = value;
        this.blockId = blockId;
    }
}

