/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.entity.player;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import org.geysermc.relocate.kyori.adventure.text.Component;

public class ClientboundPlayerCombatKillPacket
implements MinecraftPacket {
    private final int playerId;
    private final int killerId;
    private final Component message;

    public ClientboundPlayerCombatKillPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.playerId = helper.readVarInt(in);
        this.killerId = in.readInt();
        this.message = helper.readComponent(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeVarInt(out, this.playerId);
        out.writeInt(this.killerId);
        helper.writeComponent(out, this.message);
    }

    public int getPlayerId() {
        return this.playerId;
    }

    public int getKillerId() {
        return this.killerId;
    }

    public Component getMessage() {
        return this.message;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundPlayerCombatKillPacket)) {
            return false;
        }
        ClientboundPlayerCombatKillPacket other = (ClientboundPlayerCombatKillPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPlayerId() != other.getPlayerId()) {
            return false;
        }
        if (this.getKillerId() != other.getKillerId()) {
            return false;
        }
        Component this$message = this.getMessage();
        Component other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundPlayerCombatKillPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPlayerId();
        result = result * 59 + this.getKillerId();
        Component $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundPlayerCombatKillPacket(playerId=" + this.getPlayerId() + ", killerId=" + this.getKillerId() + ", message=" + this.getMessage() + ")";
    }

    public ClientboundPlayerCombatKillPacket withPlayerId(int playerId) {
        return this.playerId == playerId ? this : new ClientboundPlayerCombatKillPacket(playerId, this.killerId, this.message);
    }

    public ClientboundPlayerCombatKillPacket withKillerId(int killerId) {
        return this.killerId == killerId ? this : new ClientboundPlayerCombatKillPacket(this.playerId, killerId, this.message);
    }

    public ClientboundPlayerCombatKillPacket withMessage(Component message) {
        return this.message == message ? this : new ClientboundPlayerCombatKillPacket(this.playerId, this.killerId, message);
    }

    public ClientboundPlayerCombatKillPacket(int playerId, int killerId, Component message) {
        this.playerId = playerId;
        this.killerId = killerId;
        this.message = message;
    }
}

