/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.entity;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Arrays;
import lombok.NonNull;

public class ClientboundSetPassengersPacket
implements MinecraftPacket {
    private final int entityId;
    @NonNull
    private final int[] passengerIds;

    public ClientboundSetPassengersPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.entityId = helper.readVarInt(in);
        this.passengerIds = new int[helper.readVarInt(in)];
        for (int index = 0; index < this.passengerIds.length; ++index) {
            this.passengerIds[index] = helper.readVarInt(in);
        }
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeVarInt(out, this.entityId);
        helper.writeVarInt(out, this.passengerIds.length);
        for (int entityId : this.passengerIds) {
            helper.writeVarInt(out, entityId);
        }
    }

    public int getEntityId() {
        return this.entityId;
    }

    @NonNull
    public int[] getPassengerIds() {
        return this.passengerIds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSetPassengersPacket)) {
            return false;
        }
        ClientboundSetPassengersPacket other = (ClientboundSetPassengersPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        return Arrays.equals(this.getPassengerIds(), other.getPassengerIds());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundSetPassengersPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        result = result * 59 + Arrays.hashCode(this.getPassengerIds());
        return result;
    }

    public String toString() {
        return "ClientboundSetPassengersPacket(entityId=" + this.getEntityId() + ", passengerIds=" + Arrays.toString(this.getPassengerIds()) + ")";
    }

    public ClientboundSetPassengersPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ClientboundSetPassengersPacket(entityId, this.passengerIds);
    }

    public ClientboundSetPassengersPacket withPassengerIds(@NonNull int[] passengerIds) {
        if (passengerIds == null) {
            throw new NullPointerException("passengerIds is marked non-null but is null");
        }
        return this.passengerIds == passengerIds ? this : new ClientboundSetPassengersPacket(this.entityId, passengerIds);
    }

    public ClientboundSetPassengersPacket(int entityId, @NonNull int[] passengerIds) {
        if (passengerIds == null) {
            throw new NullPointerException("passengerIds is marked non-null but is null");
        }
        this.entityId = entityId;
        this.passengerIds = passengerIds;
    }
}

