/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.entity;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.entity.EquipmentSlot;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.Equipment;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.ItemStack;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import lombok.NonNull;

public class ClientboundSetEquipmentPacket
implements MinecraftPacket {
    private final int entityId;
    @NonNull
    private final Equipment[] equipment;

    public ClientboundSetEquipmentPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.entityId = helper.readVarInt(in);
        boolean hasNextEntry = true;
        ArrayList<Equipment> list = new ArrayList<Equipment>();
        while (hasNextEntry) {
            byte rawSlot = in.readByte();
            EquipmentSlot slot = MagicValues.key(EquipmentSlot.class, (byte)rawSlot & 0x7F);
            ItemStack item = helper.readItemStack(in);
            list.add(new Equipment(slot, item));
            hasNextEntry = (rawSlot & 0x80) == 128;
        }
        this.equipment = list.toArray(new Equipment[0]);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeVarInt(out, this.entityId);
        for (int i = 0; i < this.equipment.length; ++i) {
            int rawSlot = MagicValues.value(Integer.class, (Object)this.equipment[i].getSlot());
            if (i != this.equipment.length - 1) {
                rawSlot |= 0x80;
            }
            out.writeByte(rawSlot);
            helper.writeItemStack(out, this.equipment[i].getItem());
        }
    }

    public int getEntityId() {
        return this.entityId;
    }

    @NonNull
    public Equipment[] getEquipment() {
        return this.equipment;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSetEquipmentPacket)) {
            return false;
        }
        ClientboundSetEquipmentPacket other = (ClientboundSetEquipmentPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        return Arrays.deepEquals(this.getEquipment(), other.getEquipment());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundSetEquipmentPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        result = result * 59 + Arrays.deepHashCode(this.getEquipment());
        return result;
    }

    public String toString() {
        return "ClientboundSetEquipmentPacket(entityId=" + this.getEntityId() + ", equipment=" + Arrays.deepToString(this.getEquipment()) + ")";
    }

    public ClientboundSetEquipmentPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ClientboundSetEquipmentPacket(entityId, this.equipment);
    }

    public ClientboundSetEquipmentPacket withEquipment(@NonNull Equipment[] equipment) {
        if (equipment == null) {
            throw new NullPointerException("equipment is marked non-null but is null");
        }
        return this.equipment == equipment ? this : new ClientboundSetEquipmentPacket(this.entityId, equipment);
    }

    public ClientboundSetEquipmentPacket(int entityId, @NonNull Equipment[] equipment) {
        if (equipment == null) {
            throw new NullPointerException("equipment is marked non-null but is null");
        }
        this.entityId = entityId;
        this.equipment = equipment;
    }
}

