/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.DefaultComponentSerializer;
import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.advancement.Advancement;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.ItemStack;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.geysermc.relocate.kyori.adventure.text.Component;

public class ClientboundUpdateAdvancementsPacket
implements MinecraftPacket {
    private static final int FLAG_HAS_BACKGROUND_TEXTURE = 1;
    private static final int FLAG_SHOW_TOAST = 2;
    private static final int FLAG_HIDDEN = 4;
    private final boolean reset;
    @NonNull
    private final Advancement[] advancements;
    @NonNull
    private final String[] removedAdvancements;
    @NonNull
    private final Map<String, Map<String, Long>> progress;

    public Map<String, Long> getProgress(@NonNull String advancementId) {
        if (advancementId == null) {
            throw new NullPointerException("advancementId is marked non-null but is null");
        }
        return this.progress.get(advancementId);
    }

    public long getAchievedDate(@NonNull String advancementId, @NonNull String criterionId) {
        if (advancementId == null) {
            throw new NullPointerException("advancementId is marked non-null but is null");
        }
        if (criterionId == null) {
            throw new NullPointerException("criterionId is marked non-null but is null");
        }
        Map<String, Long> progress = this.getProgress(advancementId);
        if (progress == null || !progress.containsKey(criterionId)) {
            return -1L;
        }
        return progress.get(criterionId);
    }

    public ClientboundUpdateAdvancementsPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        int i;
        this.reset = in.readBoolean();
        this.advancements = new Advancement[helper.readVarInt(in)];
        for (i = 0; i < this.advancements.length; ++i) {
            String id = helper.readString(in);
            String parentId = in.readBoolean() ? helper.readString(in) : null;
            Advancement.DisplayData displayData = null;
            if (in.readBoolean()) {
                Component title = helper.readComponent(in);
                Component description = helper.readComponent(in);
                ItemStack icon = helper.readItemStack(in);
                Advancement.DisplayData.FrameType frameType = MagicValues.key(Advancement.DisplayData.FrameType.class, helper.readVarInt(in));
                int flags = in.readInt();
                boolean hasBackgroundTexture = (flags & 1) != 0;
                boolean showToast = (flags & 2) != 0;
                boolean hidden = (flags & 4) != 0;
                String backgroundTexture = hasBackgroundTexture ? helper.readString(in) : null;
                float posX = in.readFloat();
                float posY = in.readFloat();
                displayData = new Advancement.DisplayData(title, description, icon, frameType, showToast, hidden, posX, posY, backgroundTexture);
            }
            ArrayList<String> criteria = new ArrayList<String>();
            int criteriaCount = helper.readVarInt(in);
            for (int j = 0; j < criteriaCount; ++j) {
                criteria.add(helper.readString(in));
            }
            ArrayList<List<String>> requirements = new ArrayList<List<String>>();
            int requirementCount = helper.readVarInt(in);
            for (int j = 0; j < requirementCount; ++j) {
                ArrayList<String> requirement = new ArrayList<String>();
                int componentCount = helper.readVarInt(in);
                for (int k = 0; k < componentCount; ++k) {
                    requirement.add(helper.readString(in));
                }
                requirements.add(requirement);
            }
            this.advancements[i] = new Advancement(id, criteria, requirements, parentId, displayData);
        }
        this.removedAdvancements = new String[helper.readVarInt(in)];
        for (i = 0; i < this.removedAdvancements.length; ++i) {
            this.removedAdvancements[i] = helper.readString(in);
        }
        this.progress = new HashMap<String, Map<String, Long>>();
        int progressCount = helper.readVarInt(in);
        for (int i2 = 0; i2 < progressCount; ++i2) {
            String advancementId = helper.readString(in);
            HashMap<String, Long> advancementProgress = new HashMap<String, Long>();
            int criterionCount = helper.readVarInt(in);
            for (int j = 0; j < criterionCount; ++j) {
                String criterionId = helper.readString(in);
                long achievedDate = in.readBoolean() ? in.readLong() : -1L;
                advancementProgress.put(criterionId, achievedDate);
            }
            this.progress.put(advancementId, advancementProgress);
        }
    }

    /*
     * Could not resolve type clashes
     */
    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        out.writeBoolean(this.reset);
        helper.writeVarInt(out, this.advancements.length);
        for (Advancement advancement : this.advancements) {
            helper.writeString(out, advancement.getId());
            if (advancement.getParentId() != null) {
                out.writeBoolean(true);
                helper.writeString(out, advancement.getParentId());
            } else {
                out.writeBoolean(false);
            }
            Advancement.DisplayData displayData = advancement.getDisplayData();
            if (displayData != null) {
                out.writeBoolean(true);
                helper.writeString(out, (String)DefaultComponentSerializer.get().serialize(displayData.getTitle()));
                helper.writeString(out, (String)DefaultComponentSerializer.get().serialize(displayData.getDescription()));
                helper.writeItemStack(out, displayData.getIcon());
                helper.writeVarInt(out, MagicValues.value(Integer.class, (Object)displayData.getFrameType()));
                String backgroundTexture = displayData.getBackgroundTexture();
                int flags = 0;
                if (backgroundTexture != null) {
                    flags |= 1;
                }
                if (displayData.isShowToast()) {
                    flags |= 2;
                }
                if (displayData.isHidden()) {
                    flags |= 4;
                }
                out.writeInt(flags);
                if (backgroundTexture != null) {
                    helper.writeString(out, backgroundTexture);
                }
                out.writeFloat(displayData.getPosX());
                out.writeFloat(displayData.getPosY());
            } else {
                out.writeBoolean(false);
            }
            helper.writeVarInt(out, advancement.getCriteria().size());
            for (String criterion : advancement.getCriteria()) {
                helper.writeString(out, criterion);
            }
            helper.writeVarInt(out, advancement.getRequirements().size());
            for (List requirement : advancement.getRequirements()) {
                helper.writeVarInt(out, requirement.size());
                for (String criterion : requirement) {
                    helper.writeString(out, criterion);
                }
            }
        }
        helper.writeVarInt(out, this.removedAdvancements.length);
        for (String id : this.removedAdvancements) {
            helper.writeString(out, id);
        }
        helper.writeVarInt(out, this.progress.size());
        for (Map.Entry advancement : this.progress.entrySet()) {
            helper.writeString(out, (String)advancement.getKey());
            Map advancementProgress = (Map)advancement.getValue();
            helper.writeVarInt(out, advancementProgress.size());
            for (Map.Entry criterion : advancementProgress.entrySet()) {
                helper.writeString(out, (String)criterion.getKey());
                if ((Long)criterion.getValue() != -1L) {
                    out.writeBoolean(true);
                    out.writeLong((Long)criterion.getValue());
                    continue;
                }
                out.writeBoolean(false);
            }
        }
    }

    public boolean isReset() {
        return this.reset;
    }

    @NonNull
    public Advancement[] getAdvancements() {
        return this.advancements;
    }

    @NonNull
    public String[] getRemovedAdvancements() {
        return this.removedAdvancements;
    }

    @NonNull
    public Map<String, Map<String, Long>> getProgress() {
        return this.progress;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundUpdateAdvancementsPacket)) {
            return false;
        }
        ClientboundUpdateAdvancementsPacket other = (ClientboundUpdateAdvancementsPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isReset() != other.isReset()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getAdvancements(), other.getAdvancements())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getRemovedAdvancements(), other.getRemovedAdvancements())) {
            return false;
        }
        Map<String, Map<String, Long>> this$progress = this.getProgress();
        Map<String, Map<String, Long>> other$progress = other.getProgress();
        return !(this$progress == null ? other$progress != null : !((Object)this$progress).equals(other$progress));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundUpdateAdvancementsPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isReset() ? 79 : 97);
        result = result * 59 + Arrays.deepHashCode(this.getAdvancements());
        result = result * 59 + Arrays.deepHashCode(this.getRemovedAdvancements());
        Map<String, Map<String, Long>> $progress = this.getProgress();
        result = result * 59 + ($progress == null ? 43 : ((Object)$progress).hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundUpdateAdvancementsPacket(reset=" + this.isReset() + ", advancements=" + Arrays.deepToString(this.getAdvancements()) + ", removedAdvancements=" + Arrays.deepToString(this.getRemovedAdvancements()) + ", progress=" + this.getProgress() + ")";
    }

    public ClientboundUpdateAdvancementsPacket withReset(boolean reset) {
        return this.reset == reset ? this : new ClientboundUpdateAdvancementsPacket(reset, this.advancements, this.removedAdvancements, this.progress);
    }

    public ClientboundUpdateAdvancementsPacket withAdvancements(@NonNull Advancement[] advancements) {
        if (advancements == null) {
            throw new NullPointerException("advancements is marked non-null but is null");
        }
        return this.advancements == advancements ? this : new ClientboundUpdateAdvancementsPacket(this.reset, advancements, this.removedAdvancements, this.progress);
    }

    public ClientboundUpdateAdvancementsPacket withRemovedAdvancements(@NonNull String[] removedAdvancements) {
        if (removedAdvancements == null) {
            throw new NullPointerException("removedAdvancements is marked non-null but is null");
        }
        return this.removedAdvancements == removedAdvancements ? this : new ClientboundUpdateAdvancementsPacket(this.reset, this.advancements, removedAdvancements, this.progress);
    }

    public ClientboundUpdateAdvancementsPacket withProgress(@NonNull Map<String, Map<String, Long>> progress) {
        if (progress == null) {
            throw new NullPointerException("progress is marked non-null but is null");
        }
        return this.progress == progress ? this : new ClientboundUpdateAdvancementsPacket(this.reset, this.advancements, this.removedAdvancements, progress);
    }

    public ClientboundUpdateAdvancementsPacket(boolean reset, @NonNull Advancement[] advancements, @NonNull String[] removedAdvancements, @NonNull Map<String, Map<String, Long>> progress) {
        if (advancements == null) {
            throw new NullPointerException("advancements is marked non-null but is null");
        }
        if (removedAdvancements == null) {
            throw new NullPointerException("removedAdvancements is marked non-null but is null");
        }
        if (progress == null) {
            throw new NullPointerException("progress is marked non-null but is null");
        }
        this.reset = reset;
        this.advancements = advancements;
        this.removedAdvancements = removedAdvancements;
        this.progress = progress;
    }
}

