/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.DefaultComponentSerializer;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import org.geysermc.relocate.kyori.adventure.text.Component;
import org.jetbrains.annotations.Nullable;

public class ClientboundServerDataPacket
implements MinecraftPacket {
    @Nullable
    private final Component motd;
    @Nullable
    private final String iconBase64;
    private final boolean previewsChat;
    private final boolean enforcesSecureChat;

    public ClientboundServerDataPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.motd = in.readBoolean() ? helper.readComponent(in) : null;
        this.iconBase64 = in.readBoolean() ? helper.readString(in) : null;
        this.previewsChat = in.readBoolean();
        this.enforcesSecureChat = in.readBoolean();
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        out.writeBoolean(this.motd != null);
        if (this.motd != null) {
            helper.writeString(out, (String)DefaultComponentSerializer.get().serialize(this.motd));
        }
        out.writeBoolean(this.iconBase64 != null);
        if (this.iconBase64 != null) {
            helper.writeString(out, this.iconBase64);
        }
        out.writeBoolean(this.previewsChat);
        out.writeBoolean(this.enforcesSecureChat);
    }

    @Nullable
    public Component getMotd() {
        return this.motd;
    }

    @Nullable
    public String getIconBase64() {
        return this.iconBase64;
    }

    public boolean isPreviewsChat() {
        return this.previewsChat;
    }

    public boolean isEnforcesSecureChat() {
        return this.enforcesSecureChat;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundServerDataPacket)) {
            return false;
        }
        ClientboundServerDataPacket other = (ClientboundServerDataPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isPreviewsChat() != other.isPreviewsChat()) {
            return false;
        }
        if (this.isEnforcesSecureChat() != other.isEnforcesSecureChat()) {
            return false;
        }
        Component this$motd = this.getMotd();
        Component other$motd = other.getMotd();
        if (this$motd == null ? other$motd != null : !this$motd.equals(other$motd)) {
            return false;
        }
        String this$iconBase64 = this.getIconBase64();
        String other$iconBase64 = other.getIconBase64();
        return !(this$iconBase64 == null ? other$iconBase64 != null : !this$iconBase64.equals(other$iconBase64));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundServerDataPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPreviewsChat() ? 79 : 97);
        result = result * 59 + (this.isEnforcesSecureChat() ? 79 : 97);
        Component $motd = this.getMotd();
        result = result * 59 + ($motd == null ? 43 : $motd.hashCode());
        String $iconBase64 = this.getIconBase64();
        result = result * 59 + ($iconBase64 == null ? 43 : $iconBase64.hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundServerDataPacket(motd=" + this.getMotd() + ", iconBase64=" + this.getIconBase64() + ", previewsChat=" + this.isPreviewsChat() + ", enforcesSecureChat=" + this.isEnforcesSecureChat() + ")";
    }

    public ClientboundServerDataPacket withMotd(@Nullable Component motd) {
        return this.motd == motd ? this : new ClientboundServerDataPacket(motd, this.iconBase64, this.previewsChat, this.enforcesSecureChat);
    }

    public ClientboundServerDataPacket withIconBase64(@Nullable String iconBase64) {
        return this.iconBase64 == iconBase64 ? this : new ClientboundServerDataPacket(this.motd, iconBase64, this.previewsChat, this.enforcesSecureChat);
    }

    public ClientboundServerDataPacket withPreviewsChat(boolean previewsChat) {
        return this.previewsChat == previewsChat ? this : new ClientboundServerDataPacket(this.motd, this.iconBase64, previewsChat, this.enforcesSecureChat);
    }

    public ClientboundServerDataPacket withEnforcesSecureChat(boolean enforcesSecureChat) {
        return this.enforcesSecureChat == enforcesSecureChat ? this : new ClientboundServerDataPacket(this.motd, this.iconBase64, this.previewsChat, enforcesSecureChat);
    }

    public ClientboundServerDataPacket(@Nullable Component motd, @Nullable String iconBase64, boolean previewsChat, boolean enforcesSecureChat) {
        this.motd = motd;
        this.iconBase64 = iconBase64;
        this.previewsChat = previewsChat;
        this.enforcesSecureChat = enforcesSecureChat;
    }
}

