/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import lombok.NonNull;
import org.geysermc.relocate.kyori.adventure.text.Component;
import org.jetbrains.annotations.Nullable;

public class ClientboundResourcePackPacket
implements MinecraftPacket {
    @NonNull
    private final String url;
    @NonNull
    private final String hash;
    private final boolean required;
    @Nullable
    private final Component prompt;

    public ClientboundResourcePackPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.url = helper.readString(in);
        this.hash = helper.readString(in);
        this.required = in.readBoolean();
        this.prompt = in.readBoolean() ? helper.readComponent(in) : null;
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeString(out, this.url);
        helper.writeString(out, this.hash);
        out.writeBoolean(this.required);
        out.writeBoolean(this.prompt != null);
        if (this.prompt != null) {
            helper.writeComponent(out, this.prompt);
        }
    }

    @NonNull
    public String getUrl() {
        return this.url;
    }

    @NonNull
    public String getHash() {
        return this.hash;
    }

    public boolean isRequired() {
        return this.required;
    }

    @Nullable
    public Component getPrompt() {
        return this.prompt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundResourcePackPacket)) {
            return false;
        }
        ClientboundResourcePackPacket other = (ClientboundResourcePackPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isRequired() != other.isRequired()) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$hash = this.getHash();
        String other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) {
            return false;
        }
        Component this$prompt = this.getPrompt();
        Component other$prompt = other.getPrompt();
        return !(this$prompt == null ? other$prompt != null : !this$prompt.equals(other$prompt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundResourcePackPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isRequired() ? 79 : 97);
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
        Component $prompt = this.getPrompt();
        result = result * 59 + ($prompt == null ? 43 : $prompt.hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundResourcePackPacket(url=" + this.getUrl() + ", hash=" + this.getHash() + ", required=" + this.isRequired() + ", prompt=" + this.getPrompt() + ")";
    }

    public ClientboundResourcePackPacket withUrl(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        return this.url == url ? this : new ClientboundResourcePackPacket(url, this.hash, this.required, this.prompt);
    }

    public ClientboundResourcePackPacket withHash(@NonNull String hash) {
        if (hash == null) {
            throw new NullPointerException("hash is marked non-null but is null");
        }
        return this.hash == hash ? this : new ClientboundResourcePackPacket(this.url, hash, this.required, this.prompt);
    }

    public ClientboundResourcePackPacket withRequired(boolean required) {
        return this.required == required ? this : new ClientboundResourcePackPacket(this.url, this.hash, required, this.prompt);
    }

    public ClientboundResourcePackPacket withPrompt(@Nullable Component prompt) {
        return this.prompt == prompt ? this : new ClientboundResourcePackPacket(this.url, this.hash, this.required, prompt);
    }

    public ClientboundResourcePackPacket(@NonNull String url, @NonNull String hash, boolean required, @Nullable Component prompt) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (hash == null) {
            throw new NullPointerException("hash is marked non-null but is null");
        }
        this.url = url;
        this.hash = hash;
        this.required = required;
        this.prompt = prompt;
    }
}

