/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Arrays;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public class ClientboundPlayerChatHeaderPacket
implements MinecraftPacket {
    private final byte @Nullable [] previousSignature;
    private final UUID sender;
    private final byte[] headerSignature;
    private final byte[] bodyDigest;

    public ClientboundPlayerChatHeaderPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.previousSignature = (byte[])(in.readBoolean() ? helper.readByteArray(in) : null);
        this.sender = helper.readUUID(in);
        this.headerSignature = helper.readByteArray(in);
        this.bodyDigest = helper.readByteArray(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        if (this.previousSignature != null) {
            out.writeBoolean(true);
            helper.writeVarInt(out, this.previousSignature.length);
            out.writeBytes(this.previousSignature);
        } else {
            out.writeBoolean(false);
        }
        helper.writeUUID(out, this.sender);
        helper.writeVarInt(out, this.headerSignature.length);
        out.writeBytes(this.headerSignature);
        helper.writeVarInt(out, this.bodyDigest.length);
        out.writeBytes(this.bodyDigest);
    }

    public byte @Nullable [] getPreviousSignature() {
        return this.previousSignature;
    }

    public UUID getSender() {
        return this.sender;
    }

    public byte[] getHeaderSignature() {
        return this.headerSignature;
    }

    public byte[] getBodyDigest() {
        return this.bodyDigest;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundPlayerChatHeaderPacket)) {
            return false;
        }
        ClientboundPlayerChatHeaderPacket other = (ClientboundPlayerChatHeaderPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.getPreviousSignature(), other.getPreviousSignature())) {
            return false;
        }
        UUID this$sender = this.getSender();
        UUID other$sender = other.getSender();
        if (this$sender == null ? other$sender != null : !((Object)this$sender).equals(other$sender)) {
            return false;
        }
        if (!Arrays.equals(this.getHeaderSignature(), other.getHeaderSignature())) {
            return false;
        }
        return Arrays.equals(this.getBodyDigest(), other.getBodyDigest());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundPlayerChatHeaderPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getPreviousSignature());
        UUID $sender = this.getSender();
        result = result * 59 + ($sender == null ? 43 : ((Object)$sender).hashCode());
        result = result * 59 + Arrays.hashCode(this.getHeaderSignature());
        result = result * 59 + Arrays.hashCode(this.getBodyDigest());
        return result;
    }

    public String toString() {
        return "ClientboundPlayerChatHeaderPacket(previousSignature=" + this.getPreviousSignature() + ", sender=" + this.getSender() + ", headerSignature=" + Arrays.toString(this.getHeaderSignature()) + ", bodyDigest=" + Arrays.toString(this.getBodyDigest()) + ")";
    }

    public ClientboundPlayerChatHeaderPacket withPreviousSignature(byte @Nullable [] previousSignature) {
        return this.previousSignature == previousSignature ? this : new ClientboundPlayerChatHeaderPacket(previousSignature, this.sender, this.headerSignature, this.bodyDigest);
    }

    public ClientboundPlayerChatHeaderPacket withSender(UUID sender) {
        return this.sender == sender ? this : new ClientboundPlayerChatHeaderPacket(this.previousSignature, sender, this.headerSignature, this.bodyDigest);
    }

    public ClientboundPlayerChatHeaderPacket withHeaderSignature(byte[] headerSignature) {
        return this.headerSignature == headerSignature ? this : new ClientboundPlayerChatHeaderPacket(this.previousSignature, this.sender, headerSignature, this.bodyDigest);
    }

    public ClientboundPlayerChatHeaderPacket withBodyDigest(byte[] bodyDigest) {
        return this.bodyDigest == bodyDigest ? this : new ClientboundPlayerChatHeaderPacket(this.previousSignature, this.sender, this.headerSignature, bodyDigest);
    }

    public ClientboundPlayerChatHeaderPacket(byte @Nullable [] previousSignature, UUID sender, byte[] headerSignature, byte[] bodyDigest) {
        this.previousSignature = previousSignature;
        this.sender = sender;
        this.headerSignature = headerSignature;
        this.bodyDigest = bodyDigest;
    }
}

