/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.data.game.level;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import lombok.NonNull;

public class LightUpdateData {
    @NonNull
    private final BitSet skyYMask;
    @NonNull
    private final BitSet blockYMask;
    @NonNull
    private final BitSet emptySkyYMask;
    @NonNull
    private final BitSet emptyBlockYMask;
    @NonNull
    private final List<byte[]> skyUpdates;
    @NonNull
    private final List<byte[]> blockUpdates;
    private final boolean trustEdges;

    public static LightUpdateData read(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        return new LightUpdateData(in, helper);
    }

    private LightUpdateData(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.trustEdges = in.readBoolean();
        this.skyYMask = BitSet.valueOf(helper.readLongArray(in));
        this.blockYMask = BitSet.valueOf(helper.readLongArray(in));
        this.emptySkyYMask = BitSet.valueOf(helper.readLongArray(in));
        this.emptyBlockYMask = BitSet.valueOf(helper.readLongArray(in));
        int skyUpdateSize = helper.readVarInt(in);
        this.skyUpdates = new ArrayList<byte[]>(skyUpdateSize);
        for (int i = 0; i < skyUpdateSize; ++i) {
            this.skyUpdates.add(helper.readByteArray(in));
        }
        int blockUpdateSize = helper.readVarInt(in);
        this.blockUpdates = new ArrayList<byte[]>(blockUpdateSize);
        for (int i = 0; i < blockUpdateSize; ++i) {
            this.blockUpdates.add(helper.readByteArray(in));
        }
    }

    public static void write(ByteBuf out, MinecraftCodecHelper helper, LightUpdateData data) throws IOException {
        data.write(out, helper);
    }

    private void write(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        out.writeBoolean(this.trustEdges);
        this.writeBitSet(out, helper, this.skyYMask);
        this.writeBitSet(out, helper, this.blockYMask);
        this.writeBitSet(out, helper, this.emptySkyYMask);
        this.writeBitSet(out, helper, this.emptyBlockYMask);
        helper.writeVarInt(out, this.skyUpdates.size());
        for (byte[] array : this.skyUpdates) {
            helper.writeByteArray(out, array);
        }
        helper.writeVarInt(out, this.blockUpdates.size());
        for (byte[] array : this.blockUpdates) {
            helper.writeByteArray(out, array);
        }
    }

    private void writeBitSet(ByteBuf out, MinecraftCodecHelper helper, BitSet bitSet) throws IOException {
        long[] array = bitSet.toLongArray();
        helper.writeLongArray(out, array);
    }

    @NonNull
    public BitSet getSkyYMask() {
        return this.skyYMask;
    }

    @NonNull
    public BitSet getBlockYMask() {
        return this.blockYMask;
    }

    @NonNull
    public BitSet getEmptySkyYMask() {
        return this.emptySkyYMask;
    }

    @NonNull
    public BitSet getEmptyBlockYMask() {
        return this.emptyBlockYMask;
    }

    @NonNull
    public List<byte[]> getSkyUpdates() {
        return this.skyUpdates;
    }

    @NonNull
    public List<byte[]> getBlockUpdates() {
        return this.blockUpdates;
    }

    public boolean isTrustEdges() {
        return this.trustEdges;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LightUpdateData)) {
            return false;
        }
        LightUpdateData other = (LightUpdateData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isTrustEdges() != other.isTrustEdges()) {
            return false;
        }
        BitSet this$skyYMask = this.getSkyYMask();
        BitSet other$skyYMask = other.getSkyYMask();
        if (this$skyYMask == null ? other$skyYMask != null : !((Object)this$skyYMask).equals(other$skyYMask)) {
            return false;
        }
        BitSet this$blockYMask = this.getBlockYMask();
        BitSet other$blockYMask = other.getBlockYMask();
        if (this$blockYMask == null ? other$blockYMask != null : !((Object)this$blockYMask).equals(other$blockYMask)) {
            return false;
        }
        BitSet this$emptySkyYMask = this.getEmptySkyYMask();
        BitSet other$emptySkyYMask = other.getEmptySkyYMask();
        if (this$emptySkyYMask == null ? other$emptySkyYMask != null : !((Object)this$emptySkyYMask).equals(other$emptySkyYMask)) {
            return false;
        }
        BitSet this$emptyBlockYMask = this.getEmptyBlockYMask();
        BitSet other$emptyBlockYMask = other.getEmptyBlockYMask();
        if (this$emptyBlockYMask == null ? other$emptyBlockYMask != null : !((Object)this$emptyBlockYMask).equals(other$emptyBlockYMask)) {
            return false;
        }
        List<byte[]> this$skyUpdates = this.getSkyUpdates();
        List<byte[]> other$skyUpdates = other.getSkyUpdates();
        if (this$skyUpdates == null ? other$skyUpdates != null : !((Object)this$skyUpdates).equals(other$skyUpdates)) {
            return false;
        }
        List<byte[]> this$blockUpdates = this.getBlockUpdates();
        List<byte[]> other$blockUpdates = other.getBlockUpdates();
        return !(this$blockUpdates == null ? other$blockUpdates != null : !((Object)this$blockUpdates).equals(other$blockUpdates));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LightUpdateData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isTrustEdges() ? 79 : 97);
        BitSet $skyYMask = this.getSkyYMask();
        result = result * 59 + ($skyYMask == null ? 43 : ((Object)$skyYMask).hashCode());
        BitSet $blockYMask = this.getBlockYMask();
        result = result * 59 + ($blockYMask == null ? 43 : ((Object)$blockYMask).hashCode());
        BitSet $emptySkyYMask = this.getEmptySkyYMask();
        result = result * 59 + ($emptySkyYMask == null ? 43 : ((Object)$emptySkyYMask).hashCode());
        BitSet $emptyBlockYMask = this.getEmptyBlockYMask();
        result = result * 59 + ($emptyBlockYMask == null ? 43 : ((Object)$emptyBlockYMask).hashCode());
        List<byte[]> $skyUpdates = this.getSkyUpdates();
        result = result * 59 + ($skyUpdates == null ? 43 : ((Object)$skyUpdates).hashCode());
        List<byte[]> $blockUpdates = this.getBlockUpdates();
        result = result * 59 + ($blockUpdates == null ? 43 : ((Object)$blockUpdates).hashCode());
        return result;
    }

    public String toString() {
        return "LightUpdateData(skyYMask=" + this.getSkyYMask() + ", blockYMask=" + this.getBlockYMask() + ", emptySkyYMask=" + this.getEmptySkyYMask() + ", emptyBlockYMask=" + this.getEmptyBlockYMask() + ", skyUpdates=" + this.getSkyUpdates() + ", blockUpdates=" + this.getBlockUpdates() + ", trustEdges=" + this.isTrustEdges() + ")";
    }

    public LightUpdateData(@NonNull BitSet skyYMask, @NonNull BitSet blockYMask, @NonNull BitSet emptySkyYMask, @NonNull BitSet emptyBlockYMask, @NonNull List<byte[]> skyUpdates, @NonNull List<byte[]> blockUpdates, boolean trustEdges) {
        if (skyYMask == null) {
            throw new NullPointerException("skyYMask is marked non-null but is null");
        }
        if (blockYMask == null) {
            throw new NullPointerException("blockYMask is marked non-null but is null");
        }
        if (emptySkyYMask == null) {
            throw new NullPointerException("emptySkyYMask is marked non-null but is null");
        }
        if (emptyBlockYMask == null) {
            throw new NullPointerException("emptyBlockYMask is marked non-null but is null");
        }
        if (skyUpdates == null) {
            throw new NullPointerException("skyUpdates is marked non-null but is null");
        }
        if (blockUpdates == null) {
            throw new NullPointerException("blockUpdates is marked non-null but is null");
        }
        this.skyYMask = skyYMask;
        this.blockYMask = blockYMask;
        this.emptySkyYMask = emptySkyYMask;
        this.emptyBlockYMask = emptyBlockYMask;
        this.skyUpdates = skyUpdates;
        this.blockUpdates = blockUpdates;
        this.trustEdges = trustEdges;
    }
}

