/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.data.game.entity.metadata;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.EntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.MetadataType;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.type.ByteEntityMetadata;
import io.netty.buffer.ByteBuf;
import java.io.IOException;

public class ByteMetadataType
extends MetadataType<Byte> {
    private final ByteReader primitiveReader;
    private final ByteWriter primitiveWriter;
    private final ByteEntityMetadataFactory primitiveFactory;

    protected ByteMetadataType(ByteReader reader, ByteWriter writer, ByteEntityMetadataFactory metadataFactory) {
        super(reader, writer, metadataFactory);
        this.primitiveReader = reader;
        this.primitiveWriter = writer;
        this.primitiveFactory = metadataFactory;
    }

    @Override
    public EntityMetadata<Byte, ByteMetadataType> readMetadata(MinecraftCodecHelper helper, ByteBuf input, int id) throws IOException {
        return this.primitiveFactory.createPrimitive(id, this, this.primitiveReader.readPrimitive(input));
    }

    public void writeMetadataPrimitive(ByteBuf output, byte value) throws IOException {
        this.primitiveWriter.writePrimitive(output, value);
    }

    @FunctionalInterface
    public static interface ByteEntityMetadataFactory
    extends MetadataType.EntityMetadataFactory<Byte> {
        public ByteEntityMetadata createPrimitive(int var1, ByteMetadataType var2, byte var3);

        @Override
        @Deprecated
        default public EntityMetadata<Byte, ByteMetadataType> create(int id, MetadataType<Byte> type, Byte value) {
            throw new UnsupportedOperationException("Unsupported read method! Use primitive createPrimitive!");
        }
    }

    @FunctionalInterface
    public static interface ByteWriter
    extends MetadataType.BasicWriter<Byte> {
        public void writePrimitive(ByteBuf var1, byte var2) throws IOException;

        @Override
        @Deprecated
        default public void write(ByteBuf output, Byte value) throws IOException {
            this.writePrimitive(output, value);
        }
    }

    @FunctionalInterface
    public static interface ByteReader
    extends MetadataType.BasicReader<Byte> {
        public byte readPrimitive(ByteBuf var1) throws IOException;

        @Override
        @Deprecated
        default public Byte read(ByteBuf input) throws IOException {
            return this.readPrimitive(input);
        }
    }
}

