/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.betterfabricconsole.remap;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.mappingio.tree.MappingTree;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import org.checkerframework.checker.nullness.qual.Nullable;
import xyz.jpenilla.betterfabricconsole.remap.MappingsCache;
import xyz.jpenilla.betterfabricconsole.remap.Remapper;
import xyz.jpenilla.betterfabricconsole.util.StringPool;
import xyz.jpenilla.betterfabricconsole.util.ThrowingConsumer;

record RemapperImpl(Map<String, String> classes, Map<String, String> methods) implements Remapper
{
    @Override
    public void remapThrowable(Throwable throwable) {
        throwable.setStackTrace(this.remapStacktrace(throwable.getStackTrace()));
        Throwable cause = throwable.getCause();
        if (cause != null) {
            this.remapThrowable(cause);
        }
        for (Throwable suppressed : throwable.getSuppressed()) {
            this.remapThrowable(suppressed);
        }
    }

    @Override
    public StackTraceElement[] remapStacktrace(StackTraceElement[] trace) {
        StackTraceElement[] newTrace = new StackTraceElement[trace.length];
        for (int i = 0; i < trace.length; ++i) {
            String mapped;
            StackTraceElement old = trace[i];
            @Nullable String sourceFile = old.getFileName();
            Object newSourceFile = sourceFile == null ? null : ((mapped = this.classes.get("net.minecraft." + sourceFile.replace(".java", ""))) == null ? sourceFile : mapped.substring(mapped.lastIndexOf(46) + 1) + ".java");
            newTrace[i] = new StackTraceElement(old.getClassLoaderName(), old.getModuleName(), old.getModuleVersion(), this.classes.getOrDefault(old.getClassName(), old.getClassName()), this.methods.getOrDefault(old.getMethodName(), old.getMethodName()), (String)newSourceFile, old.getLineNumber());
        }
        return newTrace;
    }

    @Override
    public String remapClassName(String name) {
        return this.classes.getOrDefault(name, name);
    }

    static Remapper fromMappingTree(String toNamespace, ThrowingConsumer<MemoryMappingTree, IOException> populator) throws IOException {
        LOGGER.info("Reading mappings...");
        long start = System.currentTimeMillis();
        MemoryMappingTree tree = new MemoryMappingTree();
        populator.accept(tree);
        StringPool stringPool = new StringPool(new HashMap<String, String>());
        HashMap<String, String> classMapBuilder = new HashMap<String, String>();
        HashMap<String, String> methodMapBuilder = new HashMap<String, String>();
        for (MappingTree.ClassMapping clazz : tree.getClasses()) {
            @Nullable String icName = clazz.getName("intermediary");
            @Nullable String cName = clazz.getName(toNamespace);
            if (icName != null && cName != null) {
                classMapBuilder.put(RemapperImpl.slashToDot(icName), RemapperImpl.slashToDot(cName));
            }
            for (MappingTree.MethodMapping method : clazz.getMethods()) {
                @Nullable String imName = method.getName("intermediary");
                @Nullable String mName = method.getName(toNamespace);
                if (imName == null || mName == null) continue;
                methodMapBuilder.put(imName, stringPool.string(mName));
            }
        }
        RemapperImpl remapper = new RemapperImpl(Map.copyOf(classMapBuilder), Map.copyOf(methodMapBuilder));
        LOGGER.info("Done in {} seconds.", (Object)MappingsCache.DECIMAL_FORMAT.format((double)(System.currentTimeMillis() - start) / 1000.0));
        return remapper;
    }

    private static String slashToDot(String slahsed) {
        return slahsed.replace("/", ".");
    }
}

