/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.betterfabricconsole;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.logging.LogUtils;
import java.util.function.Function;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.minecraft.class_140;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_3176;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import xyz.jpenilla.betterfabricconsole.BetterFabricConsolePreLaunch;
import xyz.jpenilla.betterfabricconsole.adventure.LoggingComponentSerializerHolder;
import xyz.jpenilla.betterfabricconsole.configuration.Config;
import xyz.jpenilla.betterfabricconsole.console.ConsoleState;
import xyz.jpenilla.betterfabricconsole.console.ConsoleThread;
import xyz.jpenilla.betterfabricconsole.console.MinecraftCommandCompleter;
import xyz.jpenilla.betterfabricconsole.console.MinecraftCommandHighlighter;

public final class BetterFabricConsole
implements ModInitializer {
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final TextColor PINK = TextColor.color((int)16742854);
    private static @MonotonicNonNull BetterFabricConsole INSTANCE;
    private volatile @Nullable class_3176 server;

    public void onInitialize() {
        INSTANCE = this;
        CommandRegistrationCallback.EVENT.register(this::registerCommands);
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            this.server = (class_3176)server;
            this.initConsoleThread((class_3176)server);
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> {
            this.server = null;
        });
    }

    private void initConsoleThread(class_3176 server) {
        ConsoleState consoleState = BetterFabricConsolePreLaunch.INSTANCE.consoleState;
        consoleState.completer().delegateTo(new MinecraftCommandCompleter((MinecraftServer)server));
        consoleState.highlighter().delegateTo(new MinecraftCommandHighlighter((MinecraftServer)server, this.config().highlightColors()));
        ConsoleThread consoleThread = new ConsoleThread(server, consoleState.lineReader());
        consoleThread.setDaemon(true);
        consoleThread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new class_140(LOGGER));
        consoleThread.start();
    }

    private void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 commandBuildContext, class_2170.class_5364 commandSelection) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"better-fabric-console").requires(stack -> stack.method_9259(stack.method_9211().method_3798()))).executes(this::executeCommand));
    }

    private int executeCommand(CommandContext<class_2168> ctx) {
        ((class_2168)ctx.getSource()).sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GRAY)).append((Component)Component.text((String)"Better Fabric Console", (TextColor)PINK, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append(Component.text().content(" v").decorate(TextDecoration.ITALIC))).append((Component)Component.text((String)BetterFabricConsolePreLaunch.INSTANCE.modContainer.getMetadata().getVersion().getFriendlyString())));
        return 1;
    }

    public Config config() {
        return BetterFabricConsolePreLaunch.INSTANCE.config;
    }

    public @Nullable Function<Component, String> loggingComponentSerializer() {
        if (this.server == null) {
            return null;
        }
        return ((LoggingComponentSerializerHolder)this.server).loggingComponentSerializer();
    }

    public static @Nullable BetterFabricConsole instanceOrNull() {
        return INSTANCE;
    }

    public static BetterFabricConsole instance() {
        if (INSTANCE == null) {
            throw new IllegalStateException("Better Fabric Console has not yet been initialized!");
        }
        return INSTANCE;
    }
}

