/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.block.hopper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.jellysquid.mods.lithium.api.inventory.LithiumInventory;
import me.jellysquid.mods.lithium.common.entity.tracker.nearby.SectionedInventoryEntityMovementTracker;
import me.jellysquid.mods.lithium.common.entity.tracker.nearby.SectionedItemEntityMovementTracker;
import me.jellysquid.mods.lithium.common.hopper.HopperCachingState;
import me.jellysquid.mods.lithium.common.hopper.HopperHelper;
import me.jellysquid.mods.lithium.common.hopper.InventoryHelper;
import me.jellysquid.mods.lithium.common.hopper.LithiumStackList;
import me.jellysquid.mods.lithium.common.hopper.RemovalCounter;
import me.jellysquid.mods.lithium.common.hopper.UpdateReceiver;
import net.minecraft.class_1258;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2377;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2614;
import net.minecraft.class_2615;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_2614.class})
public abstract class HopperBlockEntityMixin
extends class_2586
implements class_2615,
UpdateReceiver,
LithiumInventory {
    @Shadow
    private long field_12022;
    private long myModCountAtLastInsert;
    private long myModCountAtLastExtract;
    private long myModCountAtLastItemCollect;
    private HopperCachingState.BlockInventory insertionMode = HopperCachingState.BlockInventory.UNKNOWN;
    private HopperCachingState.BlockInventory extractionMode = HopperCachingState.BlockInventory.UNKNOWN;
    @Nullable
    private class_1263 insertBlockInventory;
    @Nullable
    private class_1263 extractBlockInventory;
    private int insertBlockEntityRemovedCount;
    private int extractBlockEntityRemovedCount;
    @Nullable
    private LithiumInventory insertInventory;
    @Nullable
    private LithiumInventory extractInventory;
    @Nullable
    private LithiumStackList insertStackList;
    @Nullable
    private LithiumStackList extractStackList;
    private long insertStackListModCount;
    private long extractStackListModCount;
    private SectionedItemEntityMovementTracker<class_1542> collectItemEntityTracker;
    private boolean collectItemEntityTrackerWasEmpty;
    private class_238[] collectItemEntityBoxes;
    private long collectItemEntityAttemptTime;
    private SectionedInventoryEntityMovementTracker<class_1263> extractInventoryEntityTracker;
    private class_238 extractInventoryEntityBox;
    private long extractInventoryEntityFailedSearchTime;
    private SectionedInventoryEntityMovementTracker<class_1263> insertInventoryEntityTracker;
    private class_238 insertInventoryEntityBox;
    private long insertInventoryEntityFailedSearchTime;

    public HopperBlockEntityMixin(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Shadow
    @Nullable
    private static native class_1263 method_11248(class_1937 var0, class_2615 var1);

    @Shadow
    private static native boolean method_11246(class_1937 var0, class_2338 var1, class_2680 var2, class_1263 var3);

    @Shadow
    protected abstract boolean method_11242();

    @Shadow
    private static native boolean method_11252(class_1263 var0, class_1799 var1, int var2, class_2350 var3);

    @Redirect(method={"extract(Lnet/minecraft/world/World;Lnet/minecraft/block/entity/Hopper;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/entity/HopperBlockEntity;getInputInventory(Lnet/minecraft/world/World;Lnet/minecraft/block/entity/Hopper;)Lnet/minecraft/inventory/Inventory;"))
    private static class_1263 getExtractInventory(class_1937 world, class_2615 hopper) {
        if (!(hopper instanceof HopperBlockEntityMixin)) {
            return HopperBlockEntityMixin.method_11248(world, hopper);
        }
        HopperBlockEntityMixin hopperBlockEntity = (HopperBlockEntityMixin)hopper;
        class_1263 blockInventory = hopperBlockEntity.getExtractBlockInventory(world);
        if (blockInventory != null) {
            return blockInventory;
        }
        if (hopperBlockEntity.extractInventoryEntityTracker == null) {
            hopperBlockEntity.initExtractInventoryTracker(world);
        }
        if (hopperBlockEntity.extractInventoryEntityTracker.isUnchangedSince(hopperBlockEntity.extractInventoryEntityFailedSearchTime)) {
            return null;
        }
        hopperBlockEntity.extractInventoryEntityFailedSearchTime = Long.MIN_VALUE;
        List<class_1263> inventoryEntities = hopperBlockEntity.extractInventoryEntityTracker.getEntities(hopperBlockEntity.extractInventoryEntityBox);
        if (inventoryEntities.isEmpty()) {
            hopperBlockEntity.extractInventoryEntityFailedSearchTime = hopperBlockEntity.field_12022;
            return null;
        }
        class_1263 inventory = inventoryEntities.get(world.field_9229.method_43048(inventoryEntities.size()));
        if (inventory instanceof LithiumInventory) {
            LithiumInventory optimizedInventory = (LithiumInventory)inventory;
            LithiumStackList extractInventoryStackList = InventoryHelper.getLithiumStackList(optimizedInventory);
            if (inventory != hopperBlockEntity.extractInventory || hopperBlockEntity.extractStackList != extractInventoryStackList) {
                hopperBlockEntity.extractInventory = optimizedInventory;
                hopperBlockEntity.extractStackList = extractInventoryStackList;
                hopperBlockEntity.extractStackListModCount = hopperBlockEntity.extractStackList.getModCount() - 1L;
            }
        }
        return inventory;
    }

    @Redirect(method={"insertAndExtract(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;Lnet/minecraft/block/entity/HopperBlockEntity;Ljava/util/function/BooleanSupplier;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/entity/HopperBlockEntity;insert(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;Lnet/minecraft/inventory/Inventory;)Z"))
    private static boolean lithiumInsert(class_1937 world, class_2338 pos, class_2680 hopperState, class_1263 hopper) {
        boolean insertInventoryWasEmptyHopperNotDisabled;
        HopperBlockEntityMixin hopperBlockEntity = (HopperBlockEntityMixin)hopper;
        class_1263 insertInventory = hopperBlockEntity.getInsertInventory(world, hopperState);
        if (insertInventory == null) {
            return HopperBlockEntityMixin.method_11246(world, pos, hopperState, hopper);
        }
        LithiumStackList hopperStackList = InventoryHelper.getLithiumStackList(hopperBlockEntity);
        if (hopperBlockEntity.insertInventory == insertInventory && hopperStackList.getModCount() == hopperBlockEntity.myModCountAtLastInsert && hopperBlockEntity.insertStackList.getModCount() == hopperBlockEntity.insertStackListModCount) {
            return false;
        }
        boolean bl = insertInventoryWasEmptyHopperNotDisabled = insertInventory instanceof HopperBlockEntityMixin && !((HopperBlockEntityMixin)insertInventory).method_11242() && hopperBlockEntity.insertStackList.getOccupiedSlots() == 0;
        if (hopperBlockEntity.insertInventory != insertInventory || hopperBlockEntity.insertStackList.getFullSlots() != hopperBlockEntity.insertStackList.size()) {
            class_2350 fromDirection = ((class_2350)hopperState.method_11654((class_2769)class_2377.field_11129)).method_10153();
            int size = hopperStackList.size();
            for (int i = 0; i < size; ++i) {
                boolean transferSuccess;
                class_1799 transferStack = (class_1799)hopperStackList.get(i);
                if (transferStack.method_7960() || !(transferSuccess = HopperHelper.tryMoveSingleItem(insertInventory, transferStack, fromDirection))) continue;
                if (insertInventoryWasEmptyHopperNotDisabled) {
                    HopperBlockEntityMixin receivingHopper = (HopperBlockEntityMixin)insertInventory;
                    int k = 8;
                    if (receivingHopper.field_12022 >= hopperBlockEntity.field_12022) {
                        k = 7;
                    }
                    receivingHopper.method_11238(k);
                }
                insertInventory.method_5431();
                return true;
            }
        }
        hopperBlockEntity.myModCountAtLastInsert = hopperStackList.getModCount();
        if (hopperBlockEntity.insertStackList != null) {
            hopperBlockEntity.insertStackListModCount = hopperBlockEntity.insertStackList.getModCount();
        }
        return false;
    }

    @Inject(method={"extract(Lnet/minecraft/world/World;Lnet/minecraft/block/entity/Hopper;)Z"}, at={@At(value="FIELD", target="Lnet/minecraft/util/math/Direction;DOWN:Lnet/minecraft/util/math/Direction;", shift=At.Shift.AFTER)}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD)
    private static void lithiumExtract(class_1937 world, class_2615 to, CallbackInfoReturnable<Boolean> cir, class_1263 from) {
        if (!(to instanceof HopperBlockEntityMixin)) {
            return;
        }
        HopperBlockEntityMixin hopperBlockEntity = (HopperBlockEntityMixin)to;
        if (from != hopperBlockEntity.extractInventory) {
            return;
        }
        LithiumStackList hopperStackList = InventoryHelper.getLithiumStackList(hopperBlockEntity);
        LithiumStackList fromStackList = hopperBlockEntity.extractStackList;
        if (hopperStackList.getModCount() == hopperBlockEntity.myModCountAtLastExtract && fromStackList.getModCount() == hopperBlockEntity.extractStackListModCount) {
            fromStackList.runComparatorUpdatePatternOnFailedExtract(fromStackList, from);
            cir.setReturnValue((Object)false);
            return;
        }
        int[] availableSlots = from instanceof class_1278 ? ((class_1278)from).method_5494(class_2350.field_11033) : null;
        int fromSize = availableSlots != null ? availableSlots.length : from.method_5439();
        for (int i = 0; i < fromSize; ++i) {
            int fromSlot = availableSlots != null ? availableSlots[i] : i;
            class_1799 itemStack = (class_1799)fromStackList.get(fromSlot);
            if (itemStack.method_7960() || !HopperBlockEntityMixin.method_11252(from, itemStack, fromSlot, class_2350.field_11033)) continue;
            class_1799 takenItem = from.method_5434(fromSlot, 1);
            assert (!takenItem.method_7960());
            boolean transferSuccess = HopperHelper.tryMoveSingleItem((class_1263)to, takenItem, null);
            if (transferSuccess) {
                to.method_5431();
                from.method_5431();
                cir.setReturnValue((Object)true);
                return;
            }
            class_1799 restoredStack = (class_1799)fromStackList.get(fromSlot);
            if (restoredStack.method_7960()) {
                restoredStack = takenItem;
            } else {
                restoredStack.method_7933(1);
            }
            from.method_5447(fromSlot, restoredStack);
        }
        hopperBlockEntity.myModCountAtLastExtract = hopperStackList.getModCount();
        if (fromStackList != null) {
            hopperBlockEntity.extractStackListModCount = fromStackList.getModCount();
        }
        cir.setReturnValue((Object)false);
    }

    @Redirect(method={"insertAndExtract(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;Lnet/minecraft/block/entity/HopperBlockEntity;Ljava/util/function/BooleanSupplier;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/entity/HopperBlockEntity;isFull()Z"))
    private static boolean lithiumHopperIsFull(class_2614 hopperBlockEntity) {
        LithiumStackList lithiumStackList = InventoryHelper.getLithiumStackList((HopperBlockEntityMixin)hopperBlockEntity);
        return lithiumStackList.getFullSlots() == lithiumStackList.size();
    }

    @Redirect(method={"insertAndExtract(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;Lnet/minecraft/block/entity/HopperBlockEntity;Ljava/util/function/BooleanSupplier;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/entity/HopperBlockEntity;isEmpty()Z"))
    private static boolean lithiumHopperIsEmpty(class_2614 hopperBlockEntity) {
        LithiumStackList lithiumStackList = InventoryHelper.getLithiumStackList((HopperBlockEntityMixin)hopperBlockEntity);
        return lithiumStackList.getOccupiedSlots() == 0;
    }

    @Shadow
    protected abstract void method_11238(int var1);

    @Override
    public void onNeighborUpdate(boolean above) {
        if (above) {
            if (this.extractionMode == HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY || this.extractionMode == HopperCachingState.BlockInventory.BLOCK_STATE) {
                this.invalidateBlockExtractionData();
            }
        } else if (this.insertionMode == HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY || this.insertionMode == HopperCachingState.BlockInventory.BLOCK_STATE) {
            this.invalidateBlockInsertionData();
        }
    }

    @Redirect(method={"insert(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;Lnet/minecraft/inventory/Inventory;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/entity/HopperBlockEntity;getOutputInventory(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;)Lnet/minecraft/inventory/Inventory;"))
    private static class_1263 nullify(class_1937 world, class_2338 pos, class_2680 state) {
        return null;
    }

    @Redirect(method={"extract(Lnet/minecraft/world/World;Lnet/minecraft/block/entity/Hopper;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/entity/HopperBlockEntity;getInputItemEntities(Lnet/minecraft/world/World;Lnet/minecraft/block/entity/Hopper;)Ljava/util/List;"))
    private static List<class_1542> lithiumGetInputItemEntities(class_1937 world, class_2615 hopper) {
        if (!(hopper instanceof HopperBlockEntityMixin)) {
            return class_2614.method_11237((class_1937)world, (class_2615)hopper);
        }
        HopperBlockEntityMixin hopperBlockEntity = (HopperBlockEntityMixin)hopper;
        if (hopperBlockEntity.collectItemEntityTracker == null) {
            hopperBlockEntity.initCollectItemEntityTracker();
        }
        long modCount = InventoryHelper.getLithiumStackList(hopperBlockEntity).getModCount();
        if ((hopperBlockEntity.collectItemEntityTrackerWasEmpty || hopperBlockEntity.myModCountAtLastItemCollect == modCount) && hopperBlockEntity.collectItemEntityTracker.isUnchangedSince(hopperBlockEntity.collectItemEntityAttemptTime)) {
            return Collections.emptyList();
        }
        hopperBlockEntity.myModCountAtLastItemCollect = modCount;
        List<class_1542> itemEntities = hopperBlockEntity.collectItemEntityTracker.getEntities(hopperBlockEntity.collectItemEntityBoxes);
        hopperBlockEntity.collectItemEntityAttemptTime = hopperBlockEntity.field_12022;
        hopperBlockEntity.collectItemEntityTrackerWasEmpty = itemEntities.isEmpty();
        return itemEntities;
    }

    private void cacheInsertBlockInventory(class_1263 insertInventory) {
        assert (!(insertInventory instanceof class_1297));
        if (insertInventory instanceof class_2586 || insertInventory instanceof class_1258) {
            this.insertBlockInventory = insertInventory;
            this.insertionMode = HopperCachingState.BlockInventory.BLOCK_ENTITY;
        } else if (insertInventory == null) {
            this.insertBlockInventory = null;
            this.insertionMode = HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY;
        } else {
            this.insertBlockInventory = insertInventory;
            this.insertionMode = HopperCachingState.BlockInventory.BLOCK_STATE;
        }
        if (insertInventory instanceof LithiumInventory) {
            LithiumInventory optimizedInventory = (LithiumInventory)insertInventory;
            this.cacheInsertLithiumInventory(optimizedInventory);
        } else {
            this.insertInventory = null;
            this.insertStackList = null;
            this.insertStackListModCount = 0L;
            this.insertBlockEntityRemovedCount = this.insertionMode == HopperCachingState.BlockInventory.BLOCK_ENTITY ? ((RemovalCounter)insertInventory).getRemovedCountLithium() : 0;
        }
    }

    private void cacheInsertLithiumInventory(LithiumInventory optimizedInventory) {
        LithiumStackList insertInventoryStackList;
        this.insertInventory = optimizedInventory;
        this.insertStackList = insertInventoryStackList = InventoryHelper.getLithiumStackList(optimizedInventory);
        this.insertStackListModCount = insertInventoryStackList.getModCount() - 1L;
        this.insertBlockEntityRemovedCount = optimizedInventory.getRemovedCountLithium();
    }

    @Overwrite
    private static boolean method_11257(class_1263 inv, class_2350 side) {
        int[] availableSlots = inv instanceof class_1278 ? ((class_1278)inv).method_5494(side) : null;
        int fromSize = availableSlots != null ? availableSlots.length : inv.method_5439();
        for (int i = 0; i < fromSize; ++i) {
            int slot;
            int n = slot = availableSlots != null ? availableSlots[i] : i;
            if (inv.method_5438(slot).method_7960()) continue;
            return false;
        }
        return true;
    }

    private void cacheExtractBlockInventory(class_1263 extractInventory) {
        assert (!(extractInventory instanceof class_1297));
        if (extractInventory instanceof class_2586 || extractInventory instanceof class_1258) {
            this.extractBlockInventory = extractInventory;
            this.extractionMode = HopperCachingState.BlockInventory.BLOCK_ENTITY;
        } else if (extractInventory == null) {
            this.extractBlockInventory = null;
            this.extractionMode = HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY;
        } else {
            this.extractBlockInventory = extractInventory;
            this.extractionMode = HopperCachingState.BlockInventory.BLOCK_STATE;
        }
        if (extractInventory instanceof LithiumInventory) {
            LithiumStackList extractInventoryStackList;
            LithiumInventory optimizedInventory;
            this.extractInventory = optimizedInventory = (LithiumInventory)extractInventory;
            this.extractStackList = extractInventoryStackList = InventoryHelper.getLithiumStackList(optimizedInventory);
            this.extractStackListModCount = extractInventoryStackList.getModCount() - 1L;
            this.extractBlockEntityRemovedCount = optimizedInventory.getRemovedCountLithium();
        } else {
            this.extractInventory = null;
            this.extractStackList = null;
            this.extractStackListModCount = 0L;
            this.extractBlockEntityRemovedCount = this.extractionMode == HopperCachingState.BlockInventory.BLOCK_ENTITY ? ((RemovalCounter)extractInventory).getRemovedCountLithium() : 0;
        }
    }

    public class_1263 getExtractBlockInventory(class_1937 world) {
        class_1263 blockInventory = this.extractBlockInventory;
        if (this.extractionMode == HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY) {
            return null;
        }
        if (this.extractionMode == HopperCachingState.BlockInventory.BLOCK_STATE) {
            return blockInventory;
        }
        if (this.extractionMode == HopperCachingState.BlockInventory.BLOCK_ENTITY && ((RemovalCounter)blockInventory).getRemovedCountLithium() == this.extractBlockEntityRemovedCount) {
            LithiumInventory optimizedInventory = this.extractInventory;
            if (optimizedInventory != null) {
                LithiumStackList insertInventoryStackList = InventoryHelper.getLithiumStackList(optimizedInventory);
                if (insertInventoryStackList == this.extractStackList) {
                    return optimizedInventory;
                }
                this.invalidateBlockExtractionData();
            } else {
                return blockInventory;
            }
        }
        blockInventory = HopperHelper.vanillaGetBlockInventory(world, this.method_11016().method_10084());
        this.cacheExtractBlockInventory(blockInventory);
        return blockInventory;
    }

    public class_1263 getInsertBlockInventory(class_1937 world, class_2680 hopperState) {
        class_1263 blockInventory = this.insertBlockInventory;
        if (this.insertionMode == HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY) {
            return null;
        }
        if (this.insertionMode == HopperCachingState.BlockInventory.BLOCK_STATE) {
            return blockInventory;
        }
        if (this.insertionMode == HopperCachingState.BlockInventory.BLOCK_ENTITY && ((RemovalCounter)blockInventory).getRemovedCountLithium() == this.insertBlockEntityRemovedCount) {
            LithiumInventory optimizedInventory = this.insertInventory;
            if (optimizedInventory != null) {
                LithiumStackList insertInventoryStackList = InventoryHelper.getLithiumStackList(optimizedInventory);
                if (insertInventoryStackList == this.insertStackList) {
                    return optimizedInventory;
                }
                this.invalidateBlockInsertionData();
            } else {
                return blockInventory;
            }
        }
        class_2350 direction = (class_2350)hopperState.method_11654((class_2769)class_2377.field_11129);
        blockInventory = HopperHelper.vanillaGetBlockInventory(world, this.method_11016().method_10093(direction));
        this.cacheInsertBlockInventory(blockInventory);
        return blockInventory;
    }

    public class_1263 getInsertInventory(class_1937 world, class_2680 hopperState) {
        class_1263 blockInventory = this.getInsertBlockInventory(world, hopperState);
        if (blockInventory != null) {
            return blockInventory;
        }
        if (this.insertInventoryEntityTracker == null) {
            this.initInsertInventoryTracker(world, hopperState);
        }
        if (this.insertInventoryEntityTracker.isUnchangedSince(this.insertInventoryEntityFailedSearchTime)) {
            return null;
        }
        this.insertInventoryEntityFailedSearchTime = Long.MIN_VALUE;
        List<class_1263> inventoryEntities = this.insertInventoryEntityTracker.getEntities(this.insertInventoryEntityBox);
        if (inventoryEntities.isEmpty()) {
            this.insertInventoryEntityFailedSearchTime = this.field_12022;
            return null;
        }
        class_1263 inventory = inventoryEntities.get(world.field_9229.method_43048(inventoryEntities.size()));
        if (inventory instanceof LithiumInventory) {
            LithiumInventory optimizedInventory = (LithiumInventory)inventory;
            LithiumStackList insertInventoryStackList = InventoryHelper.getLithiumStackList(optimizedInventory);
            if (inventory != this.insertInventory || this.insertStackList != insertInventoryStackList) {
                this.cacheInsertLithiumInventory(optimizedInventory);
            }
        }
        return inventory;
    }

    private void initCollectItemEntityTracker() {
        assert (this.field_11863 instanceof class_3218);
        ArrayList<class_238> list = new ArrayList<class_238>();
        class_238 encompassingBox = null;
        for (class_238 box : this.method_11262().method_1090()) {
            class_238 offsetBox = box.method_989((double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260());
            list.add(offsetBox);
            if (encompassingBox == null) {
                encompassingBox = offsetBox;
                continue;
            }
            encompassingBox = encompassingBox.method_991(offsetBox);
        }
        list.add(encompassingBox);
        this.collectItemEntityBoxes = list.toArray(new class_238[0]);
        this.collectItemEntityTracker = SectionedItemEntityMovementTracker.registerAt((class_3218)this.field_11863, encompassingBox, class_1542.class);
        this.collectItemEntityAttemptTime = Long.MIN_VALUE;
    }

    private void initExtractInventoryTracker(class_1937 world) {
        assert (world instanceof class_3218);
        class_2338 pos = this.field_11867.method_10093(class_2350.field_11036);
        this.extractInventoryEntityBox = new class_238((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (double)(pos.method_10263() + 1), (double)(pos.method_10264() + 1), (double)(pos.method_10260() + 1));
        this.extractInventoryEntityTracker = SectionedInventoryEntityMovementTracker.registerAt((class_3218)this.field_11863, this.extractInventoryEntityBox, class_1263.class);
        this.extractInventoryEntityFailedSearchTime = Long.MIN_VALUE;
    }

    private void initInsertInventoryTracker(class_1937 world, class_2680 hopperState) {
        assert (world instanceof class_3218);
        class_2350 direction = (class_2350)hopperState.method_11654((class_2769)class_2377.field_11129);
        class_2338 pos = this.field_11867.method_10093(direction);
        this.insertInventoryEntityBox = new class_238((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (double)(pos.method_10263() + 1), (double)(pos.method_10264() + 1), (double)(pos.method_10260() + 1));
        this.insertInventoryEntityTracker = SectionedInventoryEntityMovementTracker.registerAt((class_3218)this.field_11863, this.insertInventoryEntityBox, class_1263.class);
        this.insertInventoryEntityFailedSearchTime = Long.MIN_VALUE;
    }

    public void method_31664(class_2680 state) {
        class_2680 cachedState = this.method_11010();
        super.method_31664(state);
        if (state.method_11654((class_2769)class_2377.field_11129) != cachedState.method_11654((class_2769)class_2377.field_11129)) {
            this.invalidateCachedData();
        }
    }

    public void method_11012() {
        super.method_11012();
        this.invalidateCachedData();
    }

    private void invalidateCachedData() {
        this.invalidateInsertionData();
        this.invalidateExtractionData();
    }

    private void invalidateInsertionData() {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            if (this.insertInventoryEntityTracker != null) {
                this.insertInventoryEntityTracker.unRegister(serverWorld);
                this.insertInventoryEntityTracker = null;
                this.insertInventoryEntityBox = null;
                this.insertInventoryEntityFailedSearchTime = 0L;
            }
        }
        this.invalidateBlockInsertionData();
    }

    private void invalidateBlockInsertionData() {
        this.insertionMode = HopperCachingState.BlockInventory.UNKNOWN;
        this.insertBlockInventory = null;
        this.insertInventory = null;
        this.insertBlockEntityRemovedCount = 0;
        this.insertStackList = null;
        this.insertStackListModCount = 0L;
    }

    private void invalidateExtractionData() {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            if (this.extractInventoryEntityTracker != null) {
                this.extractInventoryEntityTracker.unRegister(serverWorld);
                this.extractInventoryEntityTracker = null;
                this.extractInventoryEntityBox = null;
                this.extractInventoryEntityFailedSearchTime = 0L;
            }
            if (this.collectItemEntityTracker != null) {
                this.collectItemEntityTracker.unRegister(serverWorld);
                this.collectItemEntityTracker = null;
                this.collectItemEntityBoxes = null;
                this.collectItemEntityTrackerWasEmpty = false;
            }
        }
        this.invalidateBlockExtractionData();
    }

    private void invalidateBlockExtractionData() {
        this.extractionMode = HopperCachingState.BlockInventory.UNKNOWN;
        this.extractBlockInventory = null;
        this.extractInventory = null;
        this.extractBlockEntityRemovedCount = 0;
        this.extractStackList = null;
        this.extractStackListModCount = 0L;
    }
}

