/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util.collection;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class Object2IntBiMap<T>
implements Object2IntMap<T> {
    private final Object2IntMap<T> forwards;
    private final Int2ObjectMap<T> backwards;

    public Object2IntBiMap() {
        this(16);
    }

    public Object2IntBiMap(int expected) {
        this(expected, 0.75f);
    }

    public Object2IntBiMap(T defaultForwardsValue) {
        this(16, 0.75f, defaultForwardsValue, -1);
    }

    public Object2IntBiMap(int expected, float loadFactor) {
        this(expected, loadFactor, -1);
    }

    public Object2IntBiMap(int expected, float loadFactor, int defaultBackwardsValue) {
        this(expected, loadFactor, null, defaultBackwardsValue);
    }

    public Object2IntBiMap(int expected, float loadFactor, T defaultForwardsValue, int defaultBackwardsValue) {
        this.forwards = new Object2IntOpenHashMap(expected, loadFactor);
        this.backwards = new Int2ObjectOpenHashMap(expected, loadFactor);
        this.forwards.defaultReturnValue(defaultBackwardsValue);
        this.backwards.defaultReturnValue(defaultForwardsValue);
    }

    public int size() {
        return this.forwards.size();
    }

    public boolean isEmpty() {
        return this.forwards.isEmpty();
    }

    public int getInt(Object o) {
        return this.forwards.getInt(o);
    }

    public T get(int key) {
        return (T)this.backwards.get(key);
    }

    public int getOrDefault(Object key, int defaultValue) {
        return this.forwards.getOrDefault(key, defaultValue);
    }

    public T getOrDefault(int key, T defaultValue) {
        return (T)this.backwards.getOrDefault(key, defaultValue);
    }

    public void defaultReturnValue(int i) {
        this.forwards.defaultReturnValue(i);
    }

    public void defaultReturnValue(T v) {
        this.backwards.defaultReturnValue(v);
    }

    public int defaultReturnValue() {
        return this.forwards.defaultReturnValue();
    }

    public T backwardsDefaultReturnValue() {
        return (T)this.backwards.defaultReturnValue();
    }

    public ObjectSet<Object2IntMap.Entry<T>> object2IntEntrySet() {
        return ObjectSets.unmodifiable((ObjectSet)this.forwards.object2IntEntrySet());
    }

    public ObjectSet<Int2ObjectMap.Entry<T>> int2ObjectEntrySet() {
        return ObjectSets.unmodifiable((ObjectSet)this.backwards.int2ObjectEntrySet());
    }

    public ObjectSet<T> keySet() {
        return this.forwards.keySet();
    }

    public IntCollection values() {
        return this.forwards.values();
    }

    public boolean containsKey(Object o) {
        return this.forwards.containsKey(o);
    }

    public boolean containsValue(int i) {
        return this.backwards.containsKey(i);
    }

    public int put(T key, int value) {
        this.backwards.put(value, key);
        return this.forwards.put(key, value);
    }

    public void putAll(@NotNull Map<? extends T, ? extends Integer> m4) {
        this.forwards.putAll(m4);
        for (Map.Entry<T, Integer> entry : m4.entrySet()) {
            this.backwards.put(entry.getValue().intValue(), entry.getKey());
        }
    }

    public int removeInt(Object key) {
        if (!this.forwards.containsKey(key)) {
            return this.defaultReturnValue();
        }
        int value = this.forwards.getInt(key);
        if (!this.backwards.containsKey(value)) {
            return this.defaultReturnValue();
        }
        this.backwards.remove(value);
        return this.forwards.removeInt(key);
    }

    public int hashCode() {
        return this.forwards.hashCode();
    }

    public String toString() {
        return this.forwards.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Object2IntBiMap that = (Object2IntBiMap)o;
        return Objects.equals(this.forwards, that.forwards) && Objects.equals(this.backwards, that.backwards);
    }
}

