/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util;

import com.github.steveice10.mc.protocol.data.game.entity.player.GameMode;
import com.github.steveice10.mc.protocol.data.game.setting.Difficulty;
import org.geysermc.cumulus.component.DropdownComponent;
import org.geysermc.cumulus.form.CustomForm;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.level.GameRule;
import org.geysermc.geyser.level.WorldManager;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.text.MinecraftLocale;
import org.geysermc.geyser.util.CooldownUtils;

public class SettingsUtils {
    public static CustomForm buildForm(GeyserSession session) {
        boolean showGamerules;
        boolean canModifyServer;
        boolean showClientSettings;
        String language = session.getLocale();
        CustomForm.Builder builder = ((CustomForm.Builder)((CustomForm.Builder)CustomForm.builder().translator(SettingsUtils::translateEntry, language)).title("geyser.settings.title.main")).iconPath("textures/ui/settings_glyph_color_2x.png");
        boolean bl = showClientSettings = session.getPreferencesCache().isAllowShowCoordinates() || CooldownUtils.getDefaultShowCooldown() != CooldownUtils.CooldownType.DISABLED || session.getGeyser().getConfig().isAllowCustomSkulls();
        if (showClientSettings) {
            builder.label("geyser.settings.title.client");
            if (session.getPreferencesCache().isAllowShowCoordinates()) {
                builder.toggle("%createWorldScreen.showCoordinates", session.getPreferencesCache().isPrefersShowCoordinates());
            }
            if (CooldownUtils.getDefaultShowCooldown() != CooldownUtils.CooldownType.DISABLED) {
                DropdownComponent.Builder cooldownDropdown = DropdownComponent.builder("options.attackIndicator");
                cooldownDropdown.option("options.attack.crosshair", session.getPreferencesCache().getCooldownPreference() == CooldownUtils.CooldownType.TITLE);
                cooldownDropdown.option("options.attack.hotbar", session.getPreferencesCache().getCooldownPreference() == CooldownUtils.CooldownType.ACTIONBAR);
                cooldownDropdown.option("options.off", session.getPreferencesCache().getCooldownPreference() == CooldownUtils.CooldownType.DISABLED);
                builder.dropdown(cooldownDropdown);
            }
            if (session.getGeyser().getConfig().isAllowCustomSkulls()) {
                builder.toggle("geyser.settings.option.customSkulls", session.getPreferencesCache().isPrefersCustomSkulls());
            }
        }
        boolean bl2 = canModifyServer = session.getOpPermissionLevel() >= 2 || session.hasPermission("geyser.settings.server");
        if (canModifyServer) {
            builder.label("geyser.settings.title.server");
            DropdownComponent.Builder gamemodeDropdown = DropdownComponent.builder("%createWorldScreen.gameMode.personal");
            for (GameMode gamemode : GameMode.values()) {
                gamemodeDropdown.option("selectWorld.gameMode." + gamemode.name().toLowerCase(), session.getGameMode() == gamemode);
            }
            builder.dropdown(gamemodeDropdown);
            DropdownComponent.Builder difficultyDropdown = DropdownComponent.builder("%options.difficulty");
            for (Enum enum_ : Difficulty.values()) {
                difficultyDropdown.option("%options.difficulty." + enum_.name().toLowerCase(), session.getWorldCache().getDifficulty() == enum_);
            }
            builder.dropdown(difficultyDropdown);
        }
        boolean bl3 = showGamerules = session.getOpPermissionLevel() >= 2 || session.hasPermission("geyser.settings.gamerules");
        if (showGamerules) {
            builder.label("geyser.settings.title.game_rules").translator(MinecraftLocale::getLocaleString);
            WorldManager worldManager = GeyserImpl.getInstance().getWorldManager();
            for (Enum enum_ : GameRule.values()) {
                if (enum_.equals((Object)GameRule.UNKNOWN)) continue;
                if (Boolean.class.equals(((GameRule)enum_).getType())) {
                    builder.toggle("gamerule." + ((GameRule)enum_).getJavaID(), worldManager.getGameRuleBool(session, (GameRule)enum_));
                    continue;
                }
                if (!Integer.class.equals(((GameRule)enum_).getType())) continue;
                builder.input("gamerule." + ((GameRule)enum_).getJavaID(), "", String.valueOf(worldManager.getGameRuleInt(session, (GameRule)enum_)));
            }
        }
        builder.validResultHandler(response -> {
            if (showClientSettings) {
                if (session.getPreferencesCache().isAllowShowCoordinates()) {
                    session.getPreferencesCache().setPrefersShowCoordinates((Boolean)response.next());
                    session.getPreferencesCache().updateShowCoordinates();
                }
                if (CooldownUtils.getDefaultShowCooldown() != CooldownUtils.CooldownType.DISABLED) {
                    CooldownUtils.CooldownType cooldownType = CooldownUtils.CooldownType.VALUES[(Integer)response.next()];
                    session.getPreferencesCache().setCooldownPreference(cooldownType);
                }
                if (session.getGeyser().getConfig().isAllowCustomSkulls()) {
                    session.getPreferencesCache().setPrefersCustomSkulls((Boolean)response.next());
                }
            }
            if (canModifyServer) {
                Difficulty difficulty;
                GameMode gameMode = GameMode.values()[(Integer)response.next()];
                if (gameMode != null && gameMode != session.getGameMode()) {
                    session.getGeyser().getWorldManager().setPlayerGameMode(session, gameMode);
                }
                if ((difficulty = Difficulty.values()[(Integer)response.next()]) != null && difficulty != session.getWorldCache().getDifficulty()) {
                    session.getGeyser().getWorldManager().setDifficulty(session, difficulty);
                }
            }
            if (showGamerules) {
                for (GameRule gamerule : GameRule.VALUES) {
                    int value;
                    if (gamerule.equals((Object)GameRule.UNKNOWN)) continue;
                    if (Boolean.class.equals(gamerule.getType())) {
                        value = ((Boolean)response.next()).booleanValue();
                        if (value == session.getGeyser().getWorldManager().getGameRuleBool(session, gamerule)) continue;
                        session.getGeyser().getWorldManager().setGameRule(session, gamerule.getJavaID(), value != 0);
                        continue;
                    }
                    if (!Integer.class.equals(gamerule.getType()) || (value = Integer.parseInt((String)response.next())) == session.getGeyser().getWorldManager().getGameRuleInt(session, gamerule)) continue;
                    session.getGeyser().getWorldManager().setGameRule(session, gamerule.getJavaID(), value);
                }
            }
        });
        return (CustomForm)builder.build();
    }

    private static String translateEntry(String key, String locale) {
        if (key.startsWith("%")) {
            return key;
        }
        if (key.startsWith("geyser.")) {
            return GeyserLocale.getPlayerLocaleString(key, locale, new Object[0]);
        }
        return MinecraftLocale.getLocaleString(key, locale);
    }
}

