/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.text.GeyserLocale;

public final class LoopbackUtil {
    private static final String checkExemption = "CheckNetIsolation LoopbackExempt -s";
    private static final String loopbackCommand = "CheckNetIsolation LoopbackExempt -a -n='Microsoft.MinecraftUWP_8wekyb3d8bbwe'";
    private static final String minecraftApplication = "S-1-15-2-1958404141-86561845-1752920682-3514627264-368642714-62675701-733520436";
    private static final String startScript = "powershell -Command \"Start-Process 'cmd' -ArgumentList /c,%temp%/loopback_minecraft.bat -Verb runAs\"";

    public static boolean needsLoopback(GeyserLogger logger) {
        String os = System.getProperty("os.name");
        if (os.equalsIgnoreCase("Windows 10") || os.equalsIgnoreCase("Windows 11")) {
            try {
                Process process = Runtime.getRuntime().exec(checkExemption);
                process.waitFor();
                InputStream is = process.getInputStream();
                StringBuilder sb = new StringBuilder();
                while (is.available() != 0) {
                    sb.append((char)is.read());
                }
                return !sb.toString().contains(minecraftApplication);
            }
            catch (Exception e) {
                logger.error("Couldn't detect if loopback has been added on Windows!", e);
                return true;
            }
        }
        return false;
    }

    public static void checkAndApplyLoopback(GeyserLogger geyserLogger) {
        if (LoopbackUtil.needsLoopback(geyserLogger)) {
            try {
                Files.write(Paths.get(System.getenv("temp") + "/loopback_minecraft.bat", new String[0]), loopbackCommand.getBytes(), new OpenOption[0]);
                Runtime.getRuntime().exec(startScript);
                geyserLogger.info("\u00a7b" + GeyserLocale.getLocaleStringLog("geyser.bootstrap.loopback.added", new Object[0]));
            }
            catch (Exception e) {
                e.printStackTrace();
                geyserLogger.error(GeyserLocale.getLocaleStringLog("geyser.bootstrap.loopback.failed", new Object[0]));
            }
        }
    }

    private LoopbackUtil() {
    }
}

