/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.text;

import com.github.steveice10.mc.protocol.data.DefaultComponentSerializer;
import com.github.steveice10.mc.protocol.data.game.scoreboard.TeamColor;
import java.util.EnumMap;
import java.util.Map;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.DummyLegacyHoverEventSerializer;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.text.GsonComponentSerializerWrapper;
import org.geysermc.geyser.text.MinecraftTranslationRegistry;
import org.geysermc.relocate.kyori.adventure.text.Component;
import org.geysermc.relocate.kyori.adventure.text.TextComponent;
import org.geysermc.relocate.kyori.adventure.text.renderer.TranslatableComponentRenderer;
import org.geysermc.relocate.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import org.geysermc.relocate.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.geysermc.relocate.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;

public class MessageTranslator {
    private static final TranslatableComponentRenderer<String> RENDERER = new MinecraftTranslationRegistry();
    private static final GsonComponentSerializer GSON_SERIALIZER;
    private static final Map<TeamColor, String> TEAM_COLORS;
    private static final String BASE = "\u00a7";
    private static final String RESET = "\u00a7r";

    public static String convertMessage(Component message, String locale) {
        try {
            message = RENDERER.render(message, locale);
            String legacy2 = LegacyComponentSerializer.legacySection().serialize(message);
            StringBuilder finalLegacy = new StringBuilder();
            char[] legacyChars = legacy2.toCharArray();
            boolean lastFormatReset = false;
            for (int i = 0; i < legacyChars.length; ++i) {
                char next;
                char legacyChar = legacyChars[i];
                if (legacyChar != '\u00a7' || i >= legacyChars.length - 1) {
                    finalLegacy.append(legacyChar);
                    lastFormatReset = false;
                    continue;
                }
                if ((next = legacyChars[++i]) != 'm' && next != 'n') {
                    if ((next >= '0' && next <= '9' || next >= 'a' && next <= 'f') && !lastFormatReset) {
                        finalLegacy.append(RESET);
                    }
                    finalLegacy.append(BASE).append(next);
                }
                lastFormatReset = next == 'r';
            }
            return finalLegacy.toString();
        }
        catch (Exception e) {
            GeyserImpl.getInstance().getLogger().debug((String)GSON_SERIALIZER.serialize(message));
            GeyserImpl.getInstance().getLogger().error("Failed to parse message", e);
            return "";
        }
    }

    public static String convertMessage(String message, String locale) {
        return MessageTranslator.convertMessage(GSON_SERIALIZER.deserialize(message), locale);
    }

    public static String convertMessage(String message) {
        return MessageTranslator.convertMessage(message, GeyserLocale.getDefaultLocale());
    }

    public static String convertMessage(Component message) {
        return MessageTranslator.convertMessage(message, GeyserLocale.getDefaultLocale());
    }

    public static String convertMessageLenient(String message, String locale) {
        if (message == null) {
            return "";
        }
        if (message.isBlank()) {
            return message;
        }
        try {
            return MessageTranslator.convertMessage(message, locale);
        }
        catch (Exception ignored) {
            Object convertedMessage = MessageTranslator.convertMessage(MessageTranslator.convertToJavaMessage(message), locale);
            if (message.startsWith(RESET) && !((String)convertedMessage).startsWith(RESET)) {
                convertedMessage = RESET + (String)convertedMessage;
            }
            return convertedMessage;
        }
    }

    public static String convertMessageLenient(String message) {
        return MessageTranslator.convertMessageLenient(message, GeyserLocale.getDefaultLocale());
    }

    public static String convertToJavaMessage(String message) {
        TextComponent component = LegacyComponentSerializer.legacySection().deserialize(message);
        return (String)GSON_SERIALIZER.serialize(component);
    }

    public static String convertToPlainText(String message, String locale) {
        if (message == null) {
            return "";
        }
        Component messageComponent = null;
        if (message.startsWith("{") && message.endsWith("}")) {
            try {
                messageComponent = GSON_SERIALIZER.deserialize(message);
                messageComponent = RENDERER.render(messageComponent, locale);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (messageComponent == null) {
            messageComponent = LegacyComponentSerializer.legacySection().deserialize(message);
        }
        return PlainTextComponentSerializer.plainText().serialize(messageComponent);
    }

    public static String toChatColor(TeamColor teamColor) {
        return TEAM_COLORS.getOrDefault((Object)teamColor, "");
    }

    public static boolean isTooLong(String message, GeyserSession session) {
        if (message.length() > 256) {
            session.sendMessage(GeyserLocale.getPlayerLocaleString("geyser.chat.too_long", session.getLocale(), message.length()));
            return true;
        }
        return false;
    }

    public static void init() {
    }

    static {
        TEAM_COLORS = new EnumMap<TeamColor, String>(TeamColor.class);
        TEAM_COLORS.put(TeamColor.RESET, RESET);
        TEAM_COLORS.put(TeamColor.BLACK, "\u00a70");
        TEAM_COLORS.put(TeamColor.DARK_BLUE, "\u00a71");
        TEAM_COLORS.put(TeamColor.DARK_GREEN, "\u00a72");
        TEAM_COLORS.put(TeamColor.DARK_AQUA, "\u00a73");
        TEAM_COLORS.put(TeamColor.DARK_RED, "\u00a74");
        TEAM_COLORS.put(TeamColor.DARK_PURPLE, "\u00a75");
        TEAM_COLORS.put(TeamColor.GOLD, "\u00a76");
        TEAM_COLORS.put(TeamColor.GRAY, "\u00a77");
        TEAM_COLORS.put(TeamColor.DARK_GRAY, "\u00a78");
        TEAM_COLORS.put(TeamColor.BLUE, "\u00a79");
        TEAM_COLORS.put(TeamColor.GREEN, "\u00a7a");
        TEAM_COLORS.put(TeamColor.AQUA, "\u00a7b");
        TEAM_COLORS.put(TeamColor.RED, "\u00a7c");
        TEAM_COLORS.put(TeamColor.LIGHT_PURPLE, "\u00a7d");
        TEAM_COLORS.put(TeamColor.YELLOW, "\u00a7e");
        TEAM_COLORS.put(TeamColor.WHITE, "\u00a7f");
        TEAM_COLORS.put(TeamColor.OBFUSCATED, "\u00a7k");
        TEAM_COLORS.put(TeamColor.BOLD, "\u00a7l");
        TEAM_COLORS.put(TeamColor.STRIKETHROUGH, "\u00a7m");
        TEAM_COLORS.put(TeamColor.ITALIC, "\u00a7o");
        GsonComponentSerializer source = ((GsonComponentSerializer.Builder)DefaultComponentSerializer.get().toBuilder()).legacyHoverEventSerializer(new DummyLegacyHoverEventSerializer()).build();
        GSON_SERIALIZER = new GsonComponentSerializerWrapper(source);
        DefaultComponentSerializer.set(GSON_SERIALIZER);
    }
}

