/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.level;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.ItemStack;
import com.github.steveice10.mc.protocol.data.game.level.particle.BlockParticleData;
import com.github.steveice10.mc.protocol.data.game.level.particle.DustParticleData;
import com.github.steveice10.mc.protocol.data.game.level.particle.FallingDustParticleData;
import com.github.steveice10.mc.protocol.data.game.level.particle.ItemParticleData;
import com.github.steveice10.mc.protocol.data.game.level.particle.Particle;
import com.github.steveice10.mc.protocol.data.game.level.particle.VibrationParticleData;
import com.github.steveice10.mc.protocol.data.game.level.particle.positionsource.BlockPositionSource;
import com.github.steveice10.mc.protocol.data.game.level.particle.positionsource.EntityPositionSource;
import com.github.steveice10.mc.protocol.data.game.level.particle.positionsource.PositionSource;
import com.github.steveice10.mc.protocol.packet.ingame.clientbound.level.ClientboundLevelParticlesPacket;
import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.nbt.NbtMap;
import com.nukkitx.protocol.bedrock.BedrockPacket;
import com.nukkitx.protocol.bedrock.data.LevelEventType;
import com.nukkitx.protocol.bedrock.data.inventory.ItemData;
import com.nukkitx.protocol.bedrock.packet.LevelEventGenericPacket;
import com.nukkitx.protocol.bedrock.packet.LevelEventPacket;
import com.nukkitx.protocol.bedrock.packet.SpawnParticleEffectPacket;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.registry.type.ParticleMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.item.ItemTranslator;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.DimensionUtils;

@Translator(packet=ClientboundLevelParticlesPacket.class)
public class JavaLevelParticlesTranslator
extends PacketTranslator<ClientboundLevelParticlesPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundLevelParticlesPacket packet) {
        Function<Vector3f, BedrockPacket> particleCreateFunction = this.createParticle(session, packet.getParticle());
        if (particleCreateFunction != null) {
            if (packet.getAmount() == 0) {
                Vector3f position = Vector3f.from(packet.getX(), packet.getY(), packet.getZ());
                session.sendUpstreamPacket(particleCreateFunction.apply(position));
            } else {
                ThreadLocalRandom random = ThreadLocalRandom.current();
                for (int i = 0; i < packet.getAmount(); ++i) {
                    double offsetX = random.nextGaussian() * (double)packet.getOffsetX();
                    double offsetY = random.nextGaussian() * (double)packet.getOffsetY();
                    double offsetZ = random.nextGaussian() * (double)packet.getOffsetZ();
                    Vector3f position = Vector3f.from(packet.getX() + offsetX, packet.getY() + offsetY, packet.getZ() + offsetZ);
                    session.sendUpstreamPacket(particleCreateFunction.apply(position));
                }
            }
        } else {
            session.getGeyser().getLogger().debug("Unhandled particle packet: " + packet);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private Function<Vector3f, BedrockPacket> createParticle(GeyserSession session, Particle particle) {
        switch (particle.getType()) {
            case BLOCK: {
                int blockState = session.getBlockMappings().getBedrockBlockId(((BlockParticleData)particle.getData()).getBlockState());
                return position -> {
                    LevelEventPacket packet = new LevelEventPacket();
                    packet.setType(LevelEventType.PARTICLE_CRACK_BLOCK);
                    packet.setPosition((Vector3f)position);
                    packet.setData(blockState);
                    return packet;
                };
            }
            case FALLING_DUST: {
                int blockState = session.getBlockMappings().getBedrockBlockId(((FallingDustParticleData)particle.getData()).getBlockState());
                return position -> {
                    LevelEventPacket packet = new LevelEventPacket();
                    packet.setType(LevelEventType.PARTICLE_FALLING_DUST);
                    packet.setData(blockState);
                    packet.setPosition((Vector3f)position);
                    return packet;
                };
            }
            case ITEM: {
                ItemStack javaItem = ((ItemParticleData)particle.getData()).getItemStack();
                ItemData bedrockItem = ItemTranslator.translateToBedrock(session, javaItem);
                int data = bedrockItem.getId() << 16 | bedrockItem.getDamage();
                return position -> {
                    LevelEventPacket packet = new LevelEventPacket();
                    packet.setType(LevelEventType.PARTICLE_ITEM_BREAK);
                    packet.setData(data);
                    packet.setPosition((Vector3f)position);
                    return packet;
                };
            }
            case DUST: 
            case DUST_COLOR_TRANSITION: {
                DustParticleData data = (DustParticleData)particle.getData();
                int r = (int)(data.getRed() * 255.0f);
                int g2 = (int)(data.getGreen() * 255.0f);
                int b = (int)(data.getBlue() * 255.0f);
                int rgbData = 0xFF000000 | (r & 0xFF) << 16 | (g2 & 0xFF) << 8 | b & 0xFF;
                return position -> {
                    LevelEventPacket packet = new LevelEventPacket();
                    packet.setType(LevelEventType.PARTICLE_FALLING_DUST);
                    packet.setData(rgbData);
                    packet.setPosition((Vector3f)position);
                    return packet;
                };
            }
            case VIBRATION: {
                Vector3f target;
                VibrationParticleData data = (VibrationParticleData)particle.getData();
                PositionSource rgbData = data.getPositionSource();
                if (rgbData instanceof BlockPositionSource) {
                    BlockPositionSource blockPositionSource = (BlockPositionSource)rgbData;
                    target = blockPositionSource.getPosition().toFloat().add(0.5f, 0.5f, 0.5f);
                    return position -> {
                        LevelEventGenericPacket packet = new LevelEventGenericPacket();
                        packet.setEventId(2027);
                        packet.setTag(NbtMap.builder().putCompound("origin", this.buildVec3PositionTag((Vector3f)position)).putCompound("target", this.buildVec3PositionTag(target)).putFloat("speed", 20.0f).putFloat("timeToLive", (float)data.getArrivalTicks() / 20.0f).build());
                        return packet;
                    };
                }
                rgbData = data.getPositionSource();
                if (!(rgbData instanceof EntityPositionSource)) {
                    session.getGeyser().getLogger().debug("Unknown position source " + data.getPositionSource() + " for vibration particle.");
                    return null;
                }
                EntityPositionSource entityPositionSource = (EntityPositionSource)rgbData;
                Entity entity = session.getEntityCache().getEntityByJavaId(entityPositionSource.getEntityId());
                if (entity != null) {
                    target = entity.getPosition().up(entityPositionSource.getYOffset());
                    return position -> {
                        LevelEventGenericPacket packet = new LevelEventGenericPacket();
                        packet.setEventId(2027);
                        packet.setTag(NbtMap.builder().putCompound("origin", this.buildVec3PositionTag((Vector3f)position)).putCompound("target", this.buildVec3PositionTag(target)).putFloat("speed", 20.0f).putFloat("timeToLive", (float)data.getArrivalTicks() / 20.0f).build());
                        return packet;
                    };
                }
                session.getGeyser().getLogger().debug("Unable to find entity with Java Id: " + entityPositionSource.getEntityId() + " for vibration particle.");
                return null;
            }
        }
        ParticleMapping particleMapping = (ParticleMapping)Registries.PARTICLES.get(particle.getType());
        if (particleMapping == null) {
            return null;
        }
        if (particleMapping.levelEventType() != null) {
            return position -> {
                LevelEventPacket packet = new LevelEventPacket();
                packet.setType(particleMapping.levelEventType());
                packet.setPosition((Vector3f)position);
                return packet;
            };
        }
        if (particleMapping.identifier() == null) return null;
        int dimensionId = DimensionUtils.javaToBedrock(session.getDimension());
        return position -> {
            SpawnParticleEffectPacket stringPacket = new SpawnParticleEffectPacket();
            stringPacket.setIdentifier(particleMapping.identifier());
            stringPacket.setDimensionId(dimensionId);
            stringPacket.setPosition((Vector3f)position);
            stringPacket.setMolangVariablesJson(Optional.empty());
            return stringPacket;
        };
    }

    private NbtMap buildVec3PositionTag(Vector3f position) {
        return NbtMap.builder().putString("type", "vec3").putFloat("x", position.getX()).putFloat("y", position.getY()).putFloat("z", position.getZ()).build();
    }
}

