/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.level;

import com.github.steveice10.mc.protocol.data.game.ClientCommand;
import com.github.steveice10.mc.protocol.data.game.entity.player.GameMode;
import com.github.steveice10.mc.protocol.data.game.level.notify.EnterCreditsValue;
import com.github.steveice10.mc.protocol.data.game.level.notify.RainStrengthValue;
import com.github.steveice10.mc.protocol.data.game.level.notify.RespawnScreenValue;
import com.github.steveice10.mc.protocol.data.game.level.notify.ThunderStrengthValue;
import com.github.steveice10.mc.protocol.packet.ingame.clientbound.level.ClientboundGameEventPacket;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.ServerboundClientCommandPacket;
import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.protocol.bedrock.data.GameRuleData;
import com.nukkitx.protocol.bedrock.data.LevelEventType;
import com.nukkitx.protocol.bedrock.data.entity.EntityEventType;
import com.nukkitx.protocol.bedrock.packet.EntityEventPacket;
import com.nukkitx.protocol.bedrock.packet.GameRulesChangedPacket;
import com.nukkitx.protocol.bedrock.packet.LevelEventPacket;
import com.nukkitx.protocol.bedrock.packet.MovePlayerPacket;
import com.nukkitx.protocol.bedrock.packet.PlaySoundPacket;
import com.nukkitx.protocol.bedrock.packet.SetPlayerGameTypePacket;
import com.nukkitx.protocol.bedrock.packet.ShowCreditsPacket;
import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.MinecraftLocale;
import org.geysermc.geyser.translator.inventory.PlayerInventoryTranslator;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;

@Translator(packet=ClientboundGameEventPacket.class)
public class JavaGameEventTranslator
extends PacketTranslator<ClientboundGameEventPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundGameEventPacket packet) {
        SessionPlayerEntity entity = session.getPlayerEntity();
        switch (packet.getNotification()) {
            case START_RAIN: {
                LevelEventPacket startRainPacket = new LevelEventPacket();
                startRainPacket.setType(LevelEventType.START_RAINING);
                startRainPacket.setData(Integer.MAX_VALUE);
                startRainPacket.setPosition(Vector3f.ZERO);
                session.sendUpstreamPacket(startRainPacket);
                session.setRaining(true);
                break;
            }
            case STOP_RAIN: {
                LevelEventPacket stopRainPacket = new LevelEventPacket();
                stopRainPacket.setType(LevelEventType.STOP_RAINING);
                stopRainPacket.setData(0);
                stopRainPacket.setPosition(Vector3f.ZERO);
                session.sendUpstreamPacket(stopRainPacket);
                session.setRaining(false);
                break;
            }
            case RAIN_STRENGTH: {
                boolean isCurrentlyRaining;
                RainStrengthValue value = (RainStrengthValue)packet.getValue();
                boolean bl = isCurrentlyRaining = value.getStrength() > 0.0f;
                if (isCurrentlyRaining == session.isRaining()) break;
                LevelEventPacket changeRainPacket = new LevelEventPacket();
                changeRainPacket.setType(isCurrentlyRaining ? LevelEventType.START_RAINING : LevelEventType.STOP_RAINING);
                changeRainPacket.setData(Integer.MAX_VALUE);
                changeRainPacket.setPosition(Vector3f.ZERO);
                session.sendUpstreamPacket(changeRainPacket);
                session.setRaining(isCurrentlyRaining);
                break;
            }
            case THUNDER_STRENGTH: {
                boolean isCurrentlyThundering;
                ThunderStrengthValue thunderValue = (ThunderStrengthValue)packet.getValue();
                boolean bl = isCurrentlyThundering = thunderValue.getStrength() > 0.0f;
                if (isCurrentlyThundering == session.isThunder()) break;
                LevelEventPacket changeThunderPacket = new LevelEventPacket();
                changeThunderPacket.setType(isCurrentlyThundering ? LevelEventType.START_THUNDERSTORM : LevelEventType.STOP_THUNDERSTORM);
                changeThunderPacket.setData(Integer.MAX_VALUE);
                changeThunderPacket.setPosition(Vector3f.ZERO);
                session.sendUpstreamPacket(changeThunderPacket);
                session.setThunder(isCurrentlyThundering);
                break;
            }
            case CHANGE_GAMEMODE: {
                GameMode gameMode = (GameMode)packet.getValue();
                SetPlayerGameTypePacket playerGameTypePacket = new SetPlayerGameTypePacket();
                playerGameTypePacket.setGamemode(gameMode.ordinal());
                session.sendUpstreamPacket(playerGameTypePacket);
                session.setGameMode(gameMode);
                session.sendAdventureSettings();
                if (session.getPlayerEntity().isOnGround() && gameMode == GameMode.SPECTATOR) {
                    MovePlayerPacket movePlayerPacket = new MovePlayerPacket();
                    movePlayerPacket.setRuntimeEntityId(entity.getGeyserId());
                    movePlayerPacket.setPosition(entity.getPosition());
                    movePlayerPacket.setRotation(entity.getBedrockRotation());
                    movePlayerPacket.setOnGround(false);
                    movePlayerPacket.setMode(MovePlayerPacket.Mode.TELEPORT);
                    movePlayerPacket.setTeleportationCause(MovePlayerPacket.TeleportationCause.UNKNOWN);
                    session.sendUpstreamPacket(movePlayerPacket);
                }
                PlayerInventoryTranslator.updateCraftingGrid(session, session.getPlayerInventory());
                break;
            }
            case ENTER_CREDITS: {
                switch ((EnterCreditsValue)packet.getValue()) {
                    case SEEN_BEFORE: {
                        ServerboundClientCommandPacket javaRespawnPacket = new ServerboundClientCommandPacket(ClientCommand.RESPAWN);
                        session.sendDownstreamPacket(javaRespawnPacket);
                        break;
                    }
                    case FIRST_TIME: {
                        ShowCreditsPacket showCreditsPacket = new ShowCreditsPacket();
                        showCreditsPacket.setStatus(ShowCreditsPacket.Status.START_CREDITS);
                        showCreditsPacket.setRuntimeEntityId(entity.getGeyserId());
                        session.sendUpstreamPacket(showCreditsPacket);
                    }
                }
                break;
            }
            case AFFECTED_BY_ELDER_GUARDIAN: {
                EntityEventPacket eventPacket = new EntityEventPacket();
                eventPacket.setType(EntityEventType.ELDER_GUARDIAN_CURSE);
                eventPacket.setData(0);
                eventPacket.setRuntimeEntityId(entity.getGeyserId());
                session.sendUpstreamPacket(eventPacket);
                break;
            }
            case ENABLE_RESPAWN_SCREEN: {
                GameRulesChangedPacket gamerulePacket = new GameRulesChangedPacket();
                gamerulePacket.getGameRules().add(new GameRuleData<Boolean>("doimmediaterespawn", packet.getValue() == RespawnScreenValue.IMMEDIATE_RESPAWN));
                session.sendUpstreamPacket(gamerulePacket);
                break;
            }
            case INVALID_BED: {
                session.sendMessage(MinecraftLocale.getLocaleString("block.minecraft.spawn.not_valid", session.getLocale()));
                break;
            }
            case ARROW_HIT_PLAYER: {
                PlaySoundPacket arrowSoundPacket = new PlaySoundPacket();
                arrowSoundPacket.setSound("random.orb");
                arrowSoundPacket.setPitch(0.5f);
                arrowSoundPacket.setVolume(0.5f);
                arrowSoundPacket.setPosition(entity.getPosition());
                session.sendUpstreamPacket(arrowSoundPacket);
                break;
            }
        }
    }
}

