/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.level;

import com.github.steveice10.mc.protocol.packet.ingame.clientbound.level.ClientboundExplodePacket;
import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.math.vector.Vector3i;
import com.nukkitx.protocol.bedrock.data.LevelEventType;
import com.nukkitx.protocol.bedrock.data.SoundEvent;
import com.nukkitx.protocol.bedrock.packet.LevelEventPacket;
import com.nukkitx.protocol.bedrock.packet.LevelSoundEventPacket;
import com.nukkitx.protocol.bedrock.packet.SetEntityMotionPacket;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.ChunkUtils;

@Translator(packet=ClientboundExplodePacket.class)
public class JavaExplodeTranslator
extends PacketTranslator<ClientboundExplodePacket> {
    @Override
    public void translate(GeyserSession session, ClientboundExplodePacket packet) {
        for (Vector3i position : packet.getExploded()) {
            Vector3i pos = Vector3i.from(packet.getX() + (float)position.getX(), packet.getY() + (float)position.getY(), packet.getZ() + (float)position.getZ());
            ChunkUtils.updateBlock(session, 0, pos);
        }
        Vector3f pos = Vector3f.from(packet.getX(), packet.getY(), packet.getZ());
        LevelEventPacket levelEventPacket = new LevelEventPacket();
        levelEventPacket.setType(packet.getRadius() >= 2.0f ? LevelEventType.PARTICLE_HUGE_EXPLODE : LevelEventType.PARTICLE_EXPLOSION);
        levelEventPacket.setData(0);
        levelEventPacket.setPosition(pos);
        session.sendUpstreamPacket(levelEventPacket);
        LevelSoundEventPacket levelSoundEventPacket = new LevelSoundEventPacket();
        levelSoundEventPacket.setRelativeVolumeDisabled(false);
        levelSoundEventPacket.setBabySound(false);
        levelSoundEventPacket.setExtraData(-1);
        levelSoundEventPacket.setSound(SoundEvent.EXPLODE);
        levelSoundEventPacket.setIdentifier(":");
        levelSoundEventPacket.setPosition(pos);
        session.sendUpstreamPacket(levelSoundEventPacket);
        if (packet.getPushX() != 0.0f || packet.getPushY() != 0.0f || packet.getPushZ() != 0.0f) {
            SetEntityMotionPacket motionPacket = new SetEntityMotionPacket();
            motionPacket.setRuntimeEntityId(session.getPlayerEntity().getGeyserId());
            motionPacket.setMotion(Vector3f.from(packet.getPushX(), packet.getPushY(), packet.getPushZ()));
            session.sendUpstreamPacket(motionPacket);
        }
    }
}

