/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.level;

import com.github.steveice10.mc.protocol.data.game.level.block.value.BlockValue;
import com.github.steveice10.mc.protocol.data.game.level.block.value.ChestValue;
import com.github.steveice10.mc.protocol.data.game.level.block.value.EndGatewayValue;
import com.github.steveice10.mc.protocol.data.game.level.block.value.GenericBlockValue;
import com.github.steveice10.mc.protocol.data.game.level.block.value.MobSpawnerValue;
import com.github.steveice10.mc.protocol.data.game.level.block.value.NoteBlockValue;
import com.github.steveice10.mc.protocol.data.game.level.block.value.PistonValue;
import com.github.steveice10.mc.protocol.data.game.level.block.value.PistonValueType;
import com.github.steveice10.mc.protocol.packet.ingame.clientbound.level.ClientboundBlockEventPacket;
import com.nukkitx.math.vector.Vector3i;
import com.nukkitx.nbt.NbtMap;
import com.nukkitx.nbt.NbtMapBuilder;
import com.nukkitx.protocol.bedrock.packet.BlockEntityDataPacket;
import com.nukkitx.protocol.bedrock.packet.BlockEventPacket;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import org.geysermc.common.PlatformType;
import org.geysermc.geyser.level.block.BlockStateValues;
import org.geysermc.geyser.level.physics.Direction;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.PistonCache;
import org.geysermc.geyser.translator.level.block.entity.PistonBlockEntity;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;

@Translator(packet=ClientboundBlockEventPacket.class)
public class JavaBlockEventTranslator
extends PacketTranslator<ClientboundBlockEventPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundBlockEventPacket packet) {
        BlockEventPacket blockEventPacket = new BlockEventPacket();
        Vector3i position = packet.getPosition();
        blockEventPacket.setBlockPosition(position);
        BlockValue blockValue = packet.getValue();
        if (blockValue instanceof ChestValue) {
            ChestValue value = (ChestValue)blockValue;
            blockEventPacket.setEventType(1);
            blockEventPacket.setEventData(value.getViewers() > 0 ? 1 : 0);
            session.sendUpstreamPacket(blockEventPacket);
        } else if (packet.getValue() instanceof EndGatewayValue) {
            blockEventPacket.setEventType(1);
            session.sendUpstreamPacket(blockEventPacket);
        } else if (packet.getValue() instanceof NoteBlockValue) {
            int blockState = session.getGeyser().getWorldManager().getBlockAt(session, position);
            blockEventPacket.setEventData(BlockStateValues.getNoteblockPitch(blockState));
            session.sendUpstreamPacket(blockEventPacket);
        } else {
            BlockValue blockState = packet.getValue();
            if (blockState instanceof PistonValue) {
                PistonValue pistonValue = (PistonValue)blockState;
                action = (PistonValueType)packet.getType();
                Direction direction = Direction.fromPistonValue(pistonValue);
                PistonCache pistonCache = session.getPistonCache();
                if (session.getGeyser().getPlatformType() == PlatformType.SPIGOT) {
                    if (action == PistonValueType.PULLING || action == PistonValueType.CANCELLED_MID_PUSH) {
                        PistonBlockEntity blockEntity;
                        int pistonBlock = session.getGeyser().getWorldManager().getBlockAt(session, position);
                        if (!BlockStateValues.isStickyPiston(pistonBlock)) {
                            return;
                        }
                        if (action != PistonValueType.CANCELLED_MID_PUSH) {
                            Vector3i blockInFrontPos = position.add(direction.getUnitVector());
                            int blockInFront = session.getGeyser().getWorldManager().getBlockAt(session, blockInFrontPos);
                            if (blockInFront != 0) {
                                return;
                            }
                        }
                        if ((blockEntity = pistonCache.getPistons().computeIfAbsent(position, pos -> new PistonBlockEntity(session, (Vector3i)pos, direction, true, true))).getAction() != action) {
                            blockEntity.setAction((PistonValueType)action, (Object2IntMap<Vector3i>)Object2IntMaps.emptyMap());
                        }
                    }
                } else {
                    PistonBlockEntity blockEntity = pistonCache.getPistons().computeIfAbsent(position, arg_0 -> JavaBlockEventTranslator.lambda$translate$1(session, position, (PistonValueType)action, direction, arg_0));
                    blockEntity.setAction((PistonValueType)action);
                }
            } else if (packet.getValue() instanceof MobSpawnerValue) {
                blockEventPacket.setEventType(1);
                session.sendUpstreamPacket(blockEventPacket);
            } else if (packet.getValue() instanceof EndGatewayValue) {
                blockEventPacket.setEventType(1);
                session.sendUpstreamPacket(blockEventPacket);
            } else {
                action = packet.getValue();
                if (action instanceof GenericBlockValue) {
                    GenericBlockValue bellValue = (GenericBlockValue)action;
                    if (packet.getBlockId() == BlockStateValues.JAVA_BELL_ID) {
                        BlockEntityDataPacket blockEntityPacket = new BlockEntityDataPacket();
                        blockEntityPacket.setBlockPosition(position);
                        NbtMapBuilder builder = NbtMap.builder();
                        builder.putInt("x", position.getX());
                        builder.putInt("y", position.getY());
                        builder.putInt("z", position.getZ());
                        builder.putString("id", "Bell");
                        int bedrockRingDirection = switch (bellValue.getValue()) {
                            case 3 -> 0;
                            case 4 -> 1;
                            case 5 -> 3;
                            default -> bellValue.getValue();
                        };
                        builder.putInt("Direction", bedrockRingDirection);
                        builder.putByte("Ringing", (byte)1);
                        builder.putInt("Ticks", 0);
                        blockEntityPacket.setData(builder.build());
                        session.sendUpstreamPacket(blockEntityPacket);
                    }
                }
            }
        }
    }

    private static /* synthetic */ PistonBlockEntity lambda$translate$1(GeyserSession session, Vector3i position, PistonValueType action, Direction direction, Vector3i pos) {
        int blockId = session.getGeyser().getWorldManager().getBlockAt(session, position);
        boolean sticky = BlockStateValues.isStickyPiston(blockId);
        boolean extended = action != PistonValueType.PUSHING;
        return new PistonBlockEntity(session, pos, direction, sticky, extended);
    }
}

