/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.inventory;

import com.github.steveice10.mc.protocol.packet.ingame.clientbound.inventory.ClientboundOpenScreenPacket;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.inventory.ServerboundContainerClosePacket;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.InventoryTranslator;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.geyser.util.InventoryUtils;

@Translator(packet=ClientboundOpenScreenPacket.class)
public class JavaOpenScreenTranslator
extends PacketTranslator<ClientboundOpenScreenPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundOpenScreenPacket packet) {
        if (packet.getContainerId() == 0) {
            return;
        }
        InventoryTranslator newTranslator = InventoryTranslator.inventoryTranslator(packet.getType());
        Inventory openInventory = session.getOpenInventory();
        if (newTranslator == null) {
            if (openInventory != null) {
                InventoryUtils.closeInventory(session, openInventory.getId(), true);
            }
            ServerboundContainerClosePacket closeWindowPacket = new ServerboundContainerClosePacket(packet.getContainerId());
            session.sendDownstreamPacket(closeWindowPacket);
            return;
        }
        String name = MessageTranslator.convertMessage(packet.getTitle(), session.getLocale());
        Inventory newInventory = newTranslator.createInventory(name, packet.getContainerId(), packet.getType(), session.getPlayerInventory());
        if (openInventory != null && openInventory.getContainerType() != packet.getType()) {
            InventoryUtils.closeInventory(session, openInventory.getId(), openInventory.getId() != packet.getContainerId());
        }
        session.setInventoryTranslator(newTranslator);
        InventoryUtils.openInventory(session, newInventory);
    }
}

