/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.entity.player;

import com.github.steveice10.mc.auth.data.GameProfile;
import com.github.steveice10.mc.protocol.data.game.PlayerListEntry;
import com.github.steveice10.mc.protocol.data.game.PlayerListEntryAction;
import com.github.steveice10.mc.protocol.packet.ingame.clientbound.ClientboundPlayerInfoPacket;
import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.protocol.bedrock.packet.PlayerListPacket;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.entity.type.player.PlayerEntity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.skin.SkinManager;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;

@Translator(packet=ClientboundPlayerInfoPacket.class)
public class JavaPlayerInfoTranslator
extends PacketTranslator<ClientboundPlayerInfoPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundPlayerInfoPacket packet) {
        if (packet.getAction() != PlayerListEntryAction.ADD_PLAYER && packet.getAction() != PlayerListEntryAction.REMOVE_PLAYER) {
            return;
        }
        PlayerListPacket translate = new PlayerListPacket();
        translate.setAction(packet.getAction() == PlayerListEntryAction.ADD_PLAYER ? PlayerListPacket.Action.ADD : PlayerListPacket.Action.REMOVE);
        block4: for (PlayerListEntry entry : packet.getEntries()) {
            switch (packet.getAction()) {
                case ADD_PLAYER: {
                    String texturesProperty;
                    GameProfile profile = entry.getProfile();
                    boolean self = profile.getId().equals(session.getPlayerEntity().getUuid());
                    PlayerEntity playerEntity = self ? session.getPlayerEntity() : session.getEntityCache().getPlayerEntity(profile.getId());
                    GameProfile.Property textures = profile.getProperty("textures");
                    String string = texturesProperty = textures == null ? null : textures.getValue();
                    if (playerEntity == null) {
                        playerEntity = new PlayerEntity(session, -1, session.getEntityCache().getNextEntityId().incrementAndGet(), profile.getId(), Vector3f.ZERO, Vector3f.ZERO, 0.0f, 0.0f, 0.0f, profile.getName(), texturesProperty);
                        session.getEntityCache().addPlayerEntity(playerEntity);
                    } else {
                        playerEntity.setUsername(profile.getName());
                        playerEntity.setTexturesProperty(texturesProperty);
                    }
                    playerEntity.setPlayerList(true);
                    if (self) {
                        SkinManager.requestAndHandleSkinAndCape(playerEntity, session, skinAndCape -> GeyserImpl.getInstance().getLogger().debug("Loaded Local Bedrock Java Skin Data for " + session.getClientData().getUsername()));
                        continue block4;
                    }
                    playerEntity.setValid(true);
                    PlayerListPacket.Entry playerListEntry = SkinManager.buildCachedEntry(session, playerEntity);
                    translate.getEntries().add(playerListEntry);
                    continue block4;
                }
                case REMOVE_PLAYER: {
                    PlayerEntity entity = session.getEntityCache().removePlayerEntity(entry.getProfile().getId());
                    if (entity != null) {
                        entity.setPlayerList(false);
                    }
                    if (entity == session.getPlayerEntity()) {
                        translate.getEntries().add(new PlayerListPacket.Entry(session.getAuthData().uuid()));
                        continue block4;
                    }
                    translate.getEntries().add(new PlayerListPacket.Entry(entry.getProfile().getId()));
                }
            }
        }
        if (!translate.getEntries().isEmpty()) {
            session.sendUpstreamPacket(translate);
        }
    }
}

