/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java;

import com.github.steveice10.mc.protocol.packet.ingame.clientbound.ClientboundLoginPacket;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.ServerboundCustomPayloadPacket;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.IntTag;
import com.nukkitx.protocol.bedrock.data.GameRuleData;
import com.nukkitx.protocol.bedrock.data.PlayerPermission;
import com.nukkitx.protocol.bedrock.packet.AdventureSettingsPacket;
import com.nukkitx.protocol.bedrock.packet.GameRulesChangedPacket;
import com.nukkitx.protocol.bedrock.packet.SetPlayerGameTypePacket;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Map;
import org.geysermc.floodgate.pluginmessage.PluginMessageChannels;
import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.geyser.level.JavaDimension;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.auth.AuthType;
import org.geysermc.geyser.text.TextDecoration;
import org.geysermc.geyser.translator.level.BiomeTranslator;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.ChunkUtils;
import org.geysermc.geyser.util.DimensionUtils;
import org.geysermc.geyser.util.JavaCodecEntry;
import org.geysermc.geyser.util.PluginMessageUtils;

@Translator(packet=ClientboundLoginPacket.class)
public class JavaLoginTranslator
extends PacketTranslator<ClientboundLoginPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundLoginPacket packet) {
        boolean needsSpawnPacket;
        SessionPlayerEntity entity = session.getPlayerEntity();
        entity.setEntityId(packet.getEntityId());
        Map<String, JavaDimension> dimensions = session.getDimensions();
        dimensions.clear();
        JavaDimension.load(packet.getRegistry(), dimensions);
        Int2ObjectMap<TextDecoration> chatTypes = session.getChatTypes();
        chatTypes.clear();
        for (CompoundTag tag : JavaCodecEntry.iterateAsTag((CompoundTag)packet.getRegistry().get("minecraft:chat_type"))) {
            int id = ((IntTag)tag.get("id")).getValue();
            CompoundTag element = (CompoundTag)tag.get("element");
            CompoundTag chat = (CompoundTag)element.get("chat");
            TextDecoration textDecoration = null;
            if (chat != null) {
                textDecoration = new TextDecoration(chat);
            }
            chatTypes.put(id, textDecoration);
        }
        if (session.isSpawned()) {
            String fakeDim = DimensionUtils.getTemporaryDimension(session.getDimension(), packet.getDimension());
            DimensionUtils.switchDimension(session, fakeDim);
            session.getWorldCache().removeScoreboard();
        }
        session.setWorldName(packet.getWorldName());
        BiomeTranslator.loadServerBiomes(session, packet.getRegistry());
        session.getTagCache().clear();
        session.setGameMode(packet.getGameMode());
        String newDimension = packet.getDimension();
        boolean bl = needsSpawnPacket = !session.isSentSpawnPacket();
        if (needsSpawnPacket) {
            session.setDimension(newDimension);
            session.connect();
            session.getUpstream().sendPostStartGamePackets();
        }
        AdventureSettingsPacket bedrockPacket = new AdventureSettingsPacket();
        bedrockPacket.setUniqueEntityId(session.getPlayerEntity().getGeyserId());
        bedrockPacket.setPlayerPermission(PlayerPermission.MEMBER);
        session.sendUpstreamPacket(bedrockPacket);
        if (!needsSpawnPacket) {
            SetPlayerGameTypePacket playerGameTypePacket = new SetPlayerGameTypePacket();
            playerGameTypePacket.setGamemode(packet.getGameMode().ordinal());
            session.sendUpstreamPacket(playerGameTypePacket);
        }
        entity.setLastDeathPosition(packet.getLastDeathPos());
        entity.updateBedrockMetadata();
        GameRulesChangedPacket gamerulePacket = new GameRulesChangedPacket();
        gamerulePacket.getGameRules().add(new GameRuleData<Boolean>("doimmediaterespawn", !packet.isEnableRespawnScreen()));
        session.sendUpstreamPacket(gamerulePacket);
        session.setReducedDebugInfo(packet.isReducedDebugInfo());
        session.setServerRenderDistance(packet.getViewDistance());
        session.sendJavaClientSettings();
        session.sendDownstreamPacket(new ServerboundCustomPayloadPacket("minecraft:brand", PluginMessageUtils.getGeyserBrandData()));
        if (session.getRemoteAuthType() == AuthType.FLOODGATE) {
            session.sendDownstreamPacket(new ServerboundCustomPayloadPacket("minecraft:register", PluginMessageChannels.getFloodgateRegisterData()));
        }
        if (!newDimension.equals(session.getDimension())) {
            DimensionUtils.switchDimension(session, newDimension);
        } else if (DimensionUtils.isCustomBedrockNetherId() && newDimension.equalsIgnoreCase("minecraft:the_nether")) {
            session.sendFog("minecraft:fog_hell");
        }
        session.setDimensionType(dimensions.get(newDimension));
        ChunkUtils.loadDimension(session);
    }
}

