/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java;

import com.github.steveice10.mc.protocol.packet.login.clientbound.ClientboundLoginDisconnectPacket;
import java.util.List;
import org.geysermc.common.PlatformType;
import org.geysermc.geyser.network.MinecraftProtocol;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.relocate.kyori.adventure.text.Component;
import org.geysermc.relocate.kyori.adventure.text.TextComponent;
import org.geysermc.relocate.kyori.adventure.text.TranslatableComponent;

@Translator(packet=ClientboundLoginDisconnectPacket.class)
public class JavaLoginDisconnectTranslator
extends PacketTranslator<ClientboundLoginDisconnectPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundLoginDisconnectPacket packet) {
        Object disconnectMessage;
        Component disconnectReason = packet.getReason();
        boolean isOutdatedMessage = false;
        Component component = disconnectReason;
        if (component instanceof TranslatableComponent) {
            TranslatableComponent component2 = (TranslatableComponent)component;
            String key = component2.key();
            isOutdatedMessage = "multiplayer.disconnect.incompatible".equals(key) || "multiplayer.disconnect.outdated_client".equals(key) || "multiplayer.disconnect.outdated_server".equals(key) || key.startsWith("Outdated server!");
        } else {
            Component component3 = disconnectReason;
            if (component3 instanceof TextComponent) {
                TextComponent component4 = (TextComponent)component3;
                if (component4.content().startsWith("Outdated server!")) {
                    isOutdatedMessage = true;
                } else {
                    List<Component> children = component4.children();
                    for (int i = 0; i < children.size(); ++i) {
                        TextComponent child;
                        Component component5 = children.get(i);
                        if (!(component5 instanceof TextComponent) || !(child = (TextComponent)component5).content().startsWith("Outdated server!")) continue;
                        isOutdatedMessage = true;
                        break;
                    }
                }
            }
        }
        String serverDisconnectMessage = MessageTranslator.convertMessage(disconnectReason, session.getLocale());
        if (isOutdatedMessage) {
            String locale = session.getLocale();
            PlatformType platform = session.getGeyser().getPlatformType();
            String outdatedType = platform == PlatformType.BUNGEECORD || platform == PlatformType.VELOCITY ? "geyser.network.remote.outdated.proxy" : "geyser.network.remote.outdated.server";
            disconnectMessage = GeyserLocale.getPlayerLocaleString(outdatedType, locale, MinecraftProtocol.getJavaVersions().get(0)) + "\n" + GeyserLocale.getPlayerLocaleString("geyser.network.remote.original_disconnect_message", locale, serverDisconnectMessage);
        } else {
            disconnectMessage = serverDisconnectMessage;
        }
        session.disconnect((String)disconnectMessage);
    }

    @Override
    public boolean shouldExecuteInEventLoop() {
        return false;
    }
}

