/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock.entity.player;

import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.player.ServerboundMovePlayerPosPacket;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.player.ServerboundMovePlayerPosRotPacket;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.player.ServerboundMovePlayerRotPacket;
import com.nukkitx.math.vector.Vector3d;
import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.protocol.bedrock.packet.MoveEntityAbsolutePacket;
import com.nukkitx.protocol.bedrock.packet.MovePlayerPacket;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.geyser.level.BedrockDimension;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;

@Translator(packet=MovePlayerPacket.class)
public class BedrockMovePlayerTranslator
extends PacketTranslator<MovePlayerPacket> {
    @Override
    public void translate(GeyserSession session, MovePlayerPacket packet) {
        boolean rotationChanged;
        SessionPlayerEntity entity = session.getPlayerEntity();
        if (!session.isSpawned()) {
            return;
        }
        if (!session.getUpstream().isInitialized()) {
            MoveEntityAbsolutePacket moveEntityBack = new MoveEntityAbsolutePacket();
            moveEntityBack.setRuntimeEntityId(entity.getGeyserId());
            moveEntityBack.setPosition(entity.getPosition());
            moveEntityBack.setRotation(entity.getBedrockRotation());
            moveEntityBack.setTeleported(true);
            moveEntityBack.setOnGround(true);
            session.sendUpstreamPacketImmediately(moveEntityBack);
            return;
        }
        session.setLastMovementTimestamp(System.currentTimeMillis());
        session.getBookEditCache().checkForSend();
        if (session.getUnconfirmedTeleport() != null) {
            session.confirmTeleport(packet.getPosition().toDouble().sub(0.0f, EntityDefinitions.PLAYER.offset(), 0.0f));
            return;
        }
        float yaw = packet.getRotation().getY();
        float pitch = packet.getRotation().getX();
        float headYaw = packet.getRotation().getY();
        boolean positionChanged = !entity.getPosition().equals(packet.getPosition());
        boolean bl = rotationChanged = entity.getYaw() != yaw || entity.getPitch() != pitch || entity.getHeadYaw() != headYaw;
        if (session.getLookBackScheduledFuture() != null) {
            rotationChanged |= !session.getLookBackScheduledFuture().isDone();
            session.getLookBackScheduledFuture().cancel(false);
            session.setLookBackScheduledFuture(null);
        }
        if (!positionChanged && rotationChanged) {
            ServerboundMovePlayerRotPacket playerRotationPacket = new ServerboundMovePlayerRotPacket(packet.isOnGround(), yaw, pitch);
            entity.setYaw(yaw);
            entity.setPitch(pitch);
            entity.setHeadYaw(headYaw);
            entity.setOnGround(packet.isOnGround());
            session.sendDownstreamPacket(playerRotationPacket);
        } else {
            if (session.getWorldBorder().isPassingIntoBorderBoundaries(packet.getPosition(), true)) {
                return;
            }
            if (this.isValidMove(session, entity.getPosition(), packet.getPosition())) {
                Vector3d position = session.getCollisionManager().adjustBedrockPosition(packet.getPosition(), packet.isOnGround(), packet.getMode() == MovePlayerPacket.Mode.TELEPORT);
                if (position != null) {
                    BedrockDimension bedrockDimension;
                    int voidFloorLocation;
                    int floorY;
                    MinecraftPacket movePacket;
                    if (rotationChanged) {
                        movePacket = new ServerboundMovePlayerPosRotPacket(packet.isOnGround(), position.getX(), position.getY(), position.getZ(), yaw, pitch);
                        entity.setYaw(yaw);
                        entity.setPitch(pitch);
                        entity.setHeadYaw(headYaw);
                    } else {
                        movePacket = new ServerboundMovePlayerPosPacket(packet.isOnGround(), position.getX(), position.getY(), position.getZ());
                    }
                    boolean notMovingUp = entity.getPosition().getY() >= packet.getPosition().getY();
                    entity.setPositionManual(packet.getPosition());
                    entity.setOnGround(packet.isOnGround());
                    session.sendDownstreamPacket(movePacket);
                    if (notMovingUp && (floorY = position.getFloorY()) <= (voidFloorLocation = (bedrockDimension = session.getChunkCache().getBedrockDimension()).minY() - 40) + 2 && floorY >= voidFloorLocation) {
                        entity.setPosition(entity.getPosition().sub(0.0f, 4.0f, 0.0f));
                        MovePlayerPacket movePlayerPacket = new MovePlayerPacket();
                        movePlayerPacket.setRuntimeEntityId(entity.getGeyserId());
                        movePlayerPacket.setPosition(entity.getPosition());
                        movePlayerPacket.setRotation(entity.getBedrockRotation());
                        movePlayerPacket.setMode(MovePlayerPacket.Mode.TELEPORT);
                        movePlayerPacket.setTeleportationCause(MovePlayerPacket.TeleportationCause.BEHAVIOR);
                        session.sendUpstreamPacket(movePlayerPacket);
                    }
                    session.getSkullCache().updateVisibleSkulls();
                }
            } else {
                session.getGeyser().getLogger().debug("Recalculating position...");
                session.getCollisionManager().recalculatePosition();
            }
        }
        if (entity.getLeftParrot() != null) {
            entity.getLeftParrot().moveAbsolute(entity.getPosition(), entity.getYaw(), entity.getPitch(), entity.getHeadYaw(), true, false);
        }
        if (entity.getRightParrot() != null) {
            entity.getRightParrot().moveAbsolute(entity.getPosition(), entity.getYaw(), entity.getPitch(), entity.getHeadYaw(), true, false);
        }
    }

    private boolean isInvalidNumber(float val) {
        return Float.isNaN(val) || Float.isInfinite(val);
    }

    private boolean isValidMove(GeyserSession session, Vector3f currentPosition, Vector3f newPosition) {
        if (this.isInvalidNumber(newPosition.getX()) || this.isInvalidNumber(newPosition.getY()) || this.isInvalidNumber(newPosition.getZ())) {
            return false;
        }
        if (currentPosition.distanceSquared(newPosition) > 300.0f) {
            session.getGeyser().getLogger().debug("\u00a7c" + session.name() + " moved too quickly. current position: " + currentPosition + ", new position: " + newPosition);
            return false;
        }
        return true;
    }
}

