/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock.entity.player;

import com.github.steveice10.mc.protocol.data.game.entity.object.Direction;
import com.github.steveice10.mc.protocol.data.game.entity.player.PlayerAction;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.player.ServerboundPlayerActionPacket;
import com.nukkitx.math.vector.Vector3i;
import com.nukkitx.protocol.bedrock.packet.EmotePacket;
import org.geysermc.geyser.configuration.EmoteOffhandWorkaroundOption;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;

@Translator(packet=EmotePacket.class)
public class BedrockEmoteTranslator
extends PacketTranslator<EmotePacket> {
    @Override
    public void translate(GeyserSession session, EmotePacket packet) {
        if (session.getGeyser().getConfig().getEmoteOffhandWorkaround() != EmoteOffhandWorkaroundOption.DISABLED) {
            ServerboundPlayerActionPacket swapHandsPacket = new ServerboundPlayerActionPacket(PlayerAction.SWAP_HANDS, Vector3i.ZERO, Direction.DOWN, session.getWorldCache().nextPredictionSequence());
            session.sendDownstreamPacket(swapHandsPacket);
            if (session.getGeyser().getConfig().getEmoteOffhandWorkaround() == EmoteOffhandWorkaroundOption.NO_EMOTES) {
                return;
            }
        }
        int javaId = session.getPlayerEntity().getEntityId();
        for (GeyserSession otherSession : session.getGeyser().getSessionManager().getSessions().values()) {
            if (otherSession == session || otherSession.isClosed()) continue;
            if (otherSession.getEventLoop().inEventLoop()) {
                this.playEmote(otherSession, javaId, packet.getEmoteId());
                continue;
            }
            session.executeInEventLoop(() -> this.playEmote(otherSession, javaId, packet.getEmoteId()));
        }
    }

    private void playEmote(GeyserSession otherSession, int javaId, String emoteId) {
        Entity otherEntity = otherSession.getEntityCache().getEntityByJavaId(javaId);
        if (otherEntity == null) {
            return;
        }
        EmotePacket otherEmotePacket = new EmotePacket();
        otherEmotePacket.setEmoteId(emoteId);
        otherEmotePacket.setRuntimeEntityId(otherEntity.getGeyserId());
        otherSession.sendUpstreamPacket(otherEmotePacket);
    }
}

