/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock.entity.player;

import com.github.steveice10.mc.protocol.data.game.entity.object.Direction;
import com.github.steveice10.mc.protocol.data.game.entity.player.GameMode;
import com.github.steveice10.mc.protocol.data.game.entity.player.Hand;
import com.github.steveice10.mc.protocol.data.game.entity.player.InteractAction;
import com.github.steveice10.mc.protocol.data.game.entity.player.PlayerAction;
import com.github.steveice10.mc.protocol.data.game.entity.player.PlayerState;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.player.ServerboundInteractPacket;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.player.ServerboundPlayerAbilitiesPacket;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.player.ServerboundPlayerActionPacket;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.player.ServerboundPlayerCommandPacket;
import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.math.vector.Vector3i;
import com.nukkitx.protocol.bedrock.data.LevelEventType;
import com.nukkitx.protocol.bedrock.data.PlayerActionType;
import com.nukkitx.protocol.bedrock.data.entity.EntityEventType;
import com.nukkitx.protocol.bedrock.data.entity.EntityFlag;
import com.nukkitx.protocol.bedrock.packet.EntityEventPacket;
import com.nukkitx.protocol.bedrock.packet.LevelEventPacket;
import com.nukkitx.protocol.bedrock.packet.PlayStatusPacket;
import com.nukkitx.protocol.bedrock.packet.PlayerActionPacket;
import com.nukkitx.protocol.bedrock.packet.UpdateAttributesPacket;
import org.geysermc.geyser.entity.type.ItemFrameEntity;
import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.BlockUtils;
import org.geysermc.geyser.util.collection.Object2IntBiMap;

@Translator(packet=PlayerActionPacket.class)
public class BedrockActionTranslator
extends PacketTranslator<PlayerActionPacket> {
    @Override
    public void translate(GeyserSession session, PlayerActionPacket packet) {
        SessionPlayerEntity entity = session.getPlayerEntity();
        if (packet.getAction() != PlayerActionType.RESPAWN) {
            session.getBookEditCache().checkForSend();
        }
        Vector3i vector = packet.getBlockPosition();
        switch (packet.getAction()) {
            case RESPAWN: {
                EntityEventPacket eventPacket = new EntityEventPacket();
                eventPacket.setRuntimeEntityId(entity.getGeyserId());
                eventPacket.setType(EntityEventType.RESPAWN);
                eventPacket.setData(0);
                session.sendUpstreamPacket(eventPacket);
                UpdateAttributesPacket attributesPacket = new UpdateAttributesPacket();
                attributesPacket.setRuntimeEntityId(entity.getGeyserId());
                attributesPacket.getAttributes().addAll(entity.getAttributes().values());
                session.sendUpstreamPacket(attributesPacket);
                break;
            }
            case START_SWIMMING: {
                if (entity.getFlag(EntityFlag.SWIMMING)) break;
                ServerboundPlayerCommandPacket startSwimPacket = new ServerboundPlayerCommandPacket(entity.getEntityId(), PlayerState.START_SPRINTING);
                session.sendDownstreamPacket(startSwimPacket);
                session.setSwimming(true);
                break;
            }
            case STOP_SWIMMING: {
                if (session.getCollisionManager().mustPlayerCrawlHere()) break;
                ServerboundPlayerCommandPacket stopSwimPacket = new ServerboundPlayerCommandPacket(entity.getEntityId(), PlayerState.STOP_SPRINTING);
                session.sendDownstreamPacket(stopSwimPacket);
                session.setSwimming(false);
                break;
            }
            case START_GLIDE: {
                ServerboundPlayerAbilitiesPacket playerAbilitiesPacket = new ServerboundPlayerAbilitiesPacket(false);
                session.sendDownstreamPacket(playerAbilitiesPacket);
            }
            case STOP_GLIDE: {
                ServerboundPlayerCommandPacket glidePacket = new ServerboundPlayerCommandPacket(entity.getEntityId(), PlayerState.START_ELYTRA_FLYING);
                session.sendDownstreamPacket(glidePacket);
                break;
            }
            case START_SNEAK: {
                ServerboundPlayerCommandPacket startSneakPacket = new ServerboundPlayerCommandPacket(entity.getEntityId(), PlayerState.START_SNEAKING);
                session.sendDownstreamPacket(startSneakPacket);
                session.startSneaking();
                break;
            }
            case STOP_SNEAK: {
                ServerboundPlayerCommandPacket stopSneakPacket = new ServerboundPlayerCommandPacket(entity.getEntityId(), PlayerState.STOP_SNEAKING);
                session.sendDownstreamPacket(stopSneakPacket);
                session.stopSneaking();
                break;
            }
            case START_SPRINT: {
                if (entity.getFlag(EntityFlag.SWIMMING)) break;
                ServerboundPlayerCommandPacket startSprintPacket = new ServerboundPlayerCommandPacket(entity.getEntityId(), PlayerState.START_SPRINTING);
                session.sendDownstreamPacket(startSprintPacket);
                session.setSprinting(true);
                break;
            }
            case STOP_SPRINT: {
                if (!entity.getFlag(EntityFlag.SWIMMING)) {
                    ServerboundPlayerCommandPacket stopSprintPacket = new ServerboundPlayerCommandPacket(entity.getEntityId(), PlayerState.STOP_SPRINTING);
                    session.sendDownstreamPacket(stopSprintPacket);
                }
                session.setSprinting(false);
                break;
            }
            case DROP_ITEM: {
                ServerboundPlayerActionPacket dropItemPacket = new ServerboundPlayerActionPacket(PlayerAction.DROP_ITEM, vector, Direction.VALUES[packet.getFace()], session.getWorldCache().nextPredictionSequence());
                session.sendDownstreamPacket(dropItemPacket);
                break;
            }
            case STOP_SLEEP: {
                ServerboundPlayerCommandPacket stopSleepingPacket = new ServerboundPlayerCommandPacket(entity.getEntityId(), PlayerState.LEAVE_BED);
                session.sendDownstreamPacket(stopSleepingPacket);
                break;
            }
            case START_BREAK: {
                ServerboundPlayerActionPacket startBreakingPacket;
                if (session.getGameMode() != GameMode.CREATIVE) {
                    int blockState = session.getGeyser().getWorldManager().getBlockAt(session, vector);
                    LevelEventPacket startBreak = new LevelEventPacket();
                    startBreak.setType(LevelEventType.BLOCK_START_BREAK);
                    startBreak.setPosition(vector.toFloat());
                    double breakTime = BlockUtils.getSessionBreakTime(session, BlockRegistries.JAVA_BLOCKS.get(blockState)) * 20.0;
                    startBreak.setData((int)(65535.0 / breakTime));
                    session.setBreakingBlock(blockState);
                    session.sendUpstreamPacket(startBreak);
                }
                Vector3i fireBlockPos = BlockUtils.getBlockPosition(vector, packet.getFace());
                int blockUp = session.getGeyser().getWorldManager().getBlockAt(session, fireBlockPos);
                String identifier = (String)((Object2IntBiMap)BlockRegistries.JAVA_IDENTIFIERS.get()).get(blockUp);
                if (identifier.startsWith("minecraft:fire") || identifier.startsWith("minecraft:soul_fire")) {
                    startBreakingPacket = new ServerboundPlayerActionPacket(PlayerAction.START_DIGGING, fireBlockPos, Direction.VALUES[packet.getFace()], session.getWorldCache().nextPredictionSequence());
                    session.sendDownstreamPacket(startBreakingPacket);
                    if (session.getGameMode() == GameMode.CREATIVE) break;
                }
                startBreakingPacket = new ServerboundPlayerActionPacket(PlayerAction.START_DIGGING, vector, Direction.VALUES[packet.getFace()], session.getWorldCache().nextPredictionSequence());
                session.sendDownstreamPacket(startBreakingPacket);
                break;
            }
            case CONTINUE_BREAK: {
                int breakingBlock;
                if (session.getGameMode() == GameMode.CREATIVE || (breakingBlock = session.getBreakingBlock()) == -1) break;
                Vector3f vectorFloat = vector.toFloat();
                LevelEventPacket continueBreakPacket = new LevelEventPacket();
                continueBreakPacket.setType(LevelEventType.PARTICLE_CRACK_BLOCK);
                continueBreakPacket.setData(session.getBlockMappings().getBedrockBlockId(breakingBlock) | packet.getFace() << 24);
                continueBreakPacket.setPosition(vectorFloat);
                session.sendUpstreamPacket(continueBreakPacket);
                LevelEventPacket updateBreak = new LevelEventPacket();
                updateBreak.setType(LevelEventType.BLOCK_UPDATE_BREAK);
                updateBreak.setPosition(vectorFloat);
                double breakTime = BlockUtils.getSessionBreakTime(session, BlockRegistries.JAVA_BLOCKS.get(breakingBlock)) * 20.0;
                updateBreak.setData((int)(65535.0 / breakTime));
                session.sendUpstreamPacket(updateBreak);
                break;
            }
            case ABORT_BREAK: {
                ItemFrameEntity itemFrameEntity;
                if (session.getGameMode() != GameMode.CREATIVE && (itemFrameEntity = ItemFrameEntity.getItemFrameEntity(session, vector)) != null) {
                    ServerboundInteractPacket interactPacket = new ServerboundInteractPacket(itemFrameEntity.getEntityId(), InteractAction.ATTACK, Hand.MAIN_HAND, session.isSneaking());
                    session.sendDownstreamPacket(interactPacket);
                    break;
                }
                ServerboundPlayerActionPacket abortBreakingPacket = new ServerboundPlayerActionPacket(PlayerAction.CANCEL_DIGGING, vector, Direction.DOWN, session.getWorldCache().nextPredictionSequence());
                session.sendDownstreamPacket(abortBreakingPacket);
                LevelEventPacket stopBreak = new LevelEventPacket();
                stopBreak.setType(LevelEventType.BLOCK_STOP_BREAK);
                stopBreak.setPosition(vector.toFloat());
                stopBreak.setData(0);
                session.setBreakingBlock(-1);
                session.sendUpstreamPacket(stopBreak);
                break;
            }
            case STOP_BREAK: {
                break;
            }
            case DIMENSION_CHANGE_SUCCESS: {
                PlayStatusPacket spawnPacket = new PlayStatusPacket();
                spawnPacket.setStatus(PlayStatusPacket.Status.PLAYER_SPAWN);
                session.sendUpstreamPacket(spawnPacket);
                UpdateAttributesPacket attributesPacket = new UpdateAttributesPacket();
                attributesPacket.setRuntimeEntityId(entity.getGeyserId());
                attributesPacket.getAttributes().addAll(entity.getAttributes().values());
                session.sendUpstreamPacket(attributesPacket);
                session.getEntityCache().updateBossBars();
                break;
            }
            case JUMP: {
                entity.setOnGround(false);
            }
        }
    }
}

