/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock;

import com.nukkitx.protocol.bedrock.packet.SetLocalPlayerAsInitializedPacket;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.auth.AuthType;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.InventoryUtils;
import org.geysermc.geyser.util.LoginEncryptionUtils;

@Translator(packet=SetLocalPlayerAsInitializedPacket.class)
public class BedrockSetLocalPlayerAsInitializedTranslator
extends PacketTranslator<SetLocalPlayerAsInitializedPacket> {
    @Override
    public void translate(GeyserSession session, SetLocalPlayerAsInitializedPacket packet) {
        if (session.getPlayerEntity().getGeyserId() == packet.getRuntimeEntityId() && !session.getUpstream().isInitialized()) {
            session.getUpstream().setInitialized(true);
            if (session.getRemoteAuthType() == AuthType.ONLINE && !session.isLoggedIn()) {
                if (session.getGeyser().getConfig().getSavedUserLogins().contains(session.name())) {
                    if (session.getGeyser().refreshTokenFor(session.name()) == null) {
                        LoginEncryptionUtils.buildAndShowConsentWindow(session);
                    } else {
                        session.getFormCache().resendAllForms();
                    }
                } else {
                    LoginEncryptionUtils.buildAndShowLoginWindow(session);
                }
            }
            if (session.isLoggedIn()) {
                session.getEntityCache().updateBossBars();
                if (session.getOpenInventory() != null && session.getOpenInventory().isPending()) {
                    InventoryUtils.openInventory(session, session.getOpenInventory());
                }
                session.getFormCache().resendAllForms();
            }
        }
    }
}

