/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock;

import com.nukkitx.nbt.NbtMap;
import com.nukkitx.nbt.NbtMapBuilder;
import com.nukkitx.nbt.NbtType;
import com.nukkitx.protocol.bedrock.packet.PositionTrackingDBClientRequestPacket;
import com.nukkitx.protocol.bedrock.packet.PositionTrackingDBServerBroadcastPacket;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.LodestoneCache;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.DimensionUtils;

@Translator(packet=PositionTrackingDBClientRequestPacket.class)
public class BedrockPositionTrackingDBClientRequestTranslator
extends PacketTranslator<PositionTrackingDBClientRequestPacket> {
    @Override
    public void translate(GeyserSession session, PositionTrackingDBClientRequestPacket packet) {
        PositionTrackingDBServerBroadcastPacket broadcastPacket = new PositionTrackingDBServerBroadcastPacket();
        broadcastPacket.setTrackingId(packet.getTrackingId());
        LodestoneCache.LodestonePos pos = session.getLodestoneCache().getPos(packet.getTrackingId());
        if (pos == null) {
            broadcastPacket.setAction(PositionTrackingDBServerBroadcastPacket.Action.NOT_FOUND);
            session.sendUpstreamPacket(broadcastPacket);
            return;
        }
        broadcastPacket.setAction(PositionTrackingDBServerBroadcastPacket.Action.UPDATE);
        NbtMapBuilder builder = NbtMap.builder();
        builder.putInt("dim", DimensionUtils.javaToBedrock(pos.dimension()));
        builder.putString("id", "0x" + String.format("%08X", packet.getTrackingId()));
        builder.putByte("version", (byte)1);
        builder.putByte("status", (byte)0);
        builder.putList("pos", NbtType.INT, pos.x(), pos.y(), pos.z());
        broadcastPacket.setTag(builder.build());
        session.sendUpstreamPacket(broadcastPacket);
    }
}

