/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock;

import com.github.steveice10.mc.protocol.packet.ingame.serverbound.level.ServerboundMoveVehiclePacket;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.level.ServerboundPlayerInputPacket;
import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.protocol.bedrock.packet.PlayerInputPacket;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.entity.type.BoatEntity;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.living.animal.horse.AbstractHorseEntity;
import org.geysermc.geyser.entity.type.living.animal.horse.LlamaEntity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;

@Translator(packet=PlayerInputPacket.class)
public class BedrockPlayerInputTranslator
extends PacketTranslator<PlayerInputPacket> {
    @Override
    public void translate(GeyserSession session, PlayerInputPacket packet) {
        long timeSinceVehicleMove;
        ServerboundPlayerInputPacket playerInputPacket = new ServerboundPlayerInputPacket(packet.getInputMotion().getX(), packet.getInputMotion().getY(), packet.isJumping(), packet.isSneaking());
        session.sendDownstreamPacket(playerInputPacket);
        Entity vehicle = session.getPlayerEntity().getVehicle();
        boolean sendMovement = false;
        if (vehicle instanceof AbstractHorseEntity && !(vehicle instanceof LlamaEntity)) {
            sendMovement = vehicle.isOnGround();
        } else if (vehicle instanceof BoatEntity) {
            if (vehicle.getPassengers().size() == 1) {
                sendMovement = true;
            } else if (session.getPlayerEntity().isRidingInFront()) {
                sendMovement = true;
            }
        }
        if (sendMovement && (timeSinceVehicleMove = System.currentTimeMillis() - session.getLastVehicleMoveTimestamp()) >= 100L) {
            Vector3f vehiclePosition = vehicle.getPosition();
            if (vehicle instanceof BoatEntity) {
                vehiclePosition = vehiclePosition.down(EntityDefinitions.BOAT.offset());
            }
            ServerboundMoveVehiclePacket moveVehiclePacket = new ServerboundMoveVehiclePacket(vehiclePosition.getX(), vehiclePosition.getY(), vehiclePosition.getZ(), vehicle.getYaw() - 90.0f, vehicle.getPitch());
            session.sendDownstreamPacket(moveVehiclePacket);
        }
    }
}

