/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock;

import com.github.steveice10.mc.protocol.packet.ingame.serverbound.ServerboundKeepAlivePacket;
import com.nukkitx.protocol.bedrock.data.AttributeData;
import com.nukkitx.protocol.bedrock.packet.NetworkStackLatencyPacket;
import com.nukkitx.protocol.bedrock.packet.UpdateAttributesPacket;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.geysermc.floodgate.util.DeviceOs;
import org.geysermc.geyser.entity.attribute.GeyserAttributeType;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;

@Translator(packet=NetworkStackLatencyPacket.class)
public class BedrockNetworkStackLatencyTranslator
extends PacketTranslator<NetworkStackLatencyPacket> {
    @Override
    public void translate(GeyserSession session, NetworkStackLatencyPacket packet) {
        long pingId = session.getClientData().getDeviceOs().equals((Object)DeviceOs.PS4) ? packet.getTimestamp() : packet.getTimestamp() / 1000L;
        if (packet.getTimestamp() > 0L) {
            if (session.getGeyser().getConfig().isForwardPlayerPing()) {
                ServerboundKeepAlivePacket keepAlivePacket = new ServerboundKeepAlivePacket(pingId);
                session.sendDownstreamPacket(keepAlivePacket);
            }
            return;
        }
        UpdateAttributesPacket attributesPacket = new UpdateAttributesPacket();
        attributesPacket.setRuntimeEntityId(session.getPlayerEntity().getGeyserId());
        AttributeData attribute = session.getPlayerEntity().getAttributes().get((Object)GeyserAttributeType.EXPERIENCE_LEVEL);
        if (attribute != null) {
            attributesPacket.setAttributes(Collections.singletonList(attribute));
        } else {
            attributesPacket.setAttributes(Collections.singletonList(GeyserAttributeType.EXPERIENCE_LEVEL.getAttribute(0.0f)));
        }
        session.scheduleInEventLoop(() -> session.sendUpstreamPacket(attributesPacket), 500L, TimeUnit.MILLISECONDS);
    }
}

