/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock;

import com.github.steveice10.mc.protocol.packet.ingame.serverbound.level.ServerboundMoveVehiclePacket;
import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.protocol.bedrock.packet.MoveEntityAbsolutePacket;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.entity.type.BoatEntity;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;

@Translator(packet=MoveEntityAbsolutePacket.class)
public class BedrockMoveEntityAbsoluteTranslator
extends PacketTranslator<MoveEntityAbsolutePacket> {
    @Override
    public void translate(GeyserSession session, MoveEntityAbsolutePacket packet) {
        session.setLastVehicleMoveTimestamp(System.currentTimeMillis());
        Entity ridingEntity = session.getPlayerEntity().getVehicle();
        if (ridingEntity != null && session.getWorldBorder().isPassingIntoBorderBoundaries(packet.getPosition(), false)) {
            Vector3f position = Vector3f.from(ridingEntity.getPosition().getX(), packet.getPosition().getY(), ridingEntity.getPosition().getZ());
            if (ridingEntity instanceof BoatEntity) {
                ridingEntity.as(BoatEntity.class).moveAbsoluteWithoutAdjustments(position, ridingEntity.getYaw(), ridingEntity.isOnGround(), true);
            } else {
                ridingEntity.moveAbsolute(position, ridingEntity.getYaw(), ridingEntity.getPitch(), ridingEntity.getHeadYaw(), ridingEntity.isOnGround(), true);
            }
            return;
        }
        float y = packet.getPosition().getY();
        if (ridingEntity instanceof BoatEntity) {
            y -= EntityDefinitions.BOAT.offset();
        }
        ServerboundMoveVehiclePacket ServerboundMoveVehiclePacket2 = new ServerboundMoveVehiclePacket(packet.getPosition().getX(), y, packet.getPosition().getZ(), packet.getRotation().getY() - 90.0f, packet.getRotation().getX());
        session.sendDownstreamPacket(ServerboundMoveVehiclePacket2);
    }
}

