/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.ItemStack;
import com.github.steveice10.mc.protocol.data.game.entity.object.Direction;
import com.github.steveice10.mc.protocol.data.game.entity.player.GameMode;
import com.github.steveice10.mc.protocol.data.game.entity.player.Hand;
import com.github.steveice10.mc.protocol.data.game.entity.player.InteractAction;
import com.github.steveice10.mc.protocol.data.game.entity.player.PlayerAction;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.inventory.ServerboundContainerClickPacket;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.player.ServerboundInteractPacket;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.player.ServerboundMovePlayerPosRotPacket;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.player.ServerboundPlayerActionPacket;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.player.ServerboundSwingPacket;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.player.ServerboundUseItemOnPacket;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.player.ServerboundUseItemPacket;
import com.nukkitx.math.vector.Vector3d;
import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.math.vector.Vector3i;
import com.nukkitx.protocol.bedrock.data.LevelEventType;
import com.nukkitx.protocol.bedrock.data.inventory.ContainerType;
import com.nukkitx.protocol.bedrock.data.inventory.InventoryActionData;
import com.nukkitx.protocol.bedrock.data.inventory.InventorySource;
import com.nukkitx.protocol.bedrock.data.inventory.ItemData;
import com.nukkitx.protocol.bedrock.data.inventory.LegacySetItemSlotData;
import com.nukkitx.protocol.bedrock.packet.ContainerOpenPacket;
import com.nukkitx.protocol.bedrock.packet.InventoryTransactionPacket;
import com.nukkitx.protocol.bedrock.packet.LevelEventPacket;
import com.nukkitx.protocol.bedrock.packet.UpdateBlockPacket;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.ItemFrameEntity;
import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.PlayerInventory;
import org.geysermc.geyser.inventory.click.Click;
import org.geysermc.geyser.level.block.BlockStateValues;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.registry.type.ItemMappings;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.InventoryTranslator;
import org.geysermc.geyser.translator.inventory.item.ItemTranslator;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.BlockUtils;
import org.geysermc.geyser.util.EntityUtils;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.InventoryUtils;

@Translator(packet=InventoryTransactionPacket.class)
public class BedrockInventoryTransactionTranslator
extends PacketTranslator<InventoryTransactionPacket> {
    private static final float MAXIMUM_BLOCK_PLACING_DISTANCE = 64.0f;
    private static final int CREATIVE_EYE_HEIGHT_PLACE_DISTANCE = 49;
    private static final int SURVIVAL_EYE_HEIGHT_PLACE_DISTANCE = 36;
    private static final float MAXIMUM_BLOCK_DESTROYING_DISTANCE = 36.0f;

    @Override
    public void translate(GeyserSession session, InventoryTransactionPacket packet) {
        session.getBookEditCache().checkForSend();
        ItemMappings mappings = session.getItemMappings();
        block0 : switch (packet.getTransactionType()) {
            case NORMAL: {
                boolean dropAll;
                if (packet.getActions().size() != 2) break;
                InventoryActionData worldAction = packet.getActions().get(0);
                InventoryActionData containerAction = packet.getActions().get(1);
                if (worldAction.getSource().getType() != InventorySource.Type.WORLD_INTERACTION || worldAction.getSource().getFlag() != InventorySource.Flag.DROP_ITEM) break;
                boolean bl = dropAll = worldAction.getToItem().getCount() > 1;
                if (session.getPlayerInventory().getHeldItemSlot() != containerAction.getSlot()) {
                    Int2ObjectMap changedItem;
                    Click clickType;
                    PlayerInventory inventory = session.getPlayerInventory();
                    int hotbarSlot = inventory.getOffsetForHotbar(containerAction.getSlot());
                    Click click = clickType = dropAll ? Click.DROP_ALL : Click.DROP_ONE;
                    if (dropAll) {
                        inventory.setItem(hotbarSlot, GeyserItemStack.EMPTY, session);
                        changedItem = Int2ObjectMaps.singleton((int)hotbarSlot, null);
                    } else {
                        GeyserItemStack itemStack = inventory.getItem(hotbarSlot);
                        if (itemStack.isEmpty()) {
                            return;
                        }
                        itemStack.sub(1);
                        changedItem = Int2ObjectMaps.singleton((int)hotbarSlot, (Object)itemStack.getItemStack());
                    }
                    ServerboundContainerClickPacket dropPacket = new ServerboundContainerClickPacket(inventory.getId(), inventory.getStateId(), hotbarSlot, clickType.actionType, clickType.action, inventory.getCursor().getItemStack(), (Int2ObjectMap<ItemStack>)changedItem);
                    session.sendDownstreamPacket(dropPacket);
                    return;
                }
                if (session.getPlayerInventory().getItemInHand().isEmpty()) {
                    return;
                }
                ServerboundPlayerActionPacket dropPacket = new ServerboundPlayerActionPacket(dropAll ? PlayerAction.DROP_ITEM_STACK : PlayerAction.DROP_ITEM, Vector3i.ZERO, Direction.DOWN, session.getWorldCache().nextPredictionSequence());
                session.sendDownstreamPacket(dropPacket);
                if (dropAll) {
                    session.getPlayerInventory().setItemInHand(GeyserItemStack.EMPTY);
                    break;
                }
                session.getPlayerInventory().getItemInHand().sub(1);
                break;
            }
            case INVENTORY_MISMATCH: {
                break;
            }
            case ITEM_USE: {
                switch (packet.getActionType()) {
                    case 0: {
                        ItemMapping handItem;
                        int blockState;
                        ItemFrameEntity itemFrameEntity;
                        Vector3i packetBlockPosition = packet.getBlockPosition();
                        Vector3i blockPos = BlockUtils.getBlockPosition(packetBlockPosition, packet.getBlockFace());
                        if (session.getGeyser().getConfig().isDisableBedrockScaffolding()) {
                            boolean isGodBridging;
                            float yaw = session.getPlayerEntity().getYaw();
                            switch (packet.getBlockFace()) {
                                case 2: {
                                    boolean bl;
                                    if (yaw <= -135.0f || yaw > 135.0f) {
                                        bl = true;
                                        break;
                                    }
                                    bl = false;
                                    break;
                                }
                                case 3: {
                                    boolean bl;
                                    if (yaw <= 45.0f && yaw > -45.0f) {
                                        bl = true;
                                        break;
                                    }
                                    bl = false;
                                    break;
                                }
                                case 4: {
                                    boolean bl;
                                    if (yaw > 45.0f && yaw <= 135.0f) {
                                        bl = true;
                                        break;
                                    }
                                    bl = false;
                                    break;
                                }
                                case 5: {
                                    boolean bl;
                                    if (yaw <= -45.0f && yaw > -135.0f) {
                                        bl = true;
                                        break;
                                    }
                                    bl = false;
                                    break;
                                }
                                default: {
                                    boolean bl = isGodBridging = false;
                                }
                            }
                            if (isGodBridging) {
                                this.restoreCorrectBlock(session, blockPos, packet);
                                return;
                            }
                        }
                        boolean hasAlreadyClicked = (double)(System.currentTimeMillis() - session.getLastInteractionTime()) < 110.0 && (double)packetBlockPosition.distanceSquared(session.getLastInteractionBlockPosition()) < 1.0E-5;
                        session.setLastInteractionBlockPosition(packetBlockPosition);
                        session.setLastInteractionPlayerPosition(session.getPlayerEntity().getPosition());
                        if (hasAlreadyClicked) break;
                        session.setLastInteractionTime(System.currentTimeMillis());
                        if (this.isIncorrectHeldItem(session, packet)) {
                            this.restoreCorrectBlock(session, blockPos, packet);
                            return;
                        }
                        if (session.getBlockMappings().isItemFrame(packet.getBlockRuntimeId()) && (itemFrameEntity = ItemFrameEntity.getItemFrameEntity(session, packet.getBlockPosition())) != null) {
                            this.processEntityInteraction(session, packet, itemFrameEntity);
                            break;
                        }
                        if (!session.getWorldBorder().isInsideBorderBoundaries()) {
                            this.restoreCorrectBlock(session, blockPos, packet);
                            return;
                        }
                        Vector3f playerPosition = session.getPlayerEntity().getPosition();
                        playerPosition = playerPosition.down(EntityDefinitions.PLAYER.offset() - session.getEyeHeight());
                        boolean creative = session.getGameMode() == GameMode.CREATIVE;
                        float diffX = playerPosition.getX() - (float)packetBlockPosition.getX();
                        float diffY = playerPosition.getY() - (float)packetBlockPosition.getY();
                        float diffZ = playerPosition.getZ() - (float)packetBlockPosition.getZ();
                        int n = creative ? 49 : 36;
                        if (diffX * diffX + diffY * diffY + diffZ * diffZ > (float)n) {
                            this.restoreCorrectBlock(session, blockPos, packet);
                            return;
                        }
                        double clickPositionFullX = (double)packetBlockPosition.getX() + (double)packet.getClickPosition().getX();
                        double clickPositionFullY = (double)packetBlockPosition.getY() + (double)packet.getClickPosition().getY();
                        double clickPositionFullZ = (double)packetBlockPosition.getZ() + (double)packet.getClickPosition().getZ();
                        double clickDiffX = (double)playerPosition.getX() - clickPositionFullX;
                        double clickDiffY = (double)playerPosition.getY() - clickPositionFullY;
                        double clickDiffZ = (double)playerPosition.getZ() - clickPositionFullZ;
                        int n2 = creative ? 49 : 36;
                        if (clickDiffX * clickDiffX + clickDiffY * clickDiffY + clickDiffZ * clickDiffZ > (double)n2) {
                            this.restoreCorrectBlock(session, blockPos, packet);
                            return;
                        }
                        Vector3f blockCenter = Vector3f.from((float)packetBlockPosition.getX() + 0.5f, (float)packetBlockPosition.getY() + 0.5f, (float)packetBlockPosition.getZ() + 0.5f);
                        if (!(session.getPlayerEntity().getPosition().sub(0.0f, EntityDefinitions.PLAYER.offset(), 0.0f).distanceSquared(blockCenter) < 64.0f)) {
                            this.restoreCorrectBlock(session, blockPos, packet);
                            return;
                        }
                        double clickDistanceX = clickPositionFullX - (double)blockCenter.getX();
                        double clickDistanceY = clickPositionFullY - (double)blockCenter.getY();
                        double clickDistanceZ = clickPositionFullZ - (double)blockCenter.getZ();
                        if (!(Math.abs(clickDistanceX) < 1.0000001 && Math.abs(clickDistanceY) < 1.0000001 && Math.abs(clickDistanceZ) < 1.0000001)) {
                            this.restoreCorrectBlock(session, blockPos, packet);
                            return;
                        }
                        if (packet.getItemInHand() != null && session.getItemMappings().getSpawnEggIds().contains(packet.getItemInHand().getId()) && (blockState = session.getGeyser().getWorldManager().getBlockAt(session, packet.getBlockPosition())) == BlockStateValues.JAVA_WATER_ID) {
                            this.useItem(session, packet, blockState);
                            break;
                        }
                        ServerboundUseItemOnPacket blockPacket = new ServerboundUseItemOnPacket(packet.getBlockPosition(), Direction.VALUES[packet.getBlockFace()], Hand.MAIN_HAND, packet.getClickPosition().getX(), packet.getClickPosition().getY(), packet.getClickPosition().getZ(), false, session.getWorldCache().nextPredictionSequence());
                        session.sendDownstreamPacket(blockPacket);
                        if (packet.getItemInHand() != null) {
                            int itemId = packet.getItemInHand().getId();
                            int blockState2 = session.getGeyser().getWorldManager().getBlockAt(session, packet.getBlockPosition());
                            if (session.getItemMappings().getBoatIds().contains(itemId) || itemId == session.getItemMappings().getStoredItems().lilyPad() || itemId == session.getItemMappings().getStoredItems().frogspawn()) {
                                this.useItem(session, packet, blockState2);
                            } else if (itemId == session.getItemMappings().getStoredItems().glassBottle()) {
                                if (!session.isSneaking() && BlockStateValues.isCauldron(blockState2) && !BlockStateValues.isNonWaterCauldron(blockState2)) {
                                    return;
                                }
                                this.useItem(session, packet, blockState2);
                            } else if (session.getItemMappings().getBucketIds().contains(itemId)) {
                                if (itemId != session.getItemMappings().getStoredItems().powderSnowBucket().getBedrockId()) {
                                    if (!session.isSneaking() && BlockStateValues.isCauldron(blockState2)) {
                                        return;
                                    }
                                    session.setPlacedBucket(this.useItem(session, packet, blockState2));
                                } else {
                                    session.setPlacedBucket(true);
                                }
                            }
                        }
                        if (packet.getActions().isEmpty() && session.getOpPermissionLevel() >= 2 && session.getGameMode() == GameMode.CREATIVE && session.getBlockMappings().getJigsawStateIds().contains(packet.getBlockRuntimeId())) {
                            ContainerOpenPacket openPacket = new ContainerOpenPacket();
                            openPacket.setBlockPosition(packet.getBlockPosition());
                            openPacket.setId((byte)1);
                            openPacket.setType(ContainerType.JIGSAW_EDITOR);
                            openPacket.setUniqueEntityId(-1L);
                            session.sendUpstreamPacket(openPacket);
                        }
                        if ((handItem = session.getPlayerInventory().getItemInHand().getMapping(session)).isBlock()) {
                            session.setLastBlockPlacePosition(blockPos);
                            session.setLastBlockPlacedId(handItem.getJavaIdentifier());
                        }
                        session.setInteracting(true);
                        break;
                    }
                    case 1: {
                        if (this.isIncorrectHeldItem(session, packet)) {
                            InventoryTranslator.PLAYER_INVENTORY_TRANSLATOR.updateSlot(session, session.getPlayerInventory(), session.getPlayerInventory().getOffsetForHotbar(packet.getHotbarSlot()));
                            break;
                        }
                        if (session.getPlayerInventory().getItemInHand().getJavaId() == mappings.getStoredItems().shield().getJavaId() || packet.getItemInHand() != null && (session.getItemMappings().getBucketIds().contains(packet.getItemInHand().getId()) && packet.getItemInHand().getId() != session.getItemMappings().getStoredItems().milkBucket().getBedrockId() || session.getItemMappings().getSpawnEggIds().contains(packet.getItemInHand().getId()) || packet.getItemInHand().getId() == session.getItemMappings().getStoredItems().glassBottle())) break;
                        ServerboundUseItemPacket useItemPacket = new ServerboundUseItemPacket(Hand.MAIN_HAND, session.getWorldCache().nextPredictionSequence());
                        session.sendDownstreamPacket(useItemPacket);
                        List<LegacySetItemSlotData> legacySlots = packet.getLegacySlots();
                        if (packet.getActions().size() != 1 || legacySlots.size() <= 0) break block0;
                        InventoryActionData actionData = packet.getActions().get(0);
                        LegacySetItemSlotData slotData = legacySlots.get(0);
                        if (slotData.getContainerId() != 6 || actionData.getToItem().getId() == 0) break block0;
                        if (session.getGeyser().getConfig().isAlwaysQuickChangeArmor()) {
                            int bedrockHotbarSlot = packet.getHotbarSlot();
                            Click click = InventoryUtils.getClickForHotbarSwap(bedrockHotbarSlot);
                            if (click == null || slotData.getSlots().length == 0) break block0;
                            PlayerInventory playerInventory = session.getPlayerInventory();
                            int armorSlot = slotData.getSlots()[0] + 5;
                            GeyserItemStack armorSlotItem = playerInventory.getItem(armorSlot);
                            GeyserItemStack hotbarItem = playerInventory.getItem(((Inventory)playerInventory).getOffsetForHotbar(bedrockHotbarSlot));
                            playerInventory.setItem(armorSlot, hotbarItem, session);
                            playerInventory.setItem(bedrockHotbarSlot, armorSlotItem, session);
                            Int2ObjectOpenHashMap changedSlots = new Int2ObjectOpenHashMap(2);
                            changedSlots.put(armorSlot, (Object)hotbarItem.getItemStack());
                            changedSlots.put(bedrockHotbarSlot, (Object)armorSlotItem.getItemStack());
                            ServerboundContainerClickPacket clickPacket = new ServerboundContainerClickPacket(playerInventory.getId(), playerInventory.getStateId(), armorSlot, click.actionType, click.action, null, (Int2ObjectMap<ItemStack>)changedSlots);
                            session.sendDownstreamPacket(clickPacket);
                            break;
                        }
                        session.getInventoryTranslator().updateInventory(session, session.getPlayerInventory());
                        break;
                    }
                    case 2: {
                        float diffZ;
                        float diffY;
                        int blockState = session.getGameMode() == GameMode.CREATIVE ? session.getGeyser().getWorldManager().getBlockAt(session, packet.getBlockPosition()) : session.getBreakingBlock();
                        session.setLastBlockPlacedId(null);
                        session.setLastBlockPlacePosition(null);
                        if (!session.getWorldBorder().isInsideBorderBoundaries()) {
                            this.restoreCorrectBlock(session, packet.getBlockPosition(), packet);
                            return;
                        }
                        Vector3f playerPosition = session.getPlayerEntity().getPosition();
                        Vector3f floatBlockPosition = packet.getBlockPosition().toFloat();
                        float diffX = playerPosition.getX() - (floatBlockPosition.getX() + 0.5f);
                        float distanceSquared = diffX * diffX + (diffY = playerPosition.getY() - EntityDefinitions.PLAYER.offset() - (floatBlockPosition.getY() + 0.5f) + 1.5f) * diffY + (diffZ = playerPosition.getZ() - (floatBlockPosition.getZ() + 0.5f)) * diffZ;
                        if (distanceSquared > 36.0f) {
                            this.restoreCorrectBlock(session, packet.getBlockPosition(), packet);
                            return;
                        }
                        int sequence = session.getWorldCache().nextPredictionSequence();
                        if (blockState != -1) {
                            session.getWorldCache().addServerCorrectBlockState(packet.getBlockPosition(), blockState);
                        } else {
                            blockState = 0;
                            session.getWorldCache().addServerCorrectBlockState(packet.getBlockPosition(), session.getGeyser().getWorldManager().getBlockAt(session, packet.getBlockPosition()));
                        }
                        LevelEventPacket blockBreakPacket = new LevelEventPacket();
                        blockBreakPacket.setType(LevelEventType.PARTICLE_DESTROY_BLOCK);
                        blockBreakPacket.setPosition(packet.getBlockPosition().toFloat());
                        blockBreakPacket.setData(session.getBlockMappings().getBedrockBlockId(blockState));
                        session.sendUpstreamPacket(blockBreakPacket);
                        session.setBreakingBlock(-1);
                        ItemFrameEntity itemFrameEntity = ItemFrameEntity.getItemFrameEntity(session, packet.getBlockPosition());
                        if (itemFrameEntity != null) {
                            ServerboundInteractPacket attackPacket = new ServerboundInteractPacket(itemFrameEntity.getEntityId(), InteractAction.ATTACK, session.isSneaking());
                            session.sendDownstreamPacket(attackPacket);
                            break;
                        }
                        PlayerAction action = session.getGameMode() == GameMode.CREATIVE ? PlayerAction.START_DIGGING : PlayerAction.FINISH_DIGGING;
                        ServerboundPlayerActionPacket breakPacket = new ServerboundPlayerActionPacket(action, packet.getBlockPosition(), Direction.VALUES[packet.getBlockFace()], sequence);
                        session.sendDownstreamPacket(breakPacket);
                    }
                }
                break;
            }
            case ITEM_RELEASE: {
                if (packet.getActionType() != 0) break;
                ServerboundPlayerActionPacket releaseItemPacket = new ServerboundPlayerActionPacket(PlayerAction.RELEASE_USE_ITEM, Vector3i.ZERO, Direction.DOWN, session.getWorldCache().nextPredictionSequence());
                session.sendDownstreamPacket(releaseItemPacket);
                break;
            }
            case ITEM_USE_ON_ENTITY: {
                Entity entity = session.getEntityCache().getEntityByGeyserId(packet.getRuntimeEntityId());
                if (entity == null) {
                    return;
                }
                switch (packet.getActionType()) {
                    case 0: {
                        this.processEntityInteraction(session, packet, entity);
                        break block0;
                    }
                    case 1: {
                        int entityId = entity.getDefinition() == EntityDefinitions.ENDER_DRAGON ? entity.getEntityId() + 3 : entity.getEntityId();
                        ServerboundInteractPacket attackPacket = new ServerboundInteractPacket(entityId, InteractAction.ATTACK, session.isSneaking());
                        session.sendDownstreamPacket(attackPacket);
                    }
                }
            }
        }
    }

    private void processEntityInteraction(GeyserSession session, InventoryTransactionPacket packet, Entity entity) {
        Vector3f entityPosition = entity.getPosition();
        if (!session.getWorldBorder().isInsideBorderBoundaries(entityPosition)) {
            return;
        }
        Vector3f clickPosition = packet.getClickPosition().sub(entityPosition);
        boolean isSpectator = session.getGameMode() == GameMode.SPECTATOR;
        for (Hand hand : EntityUtils.HANDS) {
            session.sendDownstreamPacket(new ServerboundInteractPacket(entity.getEntityId(), InteractAction.INTERACT_AT, clickPosition.getX(), clickPosition.getY(), clickPosition.getZ(), hand, session.isSneaking()));
            InteractionResult result = isSpectator ? InteractionResult.PASS : entity.interactAt(hand);
            if (!result.consumesAction()) {
                session.sendDownstreamPacket(new ServerboundInteractPacket(entity.getEntityId(), InteractAction.INTERACT, hand, session.isSneaking()));
                if (!isSpectator) {
                    result = entity.interact(hand);
                }
            }
            if (!result.consumesAction()) continue;
            if (result.shouldSwing() && hand == Hand.OFF_HAND) {
                session.sendDownstreamPacket(new ServerboundSwingPacket(hand));
            }
            return;
        }
    }

    private void restoreCorrectBlock(GeyserSession session, Vector3i blockPos, InventoryTransactionPacket packet) {
        int javaBlockState = session.getGeyser().getWorldManager().getBlockAt(session, blockPos);
        UpdateBlockPacket updateBlockPacket = new UpdateBlockPacket();
        updateBlockPacket.setDataLayer(0);
        updateBlockPacket.setBlockPosition(blockPos);
        updateBlockPacket.setRuntimeId(session.getBlockMappings().getBedrockBlockId(javaBlockState));
        updateBlockPacket.getFlags().addAll(UpdateBlockPacket.FLAG_ALL_PRIORITY);
        session.sendUpstreamPacket(updateBlockPacket);
        UpdateBlockPacket updateWaterPacket = new UpdateBlockPacket();
        updateWaterPacket.setDataLayer(1);
        updateWaterPacket.setBlockPosition(blockPos);
        updateWaterPacket.setRuntimeId(((IntSet)BlockRegistries.WATERLOGGED.get()).contains(javaBlockState) ? session.getBlockMappings().getBedrockWaterId() : session.getBlockMappings().getBedrockAirId());
        updateWaterPacket.getFlags().addAll(UpdateBlockPacket.FLAG_ALL_PRIORITY);
        session.sendUpstreamPacket(updateWaterPacket);
        InventoryTranslator.PLAYER_INVENTORY_TRANSLATOR.updateSlot(session, session.getPlayerInventory(), session.getPlayerInventory().getOffsetForHotbar(packet.getHotbarSlot()));
    }

    private boolean isIncorrectHeldItem(GeyserSession session, InventoryTransactionPacket packet) {
        int heldItemId;
        int javaSlot = session.getPlayerInventory().getOffsetForHotbar(packet.getHotbarSlot());
        int expectedItemId = ItemTranslator.getBedrockItemMapping(session, session.getPlayerInventory().getItem(javaSlot)).getBedrockId();
        int n = heldItemId = packet.getItemInHand() == null ? ItemData.AIR.getId() : packet.getItemInHand().getId();
        if (expectedItemId != heldItemId) {
            session.getGeyser().getLogger().debug(session.name() + "'s held item has desynced! Expected: " + expectedItemId + " Received: " + heldItemId);
            session.getGeyser().getLogger().debug("Packet: " + packet);
            return true;
        }
        return false;
    }

    private boolean useItem(GeyserSession session, InventoryTransactionPacket packet, int blockState) {
        PlayerInventory playerInventory = session.getPlayerInventory();
        int heldItemSlot = ((Inventory)playerInventory).getOffsetForHotbar(packet.getHotbarSlot());
        InventoryTranslator.PLAYER_INVENTORY_TRANSLATOR.updateSlot(session, playerInventory, heldItemSlot);
        if (playerInventory.getItem(heldItemSlot).getAmount() > 1 && (packet.getItemInHand().getId() == session.getItemMappings().getStoredItems().bucket() || packet.getItemInHand().getId() == session.getItemMappings().getStoredItems().glassBottle())) {
            for (int i = 0; i < 36; ++i) {
                int slot = i;
                if (i < 9) {
                    slot = ((Inventory)playerInventory).getOffsetForHotbar(slot);
                }
                if (!playerInventory.getItem(slot).isEmpty()) continue;
                InventoryTranslator.PLAYER_INVENTORY_TRANSLATOR.updateSlot(session, playerInventory, slot);
                break;
            }
        }
        if (!session.isSneaking()) {
            boolean mayBuild;
            if (((IntSet)BlockRegistries.INTERACTIVE.get()).contains(blockState)) {
                return false;
            }
            boolean bl = mayBuild = session.getGameMode() == GameMode.SURVIVAL || session.getGameMode() == GameMode.CREATIVE;
            if (mayBuild && ((IntSet)BlockRegistries.INTERACTIVE_MAY_BUILD.get()).contains(blockState)) {
                return false;
            }
        }
        Vector3f target = packet.getBlockPosition().toFloat().add(packet.getClickPosition());
        this.lookAt(session, target);
        ServerboundUseItemPacket itemPacket = new ServerboundUseItemPacket(Hand.MAIN_HAND, session.getWorldCache().nextPredictionSequence());
        session.sendDownstreamPacket(itemPacket);
        return true;
    }

    private void lookAt(GeyserSession session, Vector3f target) {
        Vector3d playerPosition = session.getCollisionManager().getPlayerBoundingBox().getBottomCenter();
        float xDiff = (float)((double)target.getX() - playerPosition.getX());
        float yDiff = (float)((double)target.getY() - (playerPosition.getY() + (double)session.getEyeHeight()));
        float zDiff = (float)((double)target.getZ() - playerPosition.getZ());
        float yaw = (float)(-Math.toDegrees(Math.atan2(xDiff, zDiff)));
        double xzHypot = Math.sqrt(xDiff * xDiff + zDiff * zDiff);
        float pitch = (float)(-Math.toDegrees(Math.atan2(yDiff, xzHypot)));
        SessionPlayerEntity entity = session.getPlayerEntity();
        ServerboundMovePlayerPosRotPacket returnPacket = new ServerboundMovePlayerPosRotPacket(entity.isOnGround(), playerPosition.getX(), playerPosition.getY(), playerPosition.getZ(), entity.getYaw(), entity.getPitch());
        ServerboundMovePlayerPosRotPacket movementPacket = new ServerboundMovePlayerPosRotPacket(entity.isOnGround(), playerPosition.getX(), playerPosition.getY(), playerPosition.getZ(), yaw, pitch);
        session.sendDownstreamPacket(movementPacket);
        if (session.getLookBackScheduledFuture() != null) {
            session.getLookBackScheduledFuture().cancel(false);
        }
        if (Math.abs(entity.getYaw() - yaw) > 1.0f || Math.abs(entity.getPitch() - pitch) > 1.0f) {
            session.setLookBackScheduledFuture(session.scheduleInEventLoop(() -> {
                Vector3d newPlayerPosition = session.getCollisionManager().getPlayerBoundingBox().getBottomCenter();
                if (!newPlayerPosition.equals(playerPosition) || entity.getYaw() != returnPacket.getYaw() || entity.getPitch() != returnPacket.getPitch()) {
                    return;
                }
                session.sendDownstreamPacket(returnPacket);
            }, 150L, TimeUnit.MILLISECONDS));
        }
    }
}

