/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock;

import com.github.steveice10.mc.protocol.data.game.entity.player.GameMode;
import com.github.steveice10.mc.protocol.data.game.entity.type.EntityType;
import com.nukkitx.protocol.bedrock.packet.EntityPickRequestPacket;
import java.util.Locale;
import org.geysermc.geyser.entity.type.BoatEntity;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.InventoryUtils;

@Translator(packet=EntityPickRequestPacket.class)
public class BedrockEntityPickRequestTranslator
extends PacketTranslator<EntityPickRequestPacket> {
    @Override
    public void translate(GeyserSession session, EntityPickRequestPacket packet) {
        if (session.getGameMode() != GameMode.CREATIVE) {
            return;
        }
        Entity entity = session.getEntityCache().getEntityByGeyserId(packet.getRuntimeEntityId());
        if (entity == null) {
            return;
        }
        String fullItemName = "minecraft:" + (String)(switch (entity.getDefinition().entityType()) {
            case EntityType.BOAT, EntityType.CHEST_BOAT -> {
                int variant = ((BoatEntity)entity).getVariant();
                String v0 = switch (variant) {
                    case 1 -> "spruce";
                    case 2 -> "birch";
                    case 3 -> "jungle";
                    case 4 -> "acacia";
                    case 5 -> "dark_oak";
                    case 6 -> "mangrove";
                    default -> "oak";
                };
                String typeOfBoat = v0;
                yield typeOfBoat + "_" + entity.getDefinition().entityType().name().toLowerCase(Locale.ROOT);
            }
            case EntityType.LEASH_KNOT -> "lead";
            case EntityType.CHEST_MINECART, EntityType.COMMAND_BLOCK_MINECART, EntityType.FURNACE_MINECART, EntityType.HOPPER_MINECART, EntityType.TNT_MINECART -> entity.getDefinition().identifier();
            case EntityType.SPAWNER_MINECART -> "minecart";
            case EntityType.ARMOR_STAND, EntityType.END_CRYSTAL, EntityType.MINECART, EntityType.PAINTING -> entity.getDefinition().entityType().toString().toLowerCase(Locale.ROOT);
            default -> entity.getDefinition().entityType().toString().toLowerCase(Locale.ROOT) + "_spawn_egg";
        });
        ItemMapping mapping = session.getItemMappings().getMapping(fullItemName);
        if (mapping == null) {
            return;
        }
        InventoryUtils.findOrCreateItem(session, fullItemName);
    }
}

